/*
 * Decompiled with CFR 0.152.
 */
package uk.betacraft.auth;

import com.google.gson.Gson;
import com.nukley.tls.CustomTlsSocketFactory;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jsse.provider.BouncyCastleJsseProvider;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import uk.betacraft.auth.Request;
import uk.betacraft.util.WebData;

public class RequestUtil {
    private static boolean debug = false;

    static {
        Security.addProvider(new BouncyCastleJsseProvider());
    }

    public static String webDataToString(WebData data) {
        if (data.getData() != null) {
            try {
                String response = new String(data.getData(), "UTF-8");
                if (debug) {
                    System.out.println("INCOMING: " + response);
                }
                return response;
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        return null;
    }

    public static String performPOSTRequest(Request req) {
        WebData data = RequestUtil.performRawPOSTRequest(req);
        return RequestUtil.webDataToString(data);
    }

    public static WebData performRawPOSTRequest(Request req) {
        CloseableHttpClient client = null;
        try {
            WebData webData;
            client = RequestUtil.createHttpClient();
            HttpPost post = new HttpPost(req.REQUEST_URL);
            RequestUtil.setHeaders(post, req.PROPERTIES);
            if (req.POST_DATA == null) {
                Gson gson = new Gson();
                String json = gson.toJson(req);
                if (debug) {
                    System.out.println("OUTGOING: " + json);
                }
                post.setEntity(new StringEntity(json, "UTF-8"));
            } else {
                if (debug) {
                    System.out.println("OUTGOING: " + req.POST_DATA);
                }
                post.setEntity(new StringEntity(req.POST_DATA, "UTF-8"));
            }
            CloseableHttpResponse response = client.execute(post);
            try {
                webData = RequestUtil.handleResponse(response);
            }
            catch (Throwable throwable) {
                try {
                    response.close();
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    WebData webData2 = new WebData(null, -1);
                    return webData2;
                }
            }
            response.close();
            return webData;
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String performGETRequest(Request req) {
        WebData data = RequestUtil.performRawGETRequest(req);
        return RequestUtil.webDataToString(data);
    }

    public static WebData performRawGETRequest(Request req) {
        CloseableHttpClient client = null;
        try {
            WebData webData;
            client = RequestUtil.createHttpClient();
            HttpGet get = new HttpGet(req.REQUEST_URL);
            RequestUtil.setHeaders(get, req.PROPERTIES);
            CloseableHttpResponse response = client.execute(get);
            try {
                webData = RequestUtil.handleResponse(response);
            }
            catch (Throwable throwable) {
                try {
                    response.close();
                    throw throwable;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    WebData webData2 = new WebData(null, -1);
                    return webData2;
                }
            }
            response.close();
            return webData;
        }
        finally {
            if (client != null) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private static CloseableHttpClient createHttpClient() {
        try {
            Security.addProvider(new BouncyCastleProvider());
            SecureRandom secureRandom = new SecureRandom();
            BcTlsCrypto randomCrypt = new BcTlsCrypto(secureRandom);
            CustomTlsSocketFactory sslSocketFactory = new CustomTlsSocketFactory(randomCrypt);
            return HttpClients.custom().setSSLSocketFactory(new SSLConnectionSocketFactory((SSLSocketFactory)sslSocketFactory, (HostnameVerifier)NoopHostnameVerifier.INSTANCE)).build();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create HTTP client", e);
        }
    }

    private static void setHeaders(HttpPost post, Map properties) {
        for (String key : properties.keySet()) {
            post.addHeader(key, (String)properties.get(key));
        }
    }

    private static void setHeaders(HttpGet get, Map properties) {
        for (String key : properties.keySet()) {
            get.addHeader(key, (String)properties.get(key));
        }
    }

    private static WebData handleResponse(HttpResponse response) throws IOException {
        int httpCode = response.getStatusLine().getStatusCode();
        byte[] data = RequestUtil.readInputStream(response.getEntity().getContent());
        return new WebData(data, httpCode);
    }

    public static byte[] readInputStream(InputStream in) {
        try {
            int count;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[4096];
            while ((count = in.read(buffer)) != -1) {
                baos.write(buffer, 0, count);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

