/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.betacraft.launcher.AwaitingMSALogin;
import org.betacraft.launcher.BC;
import org.betacraft.launcher.BottomPanel;
import org.betacraft.launcher.InstanceList;
import org.betacraft.launcher.InstanceSettings;
import org.betacraft.launcher.Lang;
import org.betacraft.launcher.LanguageElement;
import org.betacraft.launcher.Launcher;
import org.betacraft.launcher.ModsRepository;
import org.betacraft.launcher.Release;
import org.betacraft.launcher.SelectAddons;
import org.betacraft.launcher.SelectVersion;
import org.betacraft.launcher.Util;
import org.betacraft.launcher.WebsitePanel;
import uk.betacraft.auth.MicrosoftAuth;
import uk.betacraft.auth.NoAuth;
import uk.betacraft.auth.jsons.microsoft.DeviceCodeRequest;
import uk.betacraft.auth.jsons.microsoft.DeviceCodeResponse;

public class Window
extends JFrame
implements ActionListener,
LanguageElement {
    public static JLabel selectedInstanceDisplay = null;
    public static JButton playButton;
    public static JButton selectVersionButton;
    public static JButton settingsButton;
    public static JButton langButton;
    public static JButton tabchangelog;
    public static JButton tabservers;
    public static JButton tabinstances;
    public static JLabel nicktext;
    public static JTextField nick_input;
    public static JButton loginButton;
    public static BottomPanel bottomPanel;
    public static Component centerPanel;
    public static Window mainWindow;
    public static ModsRepository modsRepo;
    public static InstanceList instanceList;
    public static InstanceSettings instanceSettings;
    public static Lang lang;
    public static SelectAddons addonsList;
    public static SelectVersion versionsList;
    public static Tab tab;
    public static BufferedImage img;

    static {
        loginButton = null;
        bottomPanel = null;
        centerPanel = null;
        mainWindow = null;
        modsRepo = null;
        instanceList = null;
        instanceSettings = null;
        lang = null;
        addonsList = null;
        versionsList = null;
        tab = Tab.CHANGELOG;
    }

    public Window() {
        try {
            InputStream imstream = this.getClass().getClassLoader().getResourceAsStream("icons/icon.png");
            img = ImageIO.read(imstream);
            this.setIconImage(img);
        }
        catch (Exception ex) {
            System.err.println("An error occurred while loading the window icon!");
            ex.printStackTrace();
        }
        mainWindow = this;
        this.setMinimumSize(new Dimension(800, 480));
        this.setPreferredSize(new Dimension(800, 480));
        this.setTitle(String.valueOf(Lang.WINDOW_TITLE) + (BC.nightly ? " [NIGHTLY]" : ""));
        this.setLayout(new BorderLayout());
        this.setLocationRelativeTo(null);
        loginButton = new JButton(Lang.LOGIN_BUTTON);
        playButton = new JButton(Lang.WINDOW_PLAY);
        selectedInstanceDisplay = new JLabel(String.valueOf(Launcher.currentInstance.name) + " [" + Launcher.currentInstance.version + "]");
        selectVersionButton = new JButton(Lang.WINDOW_SELECT_VERSION);
        nick_input = new JTextField(Launcher.getNickname(), 16);
        settingsButton = new JButton(Lang.WINDOW_OPTIONS);
        langButton = new JButton(Lang.WINDOW_LANGUAGE);
        nick_input.setEnabled(false);
        nick_input.setText(Lang.LOGGING_IN);
        nick_input.getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent e) {
                this.change();
            }

            public void removeUpdate(DocumentEvent e) {
                this.change();
            }

            public void insertUpdate(DocumentEvent e) {
                this.change();
            }

            public void change() {
                Launcher.auth.getCredentials().username = nick_input.getText();
            }
        });
        loginButton.setEnabled(false);
        loginButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!nick_input.isEnabled()) {
                    Launcher.auth.invalidate();
                    Launcher.auth = Util.getAuthenticator(Launcher.accounts.accounts.get(0));
                    Launcher.accounts.setCurrent(Launcher.accounts.accounts.get(0));
                    Launcher.auth.authenticate();
                    nick_input.setText(Launcher.getNickname());
                    if (Launcher.auth instanceof NoAuth) {
                        nick_input.setEnabled(true);
                        loginButton.setText(Lang.LOGIN_BUTTON);
                    }
                } else {
                    DeviceCodeResponse dcr = new DeviceCodeRequest().perform();
                    new AwaitingMSALogin(dcr.verification_uri, dcr.user_code, dcr.device_code, dcr.expires_in, dcr.interval);
                }
            }
        });
        bottomPanel = new BottomPanel();
        String tabname = BC.SETTINGS.getProperty("tab");
        Tab tab = tabname.equals("") ? Tab.CHANGELOG : Tab.valueOf(tabname.toUpperCase());
        Window.setTab(tab);
        this.add((Component)bottomPanel, "South");
        JPanel stuffz = new JPanel(){

            public void update(Graphics graphics) {
                this.paint(graphics);
            }

            public void paintComponent(Graphics g) {
                bottomPanel.paintComponent(g);
            }
        };
        stuffz.setLayout(new GridBagLayout());
        tabchangelog = new JButton(Lang.TAB_CHANGELOG);
        tabinstances = new JButton(Lang.TAB_INSTANCES);
        tabservers = new JButton(Lang.TAB_SERVERS);
        Window.positionButtons();
        tabchangelog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Window.setTab(Tab.CHANGELOG);
            }
        });
        tabinstances.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (tab != Tab.INSTANCES) {
                    if (instanceList == null) {
                        new InstanceList();
                    } else {
                        instanceList.setVisible(true);
                    }
                }
            }
        });
        tabservers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Window.setTab(Tab.SERVER_LIST);
            }
        });
        GridBagConstraints constr = new GridBagConstraints();
        constr.fill = 1;
        constr.gridwidth = -1;
        constr.gridy = 0;
        constr.gridx = 0;
        constr.weightx = 0.0;
        constr.gridwidth = 1;
        constr.insets = new Insets(0, 2, 0, 2);
        stuffz.add((Component)tabchangelog, constr);
        constr.gridx = 1;
        stuffz.add((Component)tabinstances, constr);
        constr.gridx = 2;
        stuffz.add((Component)tabservers, constr);
        this.add((Component)stuffz, "North");
        selectedInstanceDisplay.setForeground(Color.WHITE);
        playButton.addActionListener(this);
        selectVersionButton.addActionListener(this);
        settingsButton.addActionListener(this);
        langButton.addActionListener(this);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.out.println("Disabling...");
                Window.quit(true);
            }
        });
        if (mainWindow.isVisible()) {
            this.pack();
        }
        playButton.requestFocus();
    }

    public void update() {
        this.setTitle(String.valueOf(Lang.WINDOW_TITLE) + (BC.nightly ? " [NIGHTLY]" : ""));
        if (Launcher.auth instanceof NoAuth) {
            loginButton.setText(Lang.LOGIN_BUTTON);
        } else {
            loginButton.setText(Lang.LOGOUT_BUTTON);
        }
        playButton.setText(Lang.WINDOW_PLAY);
        selectVersionButton.setText(Lang.WINDOW_SELECT_VERSION);
        settingsButton.setText(Lang.WINDOW_OPTIONS);
        langButton.setText(Lang.WINDOW_LANGUAGE);
        tabchangelog.setText(Lang.TAB_CHANGELOG);
        tabinstances.setText(Lang.TAB_INSTANCES);
        tabservers.setText(Lang.TAB_SERVERS);
        Window.positionButtons();
        if (mainWindow.isVisible()) {
            this.pack();
        }
    }

    public static void continueMSA(MicrosoftAuth auth) {
        if (auth.authenticate()) {
            Util.saveAccounts();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(mainWindow, Lang.LOGIN_FAILED, Lang.LOGIN_MICROSOFT_ERROR, 0);
                }
            });
        }
        mainWindow.requestFocus();
    }

    public static void setTab(Tab tab) {
        if (tab == Tab.CHANGELOG) {
            new Thread(){

                public void run() {
                    if (centerPanel != null) {
                        mainWindow.getContentPane().remove(centerPanel);
                    }
                    centerPanel = new WebsitePanel().getUpdateNews(true);
                    tab = Tab.CHANGELOG;
                    mainWindow.add(centerPanel, "Center");
                    mainWindow.setPreferredSize(mainWindow.getSize());
                    if (mainWindow.isVisible()) {
                        mainWindow.pack();
                    }
                }
            }.start();
        } else if (tab == Tab.SERVER_LIST) {
            new Thread(){

                public void run() {
                    if (centerPanel != null) {
                        mainWindow.getContentPane().remove(centerPanel);
                    }
                    centerPanel = new WebsitePanel().getServers(true);
                    tab = Tab.SERVER_LIST;
                    mainWindow.add(centerPanel, "Center");
                    mainWindow.setPreferredSize(mainWindow.getSize());
                    if (mainWindow.isVisible()) {
                        mainWindow.pack();
                    }
                }
            }.start();
        }
    }

    public static void positionButtons() {
        JButton copyTabServ;
        JButton copyVersion = new JButton(selectVersionButton.getText());
        JButton copyLanguag = new JButton(langButton.getText());
        JButton copyInstanc = new JButton(settingsButton.getText());
        JButton largest = copyVersion;
        if (largest.getPreferredSize().getWidth() < copyLanguag.getPreferredSize().getWidth()) {
            largest = copyLanguag;
        }
        if (largest.getPreferredSize().getWidth() < copyInstanc.getPreferredSize().getWidth()) {
            largest = copyInstanc;
        }
        selectVersionButton.setPreferredSize(largest.getPreferredSize());
        selectVersionButton.setSize(largest.getPreferredSize());
        langButton.setPreferredSize(largest.getPreferredSize());
        langButton.setSize(largest.getPreferredSize());
        settingsButton.setPreferredSize(largest.getPreferredSize());
        settingsButton.setSize(largest.getPreferredSize());
        JButton copyTabChan = new JButton(tabchangelog.getText());
        JButton copyTabInst = new JButton(tabinstances.getText());
        largest = copyTabServ = new JButton(tabservers.getText());
        if (largest.getPreferredSize().getWidth() < copyTabInst.getPreferredSize().getWidth()) {
            largest = copyTabInst;
        }
        if (largest.getPreferredSize().getWidth() < copyTabChan.getPreferredSize().getWidth()) {
            largest = copyTabChan;
        }
        tabchangelog.setPreferredSize(largest.getPreferredSize());
        tabchangelog.setSize(largest.getPreferredSize());
        tabinstances.setPreferredSize(largest.getPreferredSize());
        tabinstances.setSize(largest.getPreferredSize());
        tabservers.setPreferredSize(largest.getPreferredSize());
        tabservers.setSize(largest.getPreferredSize());
    }

    public static void quit(boolean close) {
        if (mainWindow != null) {
            mainWindow.setVisible(false);
        }
        if (mainWindow != null) {
            mainWindow.dispose();
        }
        Util.saveAccounts();
        BC.SETTINGS.setProperty("tab", tab.name());
        BC.SETTINGS.flushToDisk();
        if (close) {
            for (Thread t : Launcher.totalThreads) {
                while (t.isAlive()) {
                }
            }
            System.exit(0);
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source == selectVersionButton && Release.versions.size() > 0) {
            if (versionsList == null) {
                new SelectVersion();
            } else {
                versionsList.setVisible(true);
            }
            SelectVersion.list.requestFocus();
        }
        if (source == settingsButton) {
            if (instanceSettings == null) {
                new InstanceSettings();
            } else {
                instanceSettings.setVisible(true);
            }
        }
        if (source == langButton) {
            if (lang == null) {
                new Lang();
            } else {
                lang.setVisible(true);
            }
        }
        if (source == playButton) {
            Util.saveAccounts();
            playButton.setEnabled(false);
            try {
                new Thread(){

                    public void run() {
                        int last = Launcher.totalThreads.size();
                        while (last > 0) {
                            last = Launcher.totalThreads.size();
                            try {
                                Thread.sleep(1L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                        Window.setStatus(playButton, Lang.WINDOW_DOWNLOADING);
                        boolean success = Launcher.initStartup();
                        Window.setStatus(playButton, Lang.WINDOW_PLAY);
                        playButton.setEnabled(true);
                        if (success) {
                            new Launcher().launchGame(Launcher.currentInstance);
                        }
                    }
                }.start();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void setTextInField(final JTextField field, final String toSet) {
        Runnable set = new Runnable(){

            public void run() {
                field.setText(toSet);
            }
        };
        SwingUtilities.invokeLater(set);
    }

    public static void setStatus(final JButton button, final String toSet) {
        Runnable set = new Runnable(){

            public void run() {
                button.setText(toSet);
            }
        };
        SwingUtilities.invokeLater(set);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Tab {
        CHANGELOG,
        INSTANCES,
        SERVER_LIST;

    }
}

