/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.betacraft.launcher.BC;
import org.betacraft.launcher.DownloadResult;
import org.betacraft.launcher.Launcher;
import org.betacraft.launcher.OS;
import org.betacraft.launcher.SimpleWebAddressFrame;
import uk.betacraft.auth.Accounts;
import uk.betacraft.auth.Authenticator;
import uk.betacraft.auth.Credentials;
import uk.betacraft.auth.CustomRequest;
import uk.betacraft.auth.CustomResponse;
import uk.betacraft.auth.DownloadRequest;
import uk.betacraft.auth.DownloadResponse;
import uk.betacraft.auth.MicrosoftAuth;
import uk.betacraft.auth.NoAuth;
import uk.betacraft.json.lib.MouseFixMacOSJson;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Util {
    public static final Gson gson = new Gson();
    public static final Gson gsonPretty = new GsonBuilder().setPrettyPrinting().create();
    public static final int jsonVersion = 1;
    public static final File accountsFile = new File(String.valueOf(BC.get()) + "launcher/accounts.json");

    private static void setupAccountConfiguration() {
        try {
            Launcher.auth = new NoAuth("");
            Accounts accs = new Accounts();
            accs.current = Launcher.auth.getCredentials().local_uuid;
            ArrayList<Credentials> list = new ArrayList<Credentials>();
            list.add(Launcher.auth.getCredentials());
            accs.accounts = list;
            Launcher.accounts = accs;
            Util.saveAccounts();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void saveAccounts() {
        try {
            if (!accountsFile.exists()) {
                accountsFile.createNewFile();
            }
            Util.writeBytes(accountsFile, gsonPretty.toJson(Launcher.accounts).getBytes("UTF-8"));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static Authenticator getAuthenticator(Credentials c) {
        if (c.account_type == Credentials.AccountType.MICROSOFT) {
            return new MicrosoftAuth(c);
        }
        if (c.account_type == Credentials.AccountType.OFFLINE) {
            return new NoAuth(c);
        }
        return null;
    }

    public static void readAccounts() {
        try {
            if (!accountsFile.exists()) {
                Util.setupAccountConfiguration();
                return;
            }
            Accounts accs = null;
            try {
                accs = gson.fromJson(new String(Util.readBytes(accountsFile), "UTF-8"), Accounts.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (accs == null || accs.accounts == null) {
                Util.setupAccountConfiguration();
                return;
            }
            for (Credentials c : accs.accounts) {
                if (c.local_uuid == null || !c.local_uuid.equals(accs.current)) continue;
                Launcher.auth = Util.getAuthenticator(c);
            }
            if (Launcher.auth == null) {
                Launcher.auth = Util.getAuthenticator(accs.accounts.get(0));
                accs.current = Launcher.auth.getCredentials().local_uuid;
            }
            Launcher.accounts = accs;
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void write(File file, String[] lines, boolean append) {
        Util.write(file, lines, append, "UTF-8");
    }

    public static void write(File file, String[] lines, boolean append, String charset) {
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            System.out.println(file.getAbsolutePath());
            e.printStackTrace();
        }
        OutputStreamWriter writer = null;
        try {
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), charset);
                int i = 0;
                while (i < lines.length) {
                    if (lines[i] != null) {
                        writer.write(String.valueOf(lines[i]) + "\n");
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                System.err.println("A critical error occurred while attempting to write to file: " + file);
                ex.printStackTrace();
                try {
                    writer.close();
                }
                catch (Exception exception) {}
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    public static String[] read(File file, String charset) {
        try {
            if (!file.exists()) {
                return new String[0];
            }
            if (file.createNewFile()) {
                System.out.println("Created a new file: " + file);
            }
        }
        catch (IOException e) {
            System.err.println(file.getAbsolutePath());
            e.printStackTrace();
        }
        InputStreamReader reader = null;
        try {
            int readcount;
            reader = new InputStreamReader((InputStream)new FileInputStream(file), charset);
            StringBuilder inputB = new StringBuilder();
            char[] buffer = new char[1024];
            while ((readcount = reader.read(buffer)) >= 0) {
                inputB.append(buffer, 0, readcount);
            }
            String[] stringArray = inputB.toString().split("\n");
            return stringArray;
        }
        catch (Exception ex) {
            System.err.println("A critical error occurred while reading from file: " + file);
            ex.printStackTrace();
        }
        finally {
            try {
                reader.close();
            }
            catch (Exception exception) {}
        }
        return null;
    }

    public static Thread unzip(File source, File dest_folder, boolean delete) {
        return Util.unzip(source.getAbsolutePath(), dest_folder.getAbsolutePath(), delete);
    }

    public static Thread unzip(final String source, final String dest_folder, final boolean delete) {
        Thread unrarthread = new Thread(){

            public void run() {
                byte[] buffer = new byte[1024];
                try {
                    FileInputStream fis = new FileInputStream(source);
                    ZipInputStream zis = new ZipInputStream(fis);
                    ZipEntry entry = zis.getNextEntry();
                    while (entry != null) {
                        int length;
                        if (entry.isDirectory()) {
                            entry = zis.getNextEntry();
                            continue;
                        }
                        String fileName = entry.getName();
                        File newFile = new File(String.valueOf(dest_folder) + File.separator + fileName);
                        new File(newFile.getParent()).mkdirs();
                        FileOutputStream fos = new FileOutputStream(newFile);
                        while ((length = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, length);
                        }
                        fos.flush();
                        fos.close();
                        zis.closeEntry();
                        entry = zis.getNextEntry();
                    }
                    zis.closeEntry();
                    zis.close();
                    fis.close();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (delete) {
                    new File(source).delete();
                }
                if (!Util.isStandalone()) {
                    Launcher.totalThreads.remove(this);
                }
            }
        };
        unrarthread.start();
        return unrarthread;
    }

    public static Thread rezip(final File[] sources, final File dest) {
        Thread rezipthread = new Thread(){

            public void run() {
                File tempFolder = new File(Launcher.getVerFolder(), "temp");
                if (tempFolder.exists()) {
                    Launcher.removeRecursively(tempFolder, false, false);
                } else {
                    tempFolder.mkdir();
                }
                byte[] buffer = new byte[1024];
                try {
                    FileInputStream fis;
                    File[] fileArray = sources;
                    int n = sources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        File source = fileArray[n2];
                        fis = new FileInputStream(source);
                        ZipInputStream zis = new ZipInputStream(fis);
                        ZipEntry entry = zis.getNextEntry();
                        while (entry != null) {
                            int length;
                            if (entry.isDirectory()) {
                                entry = zis.getNextEntry();
                                continue;
                            }
                            String fileName = entry.getName();
                            File newFile = new File(tempFolder, fileName);
                            File parent = new File(newFile.getParent());
                            if (parent.getName().equals("META-INF")) {
                                entry = zis.getNextEntry();
                                continue;
                            }
                            parent.mkdirs();
                            FileOutputStream fos = new FileOutputStream(newFile);
                            while ((length = zis.read(buffer)) > 0) {
                                fos.write(buffer, 0, length);
                            }
                            fos.flush();
                            fos.close();
                            zis.closeEntry();
                            entry = zis.getNextEntry();
                        }
                        zis.closeEntry();
                        zis.close();
                        fis.close();
                        ++n2;
                    }
                    ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(dest));
                    ArrayList<File> entries = Util.listRecursively(tempFolder);
                    for (File currentFile : entries) {
                        String s = tempFolder.toURI().relativize(currentFile.toURI()).getPath();
                        if (currentFile.isDirectory() && !s.endsWith("/")) {
                            s = String.valueOf(s) + "/";
                        }
                        zos.putNextEntry(new ZipEntry(s));
                        if (!currentFile.isDirectory()) {
                            int length;
                            fis = new FileInputStream(currentFile);
                            while ((length = fis.read(buffer)) > 0) {
                                zos.write(buffer, 0, length);
                            }
                            fis.close();
                        }
                        zos.closeEntry();
                    }
                    zos.flush();
                    zos.close();
                    if (tempFolder.exists()) {
                        Launcher.removeRecursively(tempFolder, true, false);
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                if (!Util.isStandalone()) {
                    Launcher.totalThreads.remove(this);
                }
            }
        };
        rezipthread.start();
        return rezipthread;
    }

    public static ArrayList<File> listRecursively(File dir) {
        File[] entries;
        ArrayList<File> full = new ArrayList<File>();
        File[] fileArray = entries = dir.listFiles();
        int n = entries.length;
        int n2 = 0;
        while (n2 < n) {
            File potentialDir = fileArray[n2];
            full.add(potentialDir);
            if (potentialDir.isDirectory()) {
                full.addAll(Util.listRecursively(potentialDir));
            }
            ++n2;
        }
        return full;
    }

    public static boolean isStandalone() {
        try {
            Launcher.VERSION.length();
            return false;
        }
        catch (Throwable ex) {
            return true;
        }
    }

    public static String getSHA1(File file) {
        try {
            FileInputStream fis = new FileInputStream(file);
            return Util.getSHA1(fis);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static String getSHA1(InputStream is) {
        try {
            int numRead;
            byte[] buffer = new byte[1024];
            MessageDigest msgdig = MessageDigest.getInstance("SHA-1");
            do {
                if ((numRead = is.read(buffer)) <= 0) continue;
                msgdig.update(buffer, 0, numRead);
            } while (numRead != -1);
            is.close();
            byte[] digest = msgdig.digest();
            String str_result = "";
            int i = 0;
            while (i < digest.length) {
                str_result = String.valueOf(str_result) + Integer.toString((digest[i] & 0xFF) + 256, 16).substring(1);
                ++i;
            }
            return str_result;
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    public static boolean installMacOSFix(MouseFixMacOSJson json, boolean force) {
        block8: {
            File classes_temp_zip;
            File classes_folder;
            block9: {
                String local_javamod_sha1;
                block7: {
                    String local_lwjgl_sha1;
                    File lwjgl;
                    block6: {
                        File javaagent = new File(String.valueOf(BC.get()) + "launcher/macos-javaagent.jar");
                        lwjgl = new File(String.valueOf(BC.get()) + "launcher/macos-mousefix-lwjgl.jar");
                        classes_folder = new File(String.valueOf(BC.get()) + "launcher/macos-java-mod/");
                        classes_temp_zip = new File(String.valueOf(BC.get()) + "launcher/macos-mousefix.zip");
                        String local_javaagent_sha1 = javaagent.exists() ? Util.getSHA1(javaagent) : null;
                        local_lwjgl_sha1 = lwjgl.exists() ? Util.getSHA1(lwjgl) : null;
                        local_javamod_sha1 = BC.SETTINGS.getProperty("macosMouseFixClassesVersion");
                        try {
                            if (local_javaagent_sha1 != null && local_javaagent_sha1.equals(json.agent_sha1) && !force) break block6;
                            DownloadResponse agent_req = new DownloadRequest(json.agent_url, javaagent.getAbsolutePath(), json.agent_sha1, false).perform();
                            if (agent_req.result == DownloadResult.OK) break block6;
                            System.err.println("Failed to download macos javaagent");
                            return false;
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            return false;
                        }
                    }
                    if (local_lwjgl_sha1 != null && local_lwjgl_sha1.equals(json.lwjgl_sha1) && !force) break block7;
                    DownloadResponse lwjgl_req = new DownloadRequest(json.lwjgl_url, lwjgl.getAbsolutePath(), json.lwjgl_sha1, false).perform();
                    if (lwjgl_req.result == DownloadResult.OK) break block7;
                    System.err.println("Failed to download macos-mousefix.zip");
                    return false;
                }
                if (local_javamod_sha1 != null && local_javamod_sha1.equals(json.classes_sha1) && !force) break block8;
                DownloadResponse classes_req = new DownloadRequest(json.classes_url, classes_temp_zip.getAbsolutePath(), json.classes_sha1, false).perform();
                if (classes_req.result == DownloadResult.OK) break block9;
                System.err.println("Failed to download macos-mousefix.zip");
                return false;
            }
            if (classes_folder.exists() && classes_folder.list().length != 0) {
                Launcher.removeRecursively(classes_folder, false, false);
            }
            classes_folder.mkdirs();
            BC.SETTINGS.setProperty("macosMouseFixClassesVersion", json.classes_sha1);
            Launcher.totalThreads.add(Util.unzip(classes_temp_zip, classes_folder, true));
        }
        return true;
    }

    public static boolean downloadJava8u51() {
        String mirror1 = "https://archive.org/download/Java_8_update_51/jre-8u51-windows-x64.zip";
        String dest = new File(BC.get(), "jre-8u51-windows-x64.zip").getAbsolutePath();
        DownloadResponse res = new DownloadRequest(mirror1, dest, null, false).perform();
        if (res.result == DownloadResult.FAILED_WITHOUT_BACKUP) {
            CustomResponse cres = new CustomRequest("http://files.betacraft.uk/launcher/assets/java-8u51-url.txt").perform();
            if (cres.response == null) {
                return false;
            }
            res = new DownloadRequest(cres.response, dest, null, false).perform();
            if (res.result == DownloadResult.FAILED_WITHOUT_BACKUP) {
                return false;
            }
        }
        return true;
    }

    public static File getJava8u51Location() {
        String[] expectedPaths;
        String[] stringArray = expectedPaths = new String[]{"C:\\Program Files\\Java\\jre1.8.0_51\\bin\\java.exe", "C:\\Program Files (x86)\\Minecraft Launcher\\runtime\\jre-legacy\\windows-x64\\jre-legacy\\bin\\java.exe", String.valueOf(System.getenv("USERPROFILE")) + "\\AppData\\Local\\Packages\\Microsoft.4297127D64EC6_8wekyb3d8bbwe\\LocalCache\\Local\\runtime\\jre-legacy\\windows-x64\\jre-legacy\\bin\\java.exe"};
        int n = expectedPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String expectedPath = stringArray[n2];
            File expectedFile = new File(expectedPath);
            if (expectedFile.exists() && expectedFile.isFile()) {
                return expectedFile;
            }
            ++n2;
        }
        return null;
    }

    public static String getExpectedJavaLocation() {
        String[] expectedPaths = OS.isMac() ? new String[]{"/Library/Internet Plug-Ins/JavaAppletPlugin.plugin/Contents/Home/bin/java", "/Library/Java/JavaVirtualMachines/jdk-1.8.jdk/Contents/Home/bin/java", "/Library/Java/JavaVirtualMachines/openjdk-8.jdk/Contents/Home/bin/java"} : (OS.isWindows() ? new String[]{"C:/Program Files/Java/latest/jre-1.8/bin/java.exe", "C:/Program Files/Java/jre-1.8/bin/java.exe"} : new String[]{"/usr/bin/java"});
        String[] stringArray = expectedPaths;
        int n = expectedPaths.length;
        int n2 = 0;
        while (n2 < n) {
            String expectedPath = stringArray[n2];
            File expectedFile = new File(expectedPath);
            if (expectedFile.exists() && expectedFile.isFile()) {
                return expectedFile.getAbsolutePath();
            }
            ++n2;
        }
        return null;
    }

    public static String findRecommendedJava() {
        String runtime = Launcher.javaRuntime.getAbsolutePath();
        if (Util.getMajorJavaVersion(runtime) > 8) {
            String expected = Util.getExpectedJavaLocation();
            if (expected != null && !runtime.equals(expected) && Util.getMajorJavaVersion(expected) <= 8) {
                return expected;
            }
        } else {
            return runtime;
        }
        return null;
    }

    public static String getFullJavaVersion(String javapath) {
        if (javapath == null || !new File(javapath).exists()) {
            return null;
        }
        String line = null;
        try {
            ArrayList<String> arl = new ArrayList<String>();
            arl.add(javapath);
            arl.add("-version");
            ProcessBuilder pb = new ProcessBuilder(arl);
            Process p = pb.start();
            InputStreamReader isr_log = new InputStreamReader(p.getErrorStream());
            BufferedReader br_log = new BufferedReader(isr_log);
            while ((line = br_log.readLine()) != null) {
                if (!line.contains("version")) continue;
                p.destroy();
                break;
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
        String verstart = line.substring(line.indexOf("\"") + 1);
        String fullver = verstart.substring(0, verstart.indexOf("\""));
        return fullver;
    }

    public static String getJavaVersion(String javapath) {
        String fullver = Util.getFullJavaVersion(javapath);
        if (fullver == null) {
            return null;
        }
        String whitelist = "0123456789.";
        int i = 0;
        while (i < fullver.length()) {
            if (!whitelist.contains(Character.toString(fullver.charAt(i)))) {
                fullver = fullver.substring(0, i);
            }
            ++i;
        }
        return fullver;
    }

    public static int getMajorJavaVersion(String javapath) {
        String ver = Util.getJavaVersion(javapath);
        if (ver == null) {
            return -1;
        }
        if (ver.startsWith("1.")) {
            return Integer.parseInt(ver.split("\\.")[1]);
        }
        int cut = ver.indexOf(46);
        if (cut == -1) {
            cut = ver.length();
        }
        return Integer.parseInt(ver.substring(0, cut));
    }

    public static int getCurrentMajorJavaVersion() {
        String ver = System.getProperty("java.runtime.version");
        if (ver.startsWith("1.")) {
            return Integer.parseInt(ver.split("\\.")[1]);
        }
        int cut = ver.indexOf(46);
        if (cut == -1) {
            cut = ver.length();
        }
        return Integer.parseInt(ver.substring(0, cut));
    }

    public static boolean openURL(String url) {
        try {
            return Util.openURL(new URL(url).toURI());
        }
        catch (Throwable t) {
            t.printStackTrace();
            new SimpleWebAddressFrame(url);
            return false;
        }
    }

    public static boolean openURL(URI uri) throws Throwable {
        if (Util.getCurrentMajorJavaVersion() < 6) {
            throw new Exception("Desktop API doesn't exist before Java 6");
        }
        try {
            Object invoke = Class.forName("java.awt.Desktop").getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            invoke.getClass().getMethod("browse", URI.class).invoke(invoke, uri);
            return true;
        }
        catch (Throwable t) {
            System.out.println("Failed to open link in a web browser: " + uri.toString());
            throw t;
        }
    }

    public static void copy(InputStream in, File file) {
        try {
            Util.copy(in, new FileOutputStream(file, false));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void copy(File file1, File file2) {
        try {
            Util.copy((InputStream)new FileInputStream(file1), new FileOutputStream(file2, false));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void copy(InputStream in, OutputStream out) {
        try {
            try {
                int size;
                byte[] buffer = new byte[1024];
                while ((size = in.read(buffer)) > 0) {
                    out.write(buffer, 0, size);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                try {
                    in.close();
                    out.close();
                }
                catch (Throwable t2) {
                    t2.printStackTrace();
                }
            }
        }
        finally {
            try {
                in.close();
                out.close();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    public static void writeBytes(File file, byte[] bytes) {
        try {
            FileOutputStream fos = new FileOutputStream(file, false);
            fos.write(bytes);
            fos.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static byte[] readBytes(File file) {
        try {
            int readcount;
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            while ((readcount = fis.read(buffer)) >= 0) {
                baos.write(buffer, 0, readcount);
            }
            fis.close();
            baos.close();
            return baos.toByteArray();
        }
        catch (Throwable t) {
            t.printStackTrace();
            return new byte[0];
        }
    }

    public static class PropertyFile {
        private File file;
        private String[] lines;
        private String charset;

        public PropertyFile(File file) {
            this(file, "UTF-8");
        }

        public PropertyFile(File file, String charset) {
            this.file = file;
            this.charset = charset;
            this.lines = file.exists() && file.isFile() ? this.read(charset) : new String[0];
        }

        private String[] read(String charset) {
            return Util.read(this.file, charset);
        }

        public boolean hasProperty(String property) {
            int i = 0;
            while (i < this.lines.length) {
                if (this.lines[i] != null && this.lines[i].startsWith(String.valueOf(property) + ":")) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        public String getProperty(String property) {
            String value = null;
            int i = 0;
            while (i < this.lines.length) {
                if (this.lines[i] != null && this.lines[i].startsWith(String.valueOf(property) + ":")) {
                    value = this.lines[i].substring(property.length() + 1, this.lines[i].length());
                    break;
                }
                ++i;
            }
            return value;
        }

        public void setProperty(String property, String value) {
            String[] newlines = new String[this.lines.length + 1];
            boolean found = false;
            int i = 0;
            while (i < this.lines.length) {
                if (this.lines[i] != null) {
                    if (this.lines[i].startsWith(String.valueOf(property) + ":")) {
                        newlines[i] = String.valueOf(property) + ":" + value;
                        found = true;
                    } else {
                        newlines[i] = this.lines[i];
                    }
                }
                ++i;
            }
            if (!found) {
                newlines[newlines.length - 1] = String.valueOf(property) + ":" + value;
            }
            this.lines = newlines;
        }

        public void flushToDisk() {
            Util.write(this.file, this.lines, false, this.charset);
        }
    }
}

