/*
 * Decompiled with CFR 0.152.
 */
package org.betacraft.launcher;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Scanner;
import org.betacraft.launcher.BC;
import org.betacraft.launcher.DownloadResult;
import org.betacraft.launcher.Lang;
import org.betacraft.launcher.Launcher;
import org.betacraft.launcher.ModsRepository;
import org.betacraft.launcher.ReleaseJson;
import uk.betacraft.json.lib.ModObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Release {
    public static ArrayList<Release> versions = new ArrayList();
    private String name;
    private VersionInfo info;

    public static void loadVersions(VersionRepository repo) {
        versions.clear();
        try {
            URL versionlisturl = new URL(repo.getLink());
            Scanner scanner = new Scanner(versionlisturl.openStream(), "UTF-8");
            while (scanner.hasNextLine()) {
                String[] versionNode = scanner.nextLine().split("`");
                VersionInfo info = ReleaseJson.exists(versionNode[0]) ? new ReleaseJson(versionNode[0]) : new NofileVersionInfo(versionNode);
                Release r = new Release(versionNode[0], info);
                versions.add(r);
            }
            scanner.close();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        for (VersionInfo info : Release.offlineVersionList()) {
            Release r = new Release(info.getVersion(), info);
            versions.add(r);
        }
    }

    public static ArrayList<VersionInfo> offlineVersionList() {
        String jar;
        ArrayList<VersionInfo> list = new ArrayList<VersionInfo>();
        File versionsFolder = new File(String.valueOf(BC.get()) + "versions/");
        File fakejsonsFolder = new File(versionsFolder, "jsons/");
        String[] offlinejars = versionsFolder.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        String[] offlinefakejsons = fakejsonsFolder.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".info");
            }
        });
        int i = 0;
        while (i < offlinejars.length) {
            jar = offlinejars[i].substring(0, offlinejars[i].length() - 4);
            String[] stringArray = offlinefakejsons;
            int n = offlinefakejsons.length;
            int n2 = 0;
            while (n2 < n) {
                String jsondotinfo = stringArray[n2];
                String json = jsondotinfo.substring(0, jsondotinfo.length() - 5);
                if (json.equals(jar)) {
                    offlinejars[i] = null;
                    break;
                }
                ++n2;
            }
            ++i;
        }
        i = 0;
        while (i < offlinejars.length) {
            if (offlinejars[i] != null) {
                jar = offlinejars[i].substring(0, offlinejars[i].length() - 4);
                for (Release r : versions) {
                    if (!r.getName().equals(jar)) continue;
                    offlinejars[i] = null;
                }
            }
            ++i;
        }
        i = 0;
        while (i < offlinefakejsons.length) {
            if (offlinefakejsons[i] != null) {
                String json = offlinefakejsons[i].substring(0, offlinefakejsons[i].length() - 5);
                for (Release r : versions) {
                    if (!r.getName().equals(json)) continue;
                    offlinefakejsons[i] = null;
                }
            }
            ++i;
        }
        ArrayList<String> stringlist = new ArrayList<String>();
        int i2 = 0;
        while (i2 < offlinejars.length) {
            String jar2 = offlinejars[i2];
            if (jar2 != null) {
                stringlist.add(jar2.substring(0, jar2.length() - 4));
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < offlinefakejsons.length) {
            String json = offlinefakejsons[i2];
            if (json != null) {
                stringlist.add(json.substring(0, json.length() - 5));
            }
            ++i2;
        }
        Collections.sort(stringlist);
        for (String version : stringlist) {
            ReleaseJson json = new ReleaseJson(version);
            if (json.hasJar() && !ReleaseJson.exists(version)) {
                json.custom = true;
            }
            list.add(json);
        }
        return list;
    }

    public Release(String name) {
        this(name, new ReleaseJson(name));
    }

    public Release(String name, VersionInfo info) {
        this.name = name;
        if (info.getFileVersion() < 1 && info.getFileVersion() != -1 && info instanceof ReleaseJson && ReleaseJson.exists(name)) {
            ReleaseJson info2 = (ReleaseJson)info;
            info2.getInfoFile().delete();
            System.out.println("Terminated an outdated info file of: " + name);
            info = new ReleaseJson(name);
        }
        this.info = info;
    }

    public String getName() {
        return this.name;
    }

    public VersionInfo getInfo() {
        return this.info;
    }

    public void setInfo(VersionInfo info) {
        this.info = info;
    }

    public String customSuffix() {
        return this.info.isCustom() || ModsRepository.getMod(this.name) != null ? Lang.VERSION_CUSTOM : "";
    }

    public String toString() {
        if (this.info.getOtherName() != null && !"".equals(this.info.getOtherName())) {
            return String.valueOf(this.name) + " (" + this.info.getOtherName() + ")" + this.customSuffix();
        }
        return String.valueOf(this.name) + this.customSuffix();
    }

    public static Release getReleaseByName(String name) {
        for (Release r : versions) {
            if (!r.getName().equals(name)) continue;
            return r;
        }
        ModObject modmatch = ModsRepository.getMod(name);
        if (modmatch != null) {
            new ReleaseJson(name, modmatch.info_file_url).downloadJson();
            Release.loadVersions(VersionRepository.BETACRAFT);
            return Release.getReleaseByName(name);
        }
        return null;
    }

    public static class NofileVersionInfo
    implements VersionInfo {
        private String name;
        private String othername = "";
        private long compileTime = 0L;
        private long releaseTime = 0L;
        private String protocol = "";

        public NofileVersionInfo(String name) {
            this.name = name;
        }

        public NofileVersionInfo(String[] node) {
            this.name = node[0];
            this.othername = node[1];
            this.compileTime = Long.parseLong(node[2]);
            this.releaseTime = Long.parseLong(node[3]);
            try {
                this.protocol = node[4];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
        }

        public String getVersion() {
            return this.name;
        }

        public int getFileVersion() {
            return 1;
        }

        public String getOtherName() {
            return this.othername;
        }

        public Date getCompileDate() {
            return new Date(this.compileTime);
        }

        public Date getReleaseDate() {
            return new Date(this.releaseTime);
        }

        public String getProxyArgs() {
            return "";
        }

        public String getLaunchMethod() {
            return "";
        }

        public String getLaunchMethodURL() {
            return "";
        }

        public String getDownloadURL() {
            return "";
        }

        public String getProtocol() {
            return this.protocol;
        }

        public String getEntry(String entry) {
            return "";
        }

        public boolean isCustom() {
            return false;
        }

        public File getInfoFile() {
            return new File(String.valueOf(BC.get()) + "versions/jsons/", String.valueOf(this.name) + ".info");
        }

        public boolean hasJar() {
            File jar = new File(String.valueOf(BC.get()) + "versions/", String.valueOf(this.name) + ".jar");
            return jar.exists() && jar.isFile();
        }

        public void setEntry(String entry, String value) {
        }

        public DownloadResult downloadJson() {
            return Launcher.download("http://files.betacraft.uk/launcher/assets/jsons/" + this.getVersion() + ".info", this.getInfoFile());
        }
    }

    public static interface VersionInfo {
        public String getOtherName();

        public String getVersion();

        public Date getCompileDate();

        public Date getReleaseDate();

        public String getProxyArgs();

        public String getLaunchMethod();

        public String getLaunchMethodURL();

        public String getDownloadURL();

        public String getProtocol();

        public String getEntry(String var1);

        public void setEntry(String var1, String var2);

        public int getFileVersion();

        public boolean isCustom();

        public File getInfoFile();

        public DownloadResult downloadJson();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VersionRepository {
        BETACRAFT("http://files.betacraft.uk/launcher/assets/version_list.txt"),
        CUSTOM(null);

        private String link;

        private VersionRepository(String link) {
            this.setLink(link);
        }

        public String getLink() {
            return this.link;
        }

        public VersionRepository setLink(String link) {
            this.link = link;
            return this;
        }
    }
}

