/*
 * Decompiled with CFR 0.152.
 */
package com.johnymuffin.evolutions.core;

import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.HashMap;
import org.betacraft.launcher.Util;

public class BetaEvolutionsUtils {
    private boolean debug;
    private static HashMap<String, BEVersion> beServers = new HashMap();

    static {
        beServers.put("https://auth1.evolutions.johnymuffin.com", BEVersion.V2_PLAINTEXT);
        beServers.put("https://auth2.evolutions.johnymuffin.com", BEVersion.V2_PLAINTEXT);
        beServers.put("https://auth3.evolutions.johnymuffin.com", BEVersion.V2_PLAINTEXT);
    }

    public BetaEvolutionsUtils() {
        this.debug = false;
    }

    public BetaEvolutionsUtils(boolean debug) {
        this.debug = debug;
    }

    public VerificationResults authenticateUser(String username, String sessionID) {
        String ip = this.getExternalIP();
        if (ip == null) {
            this.log("Can't authenticate with any nodes, can't fetch external IP address. Your internet is probably offline!");
            return new VerificationResults(0, 0, beServers.size());
        }
        VerificationResults verificationResults = new VerificationResults();
        for (String node : beServers.keySet()) {
            Boolean result = this.authenticateWithBetaEvolutions(username, node, beServers.get(node), sessionID, ip);
            if (result == null) {
                verificationResults.setErrored(verificationResults.getErrored() + 1);
                continue;
            }
            if (result.booleanValue()) {
                verificationResults.setSuccessful(verificationResults.getSuccessful() + 1);
                continue;
            }
            if (result.booleanValue()) continue;
            verificationResults.setFailed(verificationResults.getFailed() + 1);
        }
        return verificationResults;
    }

    public VerificationResults verifyUser(String username, String userIP) {
        VerificationResults verificationResults = new VerificationResults();
        for (String node : beServers.keySet()) {
            Boolean result = this.verifyUserWithNode(username, userIP, node, beServers.get(node));
            if (result == null) {
                verificationResults.setErrored(verificationResults.getErrored() + 1);
                continue;
            }
            if (result.booleanValue()) {
                verificationResults.setSuccessful(verificationResults.getSuccessful() + 1);
                continue;
            }
            if (result.booleanValue()) continue;
            verificationResults.setFailed(verificationResults.getFailed() + 1);
        }
        return verificationResults;
    }

    private Boolean verifyUserWithNode(String username, String userIP, String node, BEVersion beVersion) {
        if (beVersion == BEVersion.V1) {
            String stage1URL = String.valueOf(node) + "/serverAuth.php?method=1&username=" + this.encodeString(username) + "&userip=" + this.encodeString(userIP);
            JsonObject stage1Object = this.getJSONFromURL(stage1URL);
            if (stage1Object == null) {
                this.log("Authentication with node: " + node + " has failed to respond when queried.");
                return null;
            }
            if (!this.verifyJSONArguments(stage1Object, "result", "verified")) {
                this.log("Malformed response from: " + node + " using version " + (Object)((Object)beVersion));
                return null;
            }
            return stage1Object.get("verified").getAsBoolean();
        }
        if (beVersion == BEVersion.V2_PLAINTEXT) {
            String stage1URL = String.valueOf(node) + "/server/getVerification?username=" + this.encodeString(username) + "&userip=" + this.encodeString(userIP);
            JsonObject stage1Object = this.getJSONFromURL(stage1URL);
            if (stage1Object == null) {
                this.log("Authentication with node: " + node + " has failed to respond when queried.");
                return null;
            }
            if (!this.verifyJSONArguments(stage1Object, "verified", "error")) {
                this.log("Malformed response from: " + node + " using version " + (Object)((Object)beVersion));
                return null;
            }
            return stage1Object.get("verified").getAsBoolean();
        }
        return null;
    }

    private Boolean authenticateWithMojang(String username, String sessionID, String serverID) {
        try {
            String authURL = "http://session.minecraft.net/game/joinserver.jsp?user=" + this.encodeString(username) + "&sessionId=" + this.encodeString(sessionID) + "&serverId=" + this.encodeString(serverID);
            URL url = new URL(authURL);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(url.openStream()));
            String response = bufferedReader.readLine();
            bufferedReader.close();
            if (response.equalsIgnoreCase("ok")) {
                return true;
            }
            return false;
        }
        catch (Exception e) {
            if (this.debug) {
                this.log("An error occurred contacting Mojang.");
                e.printStackTrace();
            }
            return null;
        }
    }

    private Boolean authenticateWithBetaEvolutions(String username, String node, BEVersion beVersion, String sessionToken, String ip) {
        if (beVersion == BEVersion.V1) {
            String stage1URL = String.valueOf(node) + "/userAuth.php?method=1&username=" + this.encodeString(username);
            JsonObject stage1Object = this.getJSONFromURL(stage1URL);
            if (stage1Object == null) {
                this.log("Authentication with node: " + node + " has failed as JSON can't be fetched.");
                return null;
            }
            if (!this.verifyJSONArguments(stage1Object, "result", "username", "userip", "serverId")) {
                this.log("Malformed response from: " + node + " using version " + (Object)((Object)beVersion));
                return null;
            }
            String serverID = stage1Object.get("serverId").getAsString();
            Boolean mojangAuthentication = this.authenticateWithMojang(username, sessionToken, serverID);
            if (mojangAuthentication == null) {
                this.log("Authentication with node: " + node + " has failed due to auth failure with Mojang.");
                return null;
            }
            if (!mojangAuthentication.booleanValue()) {
                this.log("Authentication with node: " + node + " has failed. Token is probably incorrect, or user is cracked!");
                return false;
            }
            String stage3URL = String.valueOf(node) + "/userAuth.php?method=2&username=" + this.encodeString(username) + "&serverId=" + this.encodeString(serverID);
            JsonObject stage3Object = this.getJSONFromURL(stage3URL);
            if (stage3Object == null) {
                this.log("Authentication with node: " + node + " has failed as JSON can't be fetched.");
                return null;
            }
            if (!this.verifyJSONArguments(stage3Object, "result")) {
                this.log("Malformed response from: " + node + " using version " + (Object)((Object)beVersion));
                return null;
            }
            return stage3Object.get("result").getAsBoolean();
        }
        if (beVersion == BEVersion.V2_PLAINTEXT) {
            String stage1URL = String.valueOf(node) + "/user/getServerID?username=" + this.encodeString(username) + "&userip=" + ip;
            JsonObject stage1Object = this.getJSONFromURL(stage1URL);
            if (stage1Object == null) {
                this.log("Authentication with node: " + node + " has failed as JSON can't be fetched.");
                return null;
            }
            if (!this.verifyJSONArguments(stage1Object, "userIP", "error", "serverID", "username")) {
                this.log("Malformed response from: " + node + " using version " + (Object)((Object)beVersion));
                return null;
            }
            String serverID = stage1Object.get("serverID").getAsString();
            Boolean mojangAuthentication = this.authenticateWithMojang(username, sessionToken, serverID);
            if (mojangAuthentication == null) {
                this.log("Authentication with node: " + node + " has failed due to auth failure with Mojang.");
                return null;
            }
            if (!mojangAuthentication.booleanValue()) {
                this.log("Authentication with node: " + node + " has failed. Token is probably incorrect, or user is cracked!");
                return false;
            }
            String stage3URL = String.valueOf(node) + "/user/successfulAuth?username=" + this.encodeString(username) + "&serverid=" + this.encodeString(serverID) + "&userip=" + this.encodeString(ip);
            JsonObject stage3Object = this.getJSONFromURL(stage3URL);
            if (stage3Object == null) {
                this.log("Authentication with node: " + node + " has failed as JSON can't be fetched.");
                return null;
            }
            if (!this.verifyJSONArguments(stage3Object, "result")) {
                this.log("Malformed response from: " + node + " using version " + (Object)((Object)beVersion));
                return null;
            }
            return stage3Object.get("result").getAsBoolean();
        }
        return null;
    }

    public String getExternalIP() {
        String ip = this.getIPFromAmazon();
        if (ip == null) {
            ip = this.getIPFromWhatIsMyIpAddress();
        }
        return ip;
    }

    private String getIPFromAmazon() {
        try {
            URL myIP = new URL("http://checkip.amazonaws.com");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(myIP.openStream()));
            return bufferedReader.readLine();
        }
        catch (Exception e) {
            this.log("Failed to get IP from Amazon, your internet is probably down.");
            if (this.debug) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private String getIPFromWhatIsMyIpAddress() {
        try {
            URL myIP = new URL("https://ipv4bot.whatismyipaddress.com/");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(myIP.openStream()));
            return bufferedReader.readLine();
        }
        catch (Exception e) {
            this.log("Failed to get IP from WhatIsMyIpAddress, your internet is probably down.");
            if (this.debug) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private static JsonObject readJsonFromUrl(String url) throws IOException {
        return BetaEvolutionsUtils.readJsonFromUrlWithTimeout(url, 5000);
    }

    private static JsonObject readJsonFromUrlWithTimeout(String url, int timeout) throws IOException {
        URL myURL = new URL(url);
        HttpURLConnection connection = (HttpURLConnection)myURL.openConnection();
        connection.setConnectTimeout(timeout);
        connection.setReadTimeout(timeout);
        connection.setRequestMethod("GET");
        connection.connect();
        InputStream is = connection.getInputStream();
        try {
            JsonObject json;
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            String jsonText = BetaEvolutionsUtils.readAll(rd);
            JsonObject jsonObject = json = Util.gson.fromJson(jsonText, JsonObject.class);
            return jsonObject;
        }
        finally {
            is.close();
        }
    }

    private static String readAll(Reader rd) throws IOException {
        int cp;
        StringBuilder sb = new StringBuilder();
        while ((cp = rd.read()) != -1) {
            sb.append((char)cp);
        }
        return sb.toString();
    }

    private JsonObject getJSONFromURL(String url) {
        try {
            JsonObject jsonObject = BetaEvolutionsUtils.readJsonFromUrl(url);
            return jsonObject;
        }
        catch (Exception e) {
            if (this.debug) {
                this.log("An error occurred fetching JSON from: " + url);
                e.printStackTrace();
            }
            return null;
        }
    }

    private void log(String info) {
        if (this.debug) {
            System.out.println("[Beta Evolutions] " + info);
        }
    }

    private String encodeString(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (Exception e) {
            this.log("An error occurred encoding a string, this really shouldn't happen on modern JVMs.");
            e.printStackTrace();
            return null;
        }
    }

    private boolean verifyJSONArguments(JsonObject jsonObject, String ... arguments) {
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!jsonObject.has(s)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BEVersion {
        V1,
        V2_PLAINTEXT;

    }

    public class VerificationResults {
        private int successful = 0;
        private int failed = 0;
        private int errored = 0;

        public VerificationResults() {
        }

        public VerificationResults(int successful, int failed, int errored) {
            this.successful = successful;
            this.failed = failed;
            this.errored = errored;
        }

        public int getSuccessful() {
            return this.successful;
        }

        public void setSuccessful(int successful) {
            this.successful = successful;
        }

        public int getFailed() {
            return this.failed;
        }

        public void setFailed(int failed) {
            this.failed = failed;
        }

        public int getErrored() {
            return this.errored;
        }

        public void setErrored(int errored) {
            this.errored = errored;
        }

        public int getTotal() {
            return this.errored + this.successful + this.failed;
        }
    }
}

