/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex.spi;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.net.URL;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.sound.sampled.spi.AudioFileReader;
import org.xiph.speex.OggCrc;
import org.xiph.speex.spi.SpeexEncoding;
import org.xiph.speex.spi.SpeexFileFormatType;

public class SpeexAudioFileReader
extends AudioFileReader {
    public static final int OGG_HEADERSIZE = 27;
    public static final int SPEEX_HEADERSIZE = 80;
    public static final int SEGOFFSET = 26;
    public static final String OGGID = "OggS";
    public static final String SPEEXID = "Speex   ";

    public AudioFileFormat getAudioFileFormat(File file) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = null;
        try {
            inputStream = new FileInputStream(file);
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream, (int)file.length());
            return audioFileFormat;
        }
        finally {
            inputStream.close();
        }
    }

    public AudioFileFormat getAudioFileFormat(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = url.openStream();
        try {
            AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream);
            return audioFileFormat;
        }
        finally {
            inputStream.close();
        }
    }

    public AudioFileFormat getAudioFileFormat(InputStream stream) throws UnsupportedAudioFileException, IOException {
        return this.getAudioFileFormat(stream, -1);
    }

    protected AudioFileFormat getAudioFileFormat(InputStream stream, int medialength) throws UnsupportedAudioFileException, IOException {
        return this.getAudioFileFormat(stream, null, medialength);
    }

    protected AudioFileFormat getAudioFileFormat(InputStream bitStream, ByteArrayOutputStream baos, int mediaLength) throws UnsupportedAudioFileException, IOException {
        AudioFormat format;
        try {
            boolean vbr;
            if (bitStream.markSupported()) {
                bitStream.mark(675);
            }
            int mode = -1;
            int sampleRate = 0;
            int channels = 0;
            int frameSize = -1;
            float frameRate = -1.0f;
            byte[] header = new byte[128];
            int segments = 0;
            int bodybytes = 0;
            DataInputStream dis = new DataInputStream(bitStream);
            if (baos == null) {
                baos = new ByteArrayOutputStream(128);
            }
            dis.readFully(header, 0, 27);
            baos.write(header, 0, 27);
            int origchksum = SpeexAudioFileReader.readInt(header, 22);
            header[22] = 0;
            header[23] = 0;
            header[24] = 0;
            header[25] = 0;
            int chksum = OggCrc.checksum(0, header, 0, 27);
            if (!OGGID.equals(new String(header, 0, 4))) {
                throw new UnsupportedAudioFileException("missing ogg id!");
            }
            segments = header[26] & 0xFF;
            if (segments > 1) {
                throw new UnsupportedAudioFileException("Corrupt Speex Header: more than 1 segments");
            }
            dis.readFully(header, 27, segments);
            baos.write(header, 27, segments);
            chksum = OggCrc.checksum(chksum, header, 27, segments);
            bodybytes = header[27] & 0xFF;
            if (bodybytes != 80) {
                throw new UnsupportedAudioFileException("Corrupt Speex Header: size=" + bodybytes);
            }
            dis.readFully(header, 28, bodybytes);
            baos.write(header, 28, bodybytes);
            chksum = OggCrc.checksum(chksum, header, 28, bodybytes);
            if (!SPEEXID.equals(new String(header, 28, 8))) {
                throw new UnsupportedAudioFileException("Corrupt Speex Header: missing Speex ID");
            }
            mode = SpeexAudioFileReader.readInt(header, 68);
            sampleRate = SpeexAudioFileReader.readInt(header, 64);
            channels = SpeexAudioFileReader.readInt(header, 76);
            int nframes = SpeexAudioFileReader.readInt(header, 92);
            boolean bl = vbr = SpeexAudioFileReader.readInt(header, 88) == 1;
            if (chksum != origchksum) {
                throw new IOException("Ogg CheckSums do not match");
            }
            if (mode >= 0 && mode <= 2 && nframes > 0) {
                frameRate = (float)sampleRate / ((mode == 0 ? 160.0f : (mode == 1 ? 320.0f : 640.0f)) * (float)nframes);
            }
            format = new AudioFormat(SpeexEncoding.SPEEX, sampleRate, -1, channels, frameSize, frameRate, false);
        }
        catch (UnsupportedAudioFileException e) {
            if (bitStream.markSupported()) {
                bitStream.reset();
            }
            throw e;
        }
        catch (IOException ioe) {
            if (bitStream.markSupported()) {
                bitStream.reset();
            }
            throw new UnsupportedAudioFileException(ioe.getMessage());
        }
        return new AudioFileFormat(SpeexFileFormatType.SPEEX, format, -1);
    }

    public AudioInputStream getAudioInputStream(File file) throws UnsupportedAudioFileException, IOException {
        FileInputStream inputStream = new FileInputStream(file);
        try {
            return this.getAudioInputStream(inputStream, (int)file.length());
        }
        catch (UnsupportedAudioFileException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
        catch (IOException e) {
            ((InputStream)inputStream).close();
            throw e;
        }
    }

    public AudioInputStream getAudioInputStream(URL url) throws UnsupportedAudioFileException, IOException {
        InputStream inputStream = url.openStream();
        try {
            return this.getAudioInputStream(inputStream);
        }
        catch (UnsupportedAudioFileException e) {
            inputStream.close();
            throw e;
        }
        catch (IOException e) {
            inputStream.close();
            throw e;
        }
    }

    public AudioInputStream getAudioInputStream(InputStream stream) throws UnsupportedAudioFileException, IOException {
        return this.getAudioInputStream(stream, -1);
    }

    protected AudioInputStream getAudioInputStream(InputStream inputStream, int medialength) throws UnsupportedAudioFileException, IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(128);
        AudioFileFormat audioFileFormat = this.getAudioFileFormat(inputStream, baos, medialength);
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        SequenceInputStream sequenceInputStream = new SequenceInputStream(bais, inputStream);
        return new AudioInputStream(sequenceInputStream, audioFileFormat.getFormat(), audioFileFormat.getFrameLength());
    }

    private static int readInt(byte[] data, int offset) {
        return data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8 | (data[offset + 2] & 0xFF) << 16 | data[offset + 3] << 24;
    }
}

