/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import org.xiph.speex.HighLspQuant;
import org.xiph.speex.NbCodec;
import org.xiph.speex.SplitShapeSearch;
import org.xiph.speex.SubMode;

public class SbCodec
extends NbCodec {
    public static final int[] SB_FRAME_SIZE = new int[]{4, 36, 112, 192, 352, -1, -1, -1};
    public static final int SB_SUBMODES = 8;
    public static final int SB_SUBMODE_BITS = 3;
    public static final int QMF_ORDER = 64;
    protected int fullFrameSize;
    protected float foldingGain;
    protected float[] high;
    protected float[] y0;
    protected float[] y1;
    protected float[] x0d;
    protected float[] g0_mem;
    protected float[] g1_mem;

    public void wbinit() {
        this.submodes = SbCodec.buildWbSubModes();
        this.submodeID = 3;
    }

    public void uwbinit() {
        this.submodes = SbCodec.buildUwbSubModes();
        this.submodeID = 1;
    }

    protected void init(int frameSize, int subframeSize, int lpcSize, int bufSize, float foldingGain) {
        super.init(frameSize, subframeSize, lpcSize, bufSize);
        this.fullFrameSize = 2 * frameSize;
        this.foldingGain = foldingGain;
        this.lag_factor = 0.002f;
        this.high = new float[this.fullFrameSize];
        this.y0 = new float[this.fullFrameSize];
        this.y1 = new float[this.fullFrameSize];
        this.x0d = new float[frameSize];
        this.g0_mem = new float[64];
        this.g1_mem = new float[64];
    }

    protected static SubMode[] buildWbSubModes() {
        HighLspQuant highLU = new HighLspQuant();
        SplitShapeSearch ssCbHighLbrSearch = new SplitShapeSearch(40, 10, 4, hexc_10_32_table, 5, 0);
        SplitShapeSearch ssCbHighSearch = new SplitShapeSearch(40, 8, 5, hexc_table, 7, 1);
        SubMode[] wbSubModes = new SubMode[8];
        wbSubModes[1] = new SubMode(0, 0, 1, 0, highLU, null, null, 0.75f, 0.75f, -1.0f, 36);
        wbSubModes[2] = new SubMode(0, 0, 1, 0, highLU, null, ssCbHighLbrSearch, 0.85f, 0.6f, -1.0f, 112);
        wbSubModes[3] = new SubMode(0, 0, 1, 0, highLU, null, ssCbHighSearch, 0.75f, 0.7f, -1.0f, 192);
        wbSubModes[4] = new SubMode(0, 0, 1, 1, highLU, null, ssCbHighSearch, 0.75f, 0.75f, -1.0f, 352);
        return wbSubModes;
    }

    protected static SubMode[] buildUwbSubModes() {
        HighLspQuant highLU = new HighLspQuant();
        SubMode[] uwbSubModes = new SubMode[8];
        uwbSubModes[1] = new SubMode(0, 0, 1, 0, highLU, null, null, 0.75f, 0.75f, -1.0f, 2);
        return uwbSubModes;
    }

    public int getFrameSize() {
        return this.fullFrameSize;
    }

    public boolean getDtx() {
        return this.dtx_enabled != 0;
    }

    public float[] getExc() {
        float[] excTmp = new float[this.fullFrameSize];
        int i = 0;
        while (i < this.frameSize) {
            excTmp[2 * i] = 2.0f * this.excBuf[this.excIdx + i];
            ++i;
        }
        return excTmp;
    }

    public float[] getInnov() {
        return this.getExc();
    }
}

