/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hyperconference.net.packet;

import com.vulpovile.hyperconference.UserData;
import com.vulpovile.hyperconference.net.MessageService;
import com.vulpovile.hyperconference.net.packet.DataPacket;
import com.vulpovile.hyperconference.net.packet.Packet2Ring;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;

public class Packet9AddCaller
extends Packet2Ring {
    public static final byte INET = 1;
    private SocketAddress socketAddress;

    public Packet9AddCaller() {
    }

    public Packet9AddCaller(Packet2Ring ringPacket, SocketAddress address) {
        super(ringPacket.getUserData(address));
        this.socketAddress = address;
    }

    public Packet9AddCaller(UserData userData) {
        super(userData);
        this.socketAddress = userData.address;
    }

    public void processPacket(MessageService service, DatagramPacket parentPacket, short opcode) throws IOException {
        service.handleDataPacket(this, parentPacket, opcode);
    }

    public DataPacket newInstance() {
        return new Packet9AddCaller();
    }

    public void readIn(DatagramPacket parentPacket, DataInputStream in, int dataLength) throws IOException {
        super.readIn(parentPacket, in, dataLength);
        byte type = in.readByte();
        switch (type) {
            case 1: {
                int port = in.readUnsignedShort();
                byte[] addressBytes = new byte[in.readUnsignedShort()];
                in.readFully(addressBytes);
                this.socketAddress = new InetSocketAddress(InetAddress.getByAddress(addressBytes), port);
                break;
            }
            default: {
                this.socketAddress = null;
            }
        }
    }

    public void writeOut(DataOutputStream out) throws IOException {
        super.writeOut(out);
        if (this.socketAddress instanceof InetSocketAddress) {
            InetSocketAddress iadd = (InetSocketAddress)this.socketAddress;
            byte[] addressBytes = iadd.getAddress().getAddress();
            int port = iadd.getPort();
            out.writeByte(1);
            out.writeShort(port);
            out.writeShort(addressBytes.length);
            out.write(addressBytes);
        }
    }

    public UserData getUserData() {
        return this.getUserData(this.socketAddress);
    }
}

