/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hyperconference.net.packet;

import com.vulpovile.hyperconference.UserData;
import com.vulpovile.hyperconference.net.MessageService;
import com.vulpovile.hyperconference.net.packet.DataPacket;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.SocketAddress;

public class Packet2Ring
extends DataPacket {
    private String alias;
    private String firstName;
    private String lastName;
    private String hostName;
    private String email;

    public Packet2Ring() {
    }

    public Packet2Ring(UserData user) {
        this.alias = user.alias;
        this.firstName = user.firstName;
        this.lastName = user.lastName;
        this.hostName = user.hostName;
        this.email = user.email;
    }

    public void readIn(DatagramPacket parentPacket, DataInputStream in, int dataLength) throws IOException {
        this.firstName = Packet2Ring.readString(in);
        this.lastName = Packet2Ring.readString(in);
        this.email = Packet2Ring.readString(in);
        this.alias = Packet2Ring.readString(in);
        this.hostName = Packet2Ring.readString(in);
    }

    public void writeOut(DataOutputStream out) throws IOException {
        Packet2Ring.writeString(this.firstName, out);
        Packet2Ring.writeString(this.lastName, out);
        Packet2Ring.writeString(this.email, out);
        Packet2Ring.writeString(this.alias, out);
        Packet2Ring.writeString(this.hostName, out);
    }

    public void processPacket(MessageService service, DatagramPacket parentPacket, short opcode) throws IOException {
        service.handleDataPacket(this, parentPacket, opcode);
    }

    public DataPacket newInstance() {
        return new Packet2Ring();
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getAlias() {
        return this.alias;
    }

    public String getFormattedAlias() {
        return UserData.formatAlias(this.alias, this.firstName, this.lastName);
    }

    public String getHostName() {
        return this.hostName;
    }

    public String getEmail() {
        return this.email;
    }

    public UserData getUserData(SocketAddress address) {
        return new UserData(this.firstName, this.lastName, this.email, this.alias, this.hostName, address);
    }
}

