/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hyperconference.net;

import com.vulpovile.hyperconference.net.PacketIDBuffer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class PacketProcessor
implements Runnable {
    protected DatagramSocket socket;
    protected DatagramSocket sendSocket;
    byte[] datagramBuffer;
    private ScheduledExecutorService executor = new ScheduledThreadPoolExecutor(16);
    private PacketIDBuffer<Short> packetBuffer = new PacketIDBuffer(256);
    private Map<Short, ScheduledFuture<?>> resendTasks = new ConcurrentHashMap();
    private short lastOrder = 0;
    private AtomicInteger orderCounter = new AtomicInteger(0);
    private Thread parentThread = null;
    public static final byte ACKNOWLEDGE = 1;
    public static final byte ORDERED = 2;
    private boolean online = false;

    public PacketProcessor(DatagramSocket socket, int datagramBufferSize) {
        this(socket, socket, datagramBufferSize);
    }

    public PacketProcessor(DatagramSocket recvSocket, DatagramSocket sendSocket, int datagramBufferSize) {
        this.socket = recvSocket;
        this.sendSocket = sendSocket;
        this.datagramBuffer = new byte[datagramBufferSize];
    }

    public void processPacket(DatagramPacket packet) {
        try {
            DataInputStream bais = new DataInputStream(new ByteArrayInputStream(packet.getData(), 0, packet.getLength()));
            short opcode = bais.readShort();
            byte flags = (byte)(opcode & 0xF);
            opcode = (short)(opcode >> 4 & 0xFFF);
            short order = bais.readShort();
            if (opcode == 1) {
                ScheduledFuture<?> task = this.resendTasks.remove(order);
                if (task != null) {
                    task.cancel(false);
                }
                return;
            }
            if ((flags & 1) > 0) {
                this.sendPacketData(packet.getSocketAddress(), 1, 0, order, null);
                if (this.packetBuffer.has(order)) {
                    if (order > this.lastOrder) {
                        this.lastOrder = order;
                    }
                    return;
                }
                this.packetBuffer.push(order);
            }
            if ((flags & 2) > 0 && this.packetTooOld(order)) {
                return;
            }
            if (order > this.lastOrder) {
                this.lastOrder = order;
            }
            this.process(packet, opcode, bais, packet.getLength() - 32);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void startRecv() {
        if (!this.online && this.parentThread == null) {
            this.online = true;
            this.parentThread = new Thread(this);
            this.parentThread.start();
        }
    }

    public void stopRecv() {
        this.online = false;
        if (this.parentThread != null) {
            this.parentThread.interrupt();
        }
    }

    public void run() {
        while (this.online && this.socket != null) {
            try {
                DatagramPacket packet = new DatagramPacket(this.datagramBuffer, this.datagramBuffer.length);
                try {
                    this.socket.receive(packet);
                    this.processPacket(packet);
                }
                catch (SocketTimeoutException socketTimeoutException) {}
            }
            catch (IOException ex) {
                this.socketRecvError(ex);
            }
        }
    }

    private boolean packetTooOld(short order) {
        return (order - this.lastOrder & 0xFFFF) > 4095;
    }

    protected abstract void process(DatagramPacket var1, short var2, DataInputStream var3, int var4) throws IOException;

    protected abstract boolean socketRecvError(IOException var1);

    public void sendPacketData(SocketAddress address, int opcode, int flags, byte[] bytes) throws IOException {
        this.sendPacketData(address, opcode, flags, this.orderCounter.getAndIncrement() & 0xFFFF, bytes);
    }

    private void sendPacketData(SocketAddress address, final int opcode, int flags, final int order, byte[] bytes) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(baos);
        dos.writeShort(opcode << 4 | flags & 0xF);
        dos.writeShort(order);
        if (bytes != null) {
            dos.write(bytes);
        }
        dos.close();
        byte[] packet = baos.toByteArray();
        final DatagramPacket sendPacket = new DatagramPacket(packet, packet.length, address);
        this.sendSocket.send(sendPacket);
        if ((flags & 1) > 0) {
            ScheduledFuture<?> future = this.executor.scheduleAtFixedRate(new Runnable(){
                int attempts = 0;

                public void run() {
                    try {
                        ++this.attempts;
                        if (this.attempts > 20) {
                            PacketProcessor.this.internalAcknowledgeFailed((short)opcode, (short)order, sendPacket);
                        }
                        PacketProcessor.this.sendSocket.send(sendPacket);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }, 1L, 1L, TimeUnit.SECONDS);
            this.resendTasks.put((short)order, future);
        }
    }

    private final void internalAcknowledgeFailed(short opcode, short order, DatagramPacket datagram) {
        ScheduledFuture<?> task = this.resendTasks.remove(order);
        if (task != null) {
            task.cancel(false);
        }
        this.acknowledgeFailed(opcode, order, datagram);
    }

    protected abstract void acknowledgeFailed(short var1, short var2, DatagramPacket var3);

    public void shutdown(boolean closeSocket) {
        if (closeSocket) {
            this.socket.close();
        }
        this.executor.shutdownNow();
    }
}

