/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hyperconference.net;

import com.vulpovile.hyperconference.MainInterface;
import com.vulpovile.hyperconference.UserData;
import com.vulpovile.hyperconference.net.CallManager;
import com.vulpovile.hyperconference.net.PacketProcessor;
import com.vulpovile.hyperconference.net.packet.DataPacket;
import com.vulpovile.hyperconference.net.packet.Packet2Ring;
import com.vulpovile.hyperconference.net.packet.Packet3HangUp;
import com.vulpovile.hyperconference.net.packet.Packet4VoiceData;
import com.vulpovile.hyperconference.net.packet.Packet5Reject;
import com.vulpovile.hyperconference.net.packet.Packet6Answer;
import com.vulpovile.hyperconference.net.packet.Packet7Message;
import com.vulpovile.hyperconference.net.packet.Packet8EndCall;
import com.vulpovile.hyperconference.net.packet.Packet9AddCaller;
import com.vulpovile.hyperconference.ui.CallInitializer;
import com.vulpovile.hyperconference.ui.RingDialog;
import com.vulpovile.hyperconference.util.SfxPlayer;
import java.awt.EventQueue;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageService
extends PacketProcessor {
    private MainInterface mainInterface;
    private CallInitializer callInitializer;
    private Map<SocketAddress, RingDialog> ringing = Collections.synchronizedMap(new HashMap());
    private Map<SocketAddress, CallManager> connectedUsers = Collections.synchronizedMap(new HashMap());
    private List<CallManager> connectedUserList = Collections.synchronizedList(new ArrayList());

    private MessageService(DatagramSocket recvSocket, DatagramSocket sendSocket) {
        super(recvSocket, sendSocket, 4096);
    }

    private MessageService(DatagramSocket socket) {
        super(socket, 4096);
    }

    public MessageService(MainInterface mainInterface) throws IOException {
        this(new DatagramSocket(4447, InetAddress.getByName("0.0.0.0")));
        this.mainInterface = mainInterface;
        this.socket.setSoTimeout(1000);
    }

    @Override
    protected void process(DatagramPacket packet, short opcode, DataInputStream in, int streamLength) throws IOException {
        DataPacket dataPacket = DataPacket.getPacket(opcode);
        if (dataPacket == null) {
            this.sendPacket(packet.getSocketAddress(), new Packet5Reject(opcode), 0);
            return;
        }
        CallManager callManager = this.connectedUsers.get(packet.getSocketAddress());
        if (callManager != null) {
            callManager.callKeepAlive();
        }
        dataPacket.readIn(packet, in, streamLength);
        dataPacket.processPacket(this, packet, opcode);
    }

    @Override
    protected boolean socketRecvError(IOException ex) {
        return false;
    }

    public void handleDataPacket(DataPacket datapacket, DatagramPacket parentDatagram, short opcode) throws IOException {
        this.sendPacket(parentDatagram.getSocketAddress(), new Packet5Reject(opcode), 0);
    }

    public void handleDataPacket(Packet2Ring datapacket, DatagramPacket parentDatagram, short opcode) throws IOException {
        if (this.callInitializer != null) {
            this.sendPacket(parentDatagram.getSocketAddress(), new Packet3HangUp(1), 0);
        } else {
            this.setRingDialog(datapacket.getUserData(parentDatagram.getSocketAddress()));
        }
    }

    public void handleDataPacket(Packet3HangUp datapacket, DatagramPacket parentDatagram, short opcode) throws IOException {
        CallManager callManager = this.removeCaller(parentDatagram.getSocketAddress(), false);
        if (callManager != null) {
            JOptionPane.showMessageDialog(this.mainInterface, String.valueOf(callManager.toString()) + " hung up.", "Call Ended", 1);
            this.mainInterface.notifyCallersChanged();
        } else if (this.callInitializer != null && parentDatagram.getSocketAddress().equals(this.callInitializer.getAddress())) {
            this.callInitializer.stopCalling();
            this.callInitializer = null;
            if (datapacket.getReason() == 0) {
                SfxPlayer.rplay("/hup.wav");
                JOptionPane.showMessageDialog(this.mainInterface, "User hung up.", "Call Not Accepted", 1);
            } else if (datapacket.getReason() == 1) {
                SfxPlayer.rplay("/bsy.wav", 2);
                JOptionPane.showMessageDialog(this.mainInterface, "User is busy.", "Call Not Accepted", 1);
            }
        }
    }

    public CallManager removeCaller(SocketAddress address, boolean sendHangup) {
        this.killRinger(address);
        CallManager callManager = this.connectedUsers.remove(address);
        if (callManager != null) {
            this.connectedUserList.remove(callManager);
            callManager.destroy();
        }
        if (sendHangup) {
            try {
                this.sendPacket(address, new Packet3HangUp(), 1);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return callManager;
    }

    public void handleDataPacket(Packet4VoiceData datapacket, DatagramPacket parentDatagram, short opcode) throws IOException {
        CallManager callManager = this.connectedUsers.get(parentDatagram.getSocketAddress());
        if (callManager != null) {
            callManager.voice(datapacket.getVoiceData());
        }
    }

    public void handleDataPacket(Packet5Reject datapacket, DatagramPacket parentDatagram, short opcode) throws IOException {
    }

    public void handleDataPacket(Packet6Answer datapacket, DatagramPacket parentDatagram, short opcode) throws IOException {
        if (this.callInitializer != null && parentDatagram.getSocketAddress().equals(this.callInitializer.getAddress())) {
            this.callInitializer.stopCalling();
            this.callInitializer = null;
            this.broadcastPacket(new Packet9AddCaller(datapacket.getUserData(parentDatagram.getSocketAddress())), 1, parentDatagram.getSocketAddress());
        }
        this.addCaller(datapacket.getUserData(parentDatagram.getSocketAddress()));
    }

    public void handleDataPacket(Packet7Message datapacket, DatagramPacket parentDatagram, short opcode) throws IOException {
        CallManager user = this.connectedUsers.get(parentDatagram.getSocketAddress());
        if (user != null) {
            this.mainInterface.messageRecieved(user.getUserData(), datapacket.getMessage());
        }
    }

    public void handleDataPacket(Packet8EndCall datapacket, DatagramPacket parentDatagram, short opcode) throws IOException {
        this.endAllCalls();
    }

    public void handleDataPacket(Packet9AddCaller datapacket, DatagramPacket parentDatagram, short opcode) throws IOException {
        this.addCaller(datapacket.getUserData());
    }

    public void endAllCalls() {
        int i = this.connectedUserList.size() - 1;
        while (i >= 0) {
            CallManager user = this.connectedUserList.remove(0);
            user.destroy();
            this.connectedUsers.remove(user.getUserData().address);
            try {
                this.sendPacket(user.getUserData().address, new Packet3HangUp(), 1);
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            --i;
        }
        SfxPlayer.rplay("/hup.wav");
        this.mainInterface.notifyCallersChanged();
    }

    public void broadcastPacket(DataPacket packet, int flags, SocketAddress exclude) throws IOException {
        for (CallManager user : this.connectedUserList) {
            SocketAddress send = user.getUserData().address;
            if (send.equals(exclude)) continue;
            this.sendPacket(send, packet, flags);
        }
    }

    public void sendPacket(SocketAddress address, DataPacket packet, int flags) throws IOException {
        this.sendPacketData(address, packet.getID(), flags, packet.toBytes());
    }

    public void ringStopped(SocketAddress address) {
        this.killRinger(address);
    }

    public void addCaller(UserData userData) {
        CallManager callManager = new CallManager(this, userData);
        callManager.init();
        SfxPlayer.rplay("/pup.wav");
        this.connectedUsers.put(userData.address, callManager);
        this.connectedUserList.add(callManager);
        this.killRinger(userData.address);
        this.mainInterface.notifyCallersChanged();
    }

    public void acceptCall(UserData userData) {
        try {
            this.sendPacket(userData.address, new Packet6Answer(this.mainInterface.getCurrentUser()), 1);
            this.broadcastPacket(new Packet9AddCaller(userData), 1, userData.address);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.addCaller(userData);
    }

    private void killRinger(SocketAddress address) {
        RingDialog dialog = this.ringing.remove(address);
        System.out.println("Dialog is " + dialog);
        if (dialog != null) {
            dialog.stopDialog();
        }
    }

    private void setRingDialog(final UserData userData) {
        if (this.ringing.containsKey(userData.address)) {
            this.ringing.get(userData.address).ring();
        } else if (!this.connectedUsers.containsKey(userData.address)) {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    RingDialog ringDialog = new RingDialog(MessageService.this, userData);
                    MessageService.this.ringing.put(userData.address, ringDialog);
                    ringDialog.startDialog();
                    ringDialog.ring();
                }
            });
        }
    }

    public void timedOut(SocketAddress address) {
        CallManager caller = this.removeCaller(address, true);
        SfxPlayer.rplay("/hup.wav");
        this.mainInterface.notifyCallersChanged();
        JOptionPane.showMessageDialog(this.mainInterface, String.valueOf(caller.toString()) + " timed out.", "Call Ended", 1);
    }

    public boolean sendVoicePacket(byte[] buffer) {
        Packet4VoiceData packet = new Packet4VoiceData(buffer);
        try {
            this.broadcastPacket(packet, 2, null);
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void setCaller(SocketAddress isa, CallInitializer callInitializer) throws IOException {
        if (this.callInitializer == null) {
            this.callInitializer = callInitializer;
        } else if (callInitializer == null) {
            this.callInitializer = null;
        } else {
            throw new IOException("Already calling");
        }
    }

    @Override
    protected void acknowledgeFailed(short opcode, short order, DatagramPacket datagram) {
        this.removeCaller(datagram.getSocketAddress(), true);
    }

    public List<CallManager> getConnected() {
        return Collections.unmodifiableList(this.connectedUserList);
    }

    public void sendMessage(String text) {
        try {
            this.broadcastPacket(new Packet7Message(text), 1, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

