/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hyperconference;

import com.vulpovile.hyperconference.PropertyManager;
import java.net.InetAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;

public class UserData {
    public final String alias;
    public final String firstName;
    public final String lastName;
    public final String email;
    public final String hostName;
    public final SocketAddress address;

    public UserData(String firstName, String lastName, String email, String alias, String hostName, SocketAddress address) {
        this.alias = UserData.formatAlias(alias, firstName, lastName);
        this.firstName = firstName;
        this.lastName = lastName;
        this.email = email;
        this.address = address;
        this.hostName = hostName;
    }

    public String toString() {
        return this.alias;
    }

    public static String formatAlias(String alias, String firstName, String lastName) {
        if (alias == null || alias.trim().length() <= 0) {
            alias = String.valueOf(firstName) + " " + lastName;
        }
        return alias;
    }

    public static UserData readProperties(PropertyManager propManager) {
        String firstName = propManager.getProperty("username", "");
        String lastName = propManager.getProperty("usersurname", "");
        String email = propManager.getProperty("useremail", "");
        String hostName = "localhost";
        String alias = UserData.formatAlias(propManager.getProperty("useralias", ""), firstName, lastName);
        try {
            hostName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        return new UserData(firstName, lastName, email, alias, hostName, null);
    }
}

