/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hyperconference;

import com.vulpovile.hyperconference.util.Util;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class PropertyManager {
    private final File propFile;
    Properties properties = new Properties();

    public PropertyManager(File propertyFile) {
        this.propFile = propertyFile;
    }

    public boolean load() {
        if (!this.propFile.exists()) {
            return false;
        }
        FileInputStream is = null;
        try {
            is = new FileInputStream(this.propFile);
            this.properties.load(is);
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Util.cleanClose(is);
                throw throwable;
            }
            Util.cleanClose(is);
            return false;
        }
        Util.cleanClose(is);
        return true;
    }

    public boolean store() {
        FileOutputStream is = null;
        try {
            is = new FileOutputStream(this.propFile);
            this.properties.store(is, "HyperConference Properties");
        }
        catch (IOException e) {
            try {
                e.printStackTrace();
            }
            catch (Throwable throwable) {
                Util.cleanClose(is);
                throw throwable;
            }
            Util.cleanClose(is);
            return false;
        }
        Util.cleanClose(is);
        return true;
    }

    public String getProperty(String property) {
        return this.properties.getProperty(property);
    }

    public String getProperty(String property, String fallback) {
        return this.properties.getProperty(property, fallback);
    }

    public void setProperty(String property, String value) {
        this.properties.setProperty(property, value);
    }
}

