/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

public class VQ {
    public static final int index(float in, float[] codebook, int entries) {
        float min_dist = 0.0f;
        int best_index = 0;
        int i = 0;
        while (i < entries) {
            float dist = in - codebook[i];
            dist *= dist;
            if (i == 0 || dist < min_dist) {
                min_dist = dist;
                best_index = i;
            }
            ++i;
        }
        return best_index;
    }

    public static final int index(float[] in, float[] codebook, int len, int entries) {
        int k = 0;
        float min_dist = 0.0f;
        int best_index = 0;
        int i = 0;
        while (i < entries) {
            float dist = 0.0f;
            int j = 0;
            while (j < len) {
                float tmp = in[j] - codebook[k++];
                dist += tmp * tmp;
                ++j;
            }
            if (i == 0 || dist < min_dist) {
                min_dist = dist;
                best_index = i;
            }
            ++i;
        }
        return best_index;
    }

    public static final void nbest(float[] in, int offset, float[] codebook, int len, int entries, float[] E, int N, int[] nbest, float[] best_dist) {
        int l = 0;
        int used = 0;
        int i = 0;
        while (i < entries) {
            float dist = 0.5f * E[i];
            int j = 0;
            while (j < len) {
                dist -= in[offset + j] * codebook[l++];
                ++j;
            }
            if (i < N || dist < best_dist[N - 1]) {
                int k = N - 1;
                while (k >= 1 && (k > used || dist < best_dist[k - 1])) {
                    best_dist[k] = best_dist[k - 1];
                    nbest[k] = nbest[k - 1];
                    --k;
                }
                best_dist[k] = dist;
                nbest[k] = i;
                ++used;
            }
            ++i;
        }
    }

    public static final void nbest_sign(float[] in, int offset, float[] codebook, int len, int entries, float[] E, int N, int[] nbest, float[] best_dist) {
        int l = 0;
        int used = 0;
        int i = 0;
        while (i < entries) {
            boolean sign;
            float dist = 0.0f;
            int j = 0;
            while (j < len) {
                dist -= in[offset + j] * codebook[l++];
                ++j;
            }
            if (dist > 0.0f) {
                sign = true;
                dist = -dist;
            } else {
                sign = false;
            }
            dist = (float)((double)dist + 0.5 * (double)E[i]);
            if (i < N || dist < best_dist[N - 1]) {
                int k = N - 1;
                while (k >= 1 && (k > used || dist < best_dist[k - 1])) {
                    best_dist[k] = best_dist[k - 1];
                    nbest[k] = nbest[k - 1];
                    --k;
                }
                best_dist[k] = dist;
                nbest[k] = i;
                ++used;
                if (sign) {
                    int n = k;
                    nbest[n] = nbest[n] + entries;
                }
            }
            ++i;
        }
    }
}

