/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hyperconference.net;

import com.vulpovile.hyperconference.UserData;
import com.vulpovile.hyperconference.codec.base.uLaw;
import com.vulpovile.hyperconference.net.MessageService;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class CallManager
implements Runnable {
    private long nextTimeout = 0L;
    private boolean connected;
    private Thread parentThread = null;
    private UserData userData;
    private MessageService messageService;
    private SourceDataLine speaker;

    public CallManager(MessageService messageService, UserData userData) {
        this.userData = userData;
        this.messageService = messageService;
    }

    public void callKeepAlive() {
        this.nextTimeout = 10L;
    }

    public UserData getUserData() {
        return this.userData;
    }

    public void run() {
        this.nextTimeout = 10L;
        while (this.connected) {
            try {
                Thread.sleep(1000L);
                if (--this.nextTimeout > 0L) continue;
                this.connected = false;
                this.messageService.timedOut(this.userData.address);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        this.parentThread = null;
    }

    public String toString() {
        return this.userData.toString();
    }

    public void destroy() {
        this.connected = false;
        if (this.parentThread != null) {
            this.parentThread.interrupt();
        }
        if (this.speaker != null) {
            this.speaker.stop();
            this.speaker.close();
            this.speaker = null;
        }
    }

    public boolean init() {
        this.connected = true;
        if (this.parentThread == null) {
            this.parentThread = new Thread(this);
            this.parentThread.start();
            AudioFormat format = new AudioFormat(8000.0f, 16, 1, true, false);
            try {
                this.speaker = AudioSystem.getSourceDataLine(format);
                this.speaker.open(format);
                this.speaker.start();
            }
            catch (LineUnavailableException e) {
                if (this.speaker != null) {
                    this.speaker.stop();
                    this.speaker.close();
                    this.speaker = null;
                }
                e.printStackTrace();
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean voice(byte[] voiceData) {
        if (this.speaker != null) {
            byte[] buffer = uLaw.decode(voiceData);
            this.speaker.write(buffer, 0, buffer.length);
            return true;
        }
        return false;
    }
}

