/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex.spi;

import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import javax.sound.sampled.AudioFormat;
import org.xiph.speex.Bits;
import org.xiph.speex.Decoder;
import org.xiph.speex.NbDecoder;
import org.xiph.speex.SbDecoder;
import org.xiph.speex.spi.FilteredAudioInputStream;

public class Speex2PcmAudioInputStream
extends FilteredAudioInputStream {
    private boolean initialised = false;
    private int channelCount;
    private float[] decodedData;
    private byte[] outputData;
    private Bits bits = new Bits();
    private Decoder decoder;
    private int frameSize;
    private int framesPerPacket;
    private int streamSerialNumber;
    private int packetsPerOggPage;
    private int packetCount;
    private byte[] packetSizes = new byte[256];

    public Speex2PcmAudioInputStream(InputStream in, AudioFormat format, long length) {
        this(in, format, length, 2048);
    }

    public Speex2PcmAudioInputStream(InputStream in, AudioFormat format, long length, int size) {
        super(in, format, length, size);
    }

    protected void initialise(boolean blocking) throws IOException {
        while (!this.initialised) {
            int readsize = this.prebuf.length - this.precount - 1;
            int avail = this.in.available();
            if (!blocking && avail <= 0) {
                return;
            }
            readsize = avail > 0 ? Math.min(avail, readsize) : readsize;
            int n = this.in.read(this.prebuf, this.precount, readsize);
            if (n < 0) {
                throw new StreamCorruptedException("Incomplete Ogg Headers");
            }
            this.precount += n;
            if (this.decoder == null && this.precount >= 108) {
                if (!new String(this.prebuf, 0, 4).equals("OggS")) {
                    throw new StreamCorruptedException("The given stream does not appear to be Ogg.");
                }
                this.streamSerialNumber = Speex2PcmAudioInputStream.readInt(this.prebuf, 14);
                if (!new String(this.prebuf, 28, 8).equals("Speex   ")) {
                    throw new StreamCorruptedException("The given stream does not appear to be Ogg Speex.");
                }
                Speex2PcmAudioInputStream.readInt(this.prebuf, 64);
                this.channelCount = Speex2PcmAudioInputStream.readInt(this.prebuf, 76);
                this.framesPerPacket = Speex2PcmAudioInputStream.readInt(this.prebuf, 92);
                int mode = Speex2PcmAudioInputStream.readInt(this.prebuf, 68);
                switch (mode) {
                    case 0: {
                        this.decoder = new NbDecoder();
                        ((NbDecoder)this.decoder).nbinit();
                        break;
                    }
                    case 1: {
                        this.decoder = new SbDecoder();
                        ((SbDecoder)this.decoder).wbinit();
                        break;
                    }
                    case 2: {
                        this.decoder = new SbDecoder();
                        ((SbDecoder)this.decoder).uwbinit();
                    }
                }
                this.decoder.setPerceptualEnhancement(true);
                this.frameSize = this.decoder.getFrameSize();
                this.decodedData = new float[this.frameSize * this.channelCount];
                this.outputData = new byte[2 * this.frameSize * this.channelCount * this.framesPerPacket];
                this.bits.init();
            }
            if (this.decoder == null || this.precount < 135) continue;
            this.packetsPerOggPage = 0xFF & this.prebuf[134];
            if (this.precount < 135 + this.packetsPerOggPage) continue;
            int size = 0;
            int i = 0;
            while (i < this.packetsPerOggPage) {
                size += 0xFF & this.prebuf[135 + i];
                ++i;
            }
            if (this.precount < 135 + this.packetsPerOggPage + size) continue;
            this.prepos = 135 + this.packetsPerOggPage + size;
            this.packetsPerOggPage = 0;
            this.packetCount = 255;
            this.initialised = true;
        }
    }

    protected void fill() throws IOException {
        this.makeSpace();
        while (!this.initialised) {
            this.initialise(true);
        }
        while (true) {
            int read;
            if ((read = this.in.read(this.prebuf, this.precount, this.prebuf.length - this.precount)) < 0) {
                while (this.prepos < this.precount) {
                    byte n;
                    if (this.packetCount >= this.packetsPerOggPage) {
                        this.readOggPageHeader();
                    }
                    if (this.packetCount >= this.packetsPerOggPage) continue;
                    if (this.precount - this.prepos < (n = this.packetSizes[this.packetCount++])) {
                        throw new StreamCorruptedException("Incompleted last Speex packet");
                    }
                    this.decode(this.prebuf, this.prepos, n);
                    this.prepos += n;
                    while (this.buf.length - this.count < this.outputData.length) {
                        int nsz = this.buf.length * 2;
                        byte[] nbuf = new byte[nsz];
                        System.arraycopy(this.buf, 0, nbuf, 0, this.count);
                        this.buf = nbuf;
                    }
                    System.arraycopy(this.outputData, 0, this.buf, this.count, this.outputData.length);
                    this.count += this.outputData.length;
                }
                return;
            }
            if (read < 0) continue;
            this.precount += read;
            if (this.packetCount >= this.packetsPerOggPage) {
                this.readOggPageHeader();
            }
            if (this.packetCount < this.packetsPerOggPage && this.precount - this.prepos >= this.packetSizes[this.packetCount]) break;
        }
        while (this.precount - this.prepos >= this.packetSizes[this.packetCount] && this.packetCount < this.packetsPerOggPage) {
            byte n = this.packetSizes[this.packetCount++];
            this.decode(this.prebuf, this.prepos, n);
            this.prepos += n;
            while (this.buf.length - this.count < this.outputData.length) {
                int nsz = this.buf.length * 2;
                byte[] nbuf = new byte[nsz];
                System.arraycopy(this.buf, 0, nbuf, 0, this.count);
                this.buf = nbuf;
            }
            System.arraycopy(this.outputData, 0, this.buf, this.count, this.outputData.length);
            this.count += this.outputData.length;
            if (this.packetCount < this.packetsPerOggPage) continue;
            this.readOggPageHeader();
        }
        System.arraycopy(this.prebuf, this.prepos, this.prebuf, 0, this.precount - this.prepos);
        this.precount -= this.prepos;
        this.prepos = 0;
    }

    protected void decode(byte[] data, int offset, int len) throws StreamCorruptedException {
        int outputSize = 0;
        this.bits.read_from(data, offset, len);
        int frame = 0;
        while (frame < this.framesPerPacket) {
            this.decoder.decode(this.bits, this.decodedData);
            if (this.channelCount == 2) {
                this.decoder.decodeStereo(this.decodedData, this.frameSize);
            }
            int i = 0;
            while (i < this.frameSize * this.channelCount) {
                if (this.decodedData[i] > 32767.0f) {
                    this.decodedData[i] = 32767.0f;
                } else if (this.decodedData[i] < -32768.0f) {
                    this.decodedData[i] = -32768.0f;
                }
                ++i;
            }
            i = 0;
            while (i < this.frameSize * this.channelCount) {
                short val = this.decodedData[i] > 0.0f ? (short)((double)this.decodedData[i] + 0.5) : (short)((double)this.decodedData[i] - 0.5);
                this.outputData[outputSize++] = (byte)(val & 0xFF);
                this.outputData[outputSize++] = (byte)(val >> 8 & 0xFF);
                ++i;
            }
            ++frame;
        }
    }

    public synchronized long skip(long n) throws IOException {
        while (!this.initialised) {
            this.initialise(true);
        }
        this.checkIfStillOpen();
        if (n <= 0L) {
            return 0L;
        }
        if (this.pos < this.count) {
            return super.skip(n);
        }
        int decodedPacketSize = 2 * this.framesPerPacket * this.frameSize * this.channelCount;
        if (this.markpos < 0 && n >= (long)decodedPacketSize) {
            if (this.packetCount >= this.packetsPerOggPage) {
                this.readOggPageHeader();
            }
            if (this.packetCount < this.packetsPerOggPage) {
                int avail;
                int skipped = 0;
                if (this.precount - this.prepos < this.packetSizes[this.packetCount] && (avail = this.in.available()) > 0) {
                    int size = Math.min(this.prebuf.length - this.precount, avail);
                    int read = this.in.read(this.prebuf, this.precount, size);
                    if (read < 0) {
                        throw new IOException("End of stream but there are still supposed to be packets to decode");
                    }
                    this.precount += read;
                }
                while (this.precount - this.prepos >= this.packetSizes[this.packetCount] && this.packetCount < this.packetsPerOggPage && n >= (long)decodedPacketSize) {
                    this.prepos += this.packetSizes[this.packetCount++];
                    skipped += decodedPacketSize;
                    n -= (long)decodedPacketSize;
                    if (this.packetCount < this.packetsPerOggPage) continue;
                    this.readOggPageHeader();
                }
                System.arraycopy(this.prebuf, this.prepos, this.prebuf, 0, this.precount - this.prepos);
                this.precount -= this.prepos;
                this.prepos = 0;
                return skipped;
            }
        }
        return super.skip(n);
    }

    public synchronized int available() throws IOException {
        if (!this.initialised) {
            this.initialise(false);
            if (!this.initialised) {
                return 0;
            }
        }
        int avail = super.available();
        if (this.packetCount >= this.packetsPerOggPage) {
            this.readOggPageHeader();
        }
        if (this.packetCount < this.packetsPerOggPage) {
            int undecoded = this.precount - this.prepos + this.in.available();
            byte size = this.packetSizes[this.packetCount];
            int tempCount = 0;
            while (size < undecoded && this.packetCount + tempCount < this.packetsPerOggPage) {
                undecoded -= size;
                avail += 2 * this.frameSize * this.framesPerPacket;
                size = this.packetSizes[this.packetCount + ++tempCount];
            }
        }
        return avail;
    }

    private void readOggPageHeader() throws IOException {
        int read;
        int size;
        int avail;
        int packets = 0;
        if (this.precount - this.prepos < 27 && (avail = this.in.available()) > 0) {
            size = Math.min(this.prebuf.length - this.precount, avail);
            read = this.in.read(this.prebuf, this.precount, size);
            if (read < 0) {
                throw new IOException("End of stream but available was positive");
            }
            this.precount += read;
        }
        if (this.precount - this.prepos >= 27) {
            if (!new String(this.prebuf, this.prepos, 4).equals("OggS")) {
                throw new StreamCorruptedException("Lost Ogg Sync");
            }
            if (this.streamSerialNumber != Speex2PcmAudioInputStream.readInt(this.prebuf, this.prepos + 14)) {
                throw new StreamCorruptedException("Ogg Stream Serial Number mismatch");
            }
            packets = 0xFF & this.prebuf[this.prepos + 26];
        }
        if (this.precount - this.prepos < 27 + packets && (avail = this.in.available()) > 0) {
            size = Math.min(this.prebuf.length - this.precount, avail);
            read = this.in.read(this.prebuf, this.precount, size);
            if (read < 0) {
                throw new IOException("End of stream but available was positive");
            }
            this.precount += read;
        }
        if (this.precount - this.prepos >= 27 + packets) {
            System.arraycopy(this.prebuf, this.prepos + 27, this.packetSizes, 0, packets);
            this.packetCount = 0;
            this.prepos += 27 + packets;
            this.packetsPerOggPage = packets;
        }
    }

    private static int readInt(byte[] data, int offset) {
        return data[offset] & 0xFF | (data[offset + 1] & 0xFF) << 8 | (data[offset + 2] & 0xFF) << 16 | data[offset + 3] << 24;
    }
}

