/*
 * Decompiled with CFR 0.152.
 */
package org.xiph.speex;

import org.xiph.speex.Bits;
import org.xiph.speex.CbSearch;
import org.xiph.speex.Filters;
import org.xiph.speex.VQ;

public class SplitShapeSearch
extends CbSearch {
    public static final int MAX_COMPLEXITY = 10;
    private int subvect_size;
    private int nb_subvect;
    private int[] shape_cb;
    private int shape_cb_size;
    private int shape_bits;
    private int have_sign;
    private int[] ind;
    private int[] signs;
    private float[] t;
    private float[] e;
    private float[] E;
    private float[] r2;
    private float[][] ot;
    private float[][] nt;
    private int[][] nind;
    private int[][] oind;

    public SplitShapeSearch(int subframesize, int subvect_size, int nb_subvect, int[] shape_cb, int shape_bits, int have_sign) {
        this.subvect_size = subvect_size;
        this.nb_subvect = nb_subvect;
        this.shape_cb = shape_cb;
        this.shape_bits = shape_bits;
        this.have_sign = have_sign;
        this.ind = new int[nb_subvect];
        this.signs = new int[nb_subvect];
        this.shape_cb_size = 1 << shape_bits;
        this.ot = new float[10][subframesize];
        this.nt = new float[10][subframesize];
        this.oind = new int[10][nb_subvect];
        this.nind = new int[10][nb_subvect];
        this.t = new float[subframesize];
        this.e = new float[subframesize];
        this.r2 = new float[subframesize];
        this.E = new float[this.shape_cb_size];
    }

    public final void quant(float[] target, float[] ak, float[] awk1, float[] awk2, int p, int nsf, float[] exc, int es, float[] r, Bits bits, int complexity) {
        int k;
        int j;
        int N = complexity;
        if (N > 10) {
            N = 10;
        }
        float[] resp = new float[this.shape_cb_size * this.subvect_size];
        int[] best_index = new int[N];
        float[] best_dist = new float[N];
        float[] ndist = new float[N];
        float[] odist = new float[N];
        int i = 0;
        while (i < N) {
            j = 0;
            while (j < this.nb_subvect) {
                this.oind[i][j] = -1;
                this.nind[i][j] = -1;
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < N) {
            i = 0;
            while (i < nsf) {
                this.ot[j][i] = target[i];
                ++i;
            }
            ++j;
        }
        i = 0;
        while (i < this.shape_cb_size) {
            int res = i * this.subvect_size;
            int shape = i * this.subvect_size;
            j = 0;
            while (j < this.subvect_size) {
                resp[res + j] = 0.0f;
                k = 0;
                while (k <= j) {
                    int n = res + j;
                    resp[n] = (float)((double)resp[n] + 0.03125 * (double)this.shape_cb[shape + k] * (double)r[j - k]);
                    ++k;
                }
                ++j;
            }
            this.E[i] = 0.0f;
            j = 0;
            while (j < this.subvect_size) {
                int n = i;
                this.E[n] = this.E[n] + resp[res + j] * resp[res + j];
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < N) {
            odist[j] = 0.0f;
            ++j;
        }
        i = 0;
        while (i < this.nb_subvect) {
            int m;
            int offset = i * this.subvect_size;
            j = 0;
            while (j < N) {
                ndist[j] = -1.0f;
                ++j;
            }
            j = 0;
            while (j < N) {
                if (this.have_sign != 0) {
                    VQ.nbest_sign(this.ot[j], offset, resp, this.subvect_size, this.shape_cb_size, this.E, N, best_index, best_dist);
                } else {
                    VQ.nbest(this.ot[j], offset, resp, this.subvect_size, this.shape_cb_size, this.E, N, best_index, best_dist);
                }
                k = 0;
                while (k < N) {
                    float err = 0.0f;
                    float[] ct = this.ot[j];
                    m = offset;
                    while (m < offset + this.subvect_size) {
                        this.t[m] = ct[m];
                        ++m;
                    }
                    float sign = 1.0f;
                    int rind = best_index[k];
                    if (rind >= this.shape_cb_size) {
                        sign = -1.0f;
                        rind -= this.shape_cb_size;
                    }
                    int res = rind * this.subvect_size;
                    if (sign > 0.0f) {
                        m = 0;
                        while (m < this.subvect_size) {
                            int n = offset + m;
                            this.t[n] = this.t[n] - resp[res + m];
                            ++m;
                        }
                    } else {
                        m = 0;
                        while (m < this.subvect_size) {
                            int n = offset + m;
                            this.t[n] = this.t[n] + resp[res + m];
                            ++m;
                        }
                    }
                    err = odist[j];
                    m = offset;
                    while (m < offset + this.subvect_size) {
                        err += this.t[m] * this.t[m];
                        ++m;
                    }
                    if (err < ndist[N - 1] || (double)ndist[N - 1] < -0.5) {
                        int n;
                        int q;
                        m = offset + this.subvect_size;
                        while (m < nsf) {
                            this.t[m] = ct[m];
                            ++m;
                        }
                        m = 0;
                        while (m < this.subvect_size) {
                            sign = 1.0f;
                            int rind2 = best_index[k];
                            if (rind2 >= this.shape_cb_size) {
                                sign = -1.0f;
                                rind2 -= this.shape_cb_size;
                            }
                            float g = sign * 0.03125f * (float)this.shape_cb[rind2 * this.subvect_size + m];
                            q = this.subvect_size - m;
                            n = offset + this.subvect_size;
                            while (n < nsf) {
                                int n2 = n++;
                                this.t[n2] = this.t[n2] - g * r[q];
                                ++q;
                            }
                            ++m;
                        }
                        m = 0;
                        while (m < N) {
                            if (err < ndist[m] || (double)ndist[m] < -0.5) {
                                n = N - 1;
                                while (n > m) {
                                    q = offset + this.subvect_size;
                                    while (q < nsf) {
                                        this.nt[n][q] = this.nt[n - 1][q];
                                        ++q;
                                    }
                                    q = 0;
                                    while (q < this.nb_subvect) {
                                        this.nind[n][q] = this.nind[n - 1][q];
                                        ++q;
                                    }
                                    ndist[n] = ndist[n - 1];
                                    --n;
                                }
                                q = offset + this.subvect_size;
                                while (q < nsf) {
                                    this.nt[m][q] = this.t[q];
                                    ++q;
                                }
                                q = 0;
                                while (q < this.nb_subvect) {
                                    this.nind[m][q] = this.oind[j][q];
                                    ++q;
                                }
                                this.nind[m][i] = best_index[k];
                                ndist[m] = err;
                                break;
                            }
                            ++m;
                        }
                    }
                    ++k;
                }
                if (i == 0) break;
                ++j;
            }
            float[][] tmp2 = this.ot;
            this.ot = this.nt;
            this.nt = tmp2;
            j = 0;
            while (j < N) {
                m = 0;
                while (m < this.nb_subvect) {
                    this.oind[j][m] = this.nind[j][m];
                    ++m;
                }
                ++j;
            }
            j = 0;
            while (j < N) {
                odist[j] = ndist[j];
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < this.nb_subvect) {
            this.ind[i] = this.nind[0][i];
            bits.pack(this.ind[i], this.shape_bits + this.have_sign);
            ++i;
        }
        i = 0;
        while (i < this.nb_subvect) {
            float sign = 1.0f;
            int rind = this.ind[i];
            if (rind >= this.shape_cb_size) {
                sign = -1.0f;
                rind -= this.shape_cb_size;
            }
            j = 0;
            while (j < this.subvect_size) {
                this.e[this.subvect_size * i + j] = sign * 0.03125f * (float)this.shape_cb[rind * this.subvect_size + j];
                ++j;
            }
            ++i;
        }
        j = 0;
        while (j < nsf) {
            int n = es + j;
            exc[n] = exc[n] + this.e[j];
            ++j;
        }
        Filters.syn_percep_zero(this.e, 0, ak, awk1, awk2, this.r2, nsf, p);
        j = 0;
        while (j < nsf) {
            int n = j;
            target[n] = target[n] - this.r2[j];
            ++j;
        }
    }

    public final void unquant(float[] exc, int es, int nsf, Bits bits) {
        int i = 0;
        while (i < this.nb_subvect) {
            this.signs[i] = this.have_sign != 0 ? bits.unpack(1) : 0;
            this.ind[i] = bits.unpack(this.shape_bits);
            ++i;
        }
        i = 0;
        while (i < this.nb_subvect) {
            float s = 1.0f;
            if (this.signs[i] != 0) {
                s = -1.0f;
            }
            int j = 0;
            while (j < this.subvect_size) {
                int n = es + this.subvect_size * i + j;
                exc[n] = exc[n] + s * 0.03125f * (float)this.shape_cb[this.ind[i] * this.subvect_size + j];
                ++j;
            }
            ++i;
        }
    }
}

