/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hypertalk.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.net.URL;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.UIDefaults;
import javax.swing.UIManager;

public class DPIUtil {
    private static float scale = Float.parseFloat(System.getProperty("sun.java2d.uiScale", "1"));

    public static void setNewScale(float scale) {
        DPIUtil.scale = scale;
    }

    public static Font getScaledFont(Font font) {
        return font.deriveFont(font.getStyle(), (int)((float)font.getSize() * scale));
    }

    public static Component setFontScale(Component c) {
        c.setFont(DPIUtil.getScaledFont(c.getFont()));
        return c;
    }

    public static void setDefaultUIFontsToScale() {
        UIDefaults def = UIManager.getLookAndFeelDefaults();
        Enumeration keys = def.keys();
        while (keys.hasMoreElements()) {
            Object fontObject;
            Object keyObject = keys.nextElement();
            if (!(keyObject instanceof String) || !((String)keyObject).endsWith(".font") || !((fontObject = def.get(keyObject)) instanceof Font)) continue;
            def.put(keyObject, DPIUtil.getScaledFont((Font)fontObject));
        }
    }

    public static void scaleComponentTree(Component parent) {
        if (parent instanceof Container) {
            Component[] componentArray = ((Container)parent).getComponents();
            int n = componentArray.length;
            int n2 = 0;
            while (n2 < n) {
                Component c = componentArray[n2];
                DPIUtil.scaleComponentTree(c);
                ++n2;
            }
        }
        DPIUtil.scaleComponent(parent);
    }

    public static ImageIcon getScaledIcon(ImageIcon icon, int scaleType) {
        return icon == null ? null : new ImageIcon(icon.getImage().getScaledInstance(DPIUtil.getScaledInt(icon.getIconWidth()), DPIUtil.getScaledInt(icon.getIconHeight()), scaleType));
    }

    public static ImageIcon getScaledIcon(ImageIcon icon) {
        return DPIUtil.getScaledIcon(icon, 4);
    }

    public static ImageIcon loadScaledIcon(URL url) {
        return DPIUtil.loadScaledIcon(url, 4);
    }

    public static ImageIcon loadScaledIcon(URL url, int w, int h) {
        return DPIUtil.loadScaledIcon(url, w, h, 4);
    }

    public static ImageIcon loadScaledIcon(URL url, int scaleType) {
        return DPIUtil.getScaledIcon(new ImageIcon(url), scaleType);
    }

    public static ImageIcon loadScaledIcon(URL url, int w, int h, int scaleType) {
        Image image = new ImageIcon(url).getImage().getScaledInstance(DPIUtil.getScaledInt(w), DPIUtil.getScaledInt(h), scaleType);
        return DPIUtil.getScaledIcon(new ImageIcon(image), scaleType);
    }

    public static float getScale() {
        return scale;
    }

    public static int getScaledInt(int toScale) {
        return (int)((float)toScale * scale);
    }

    public static void scaleComponent(Component component) {
        component.setSize(new Dimension(DPIUtil.getScaledInt(component.getWidth()), DPIUtil.getScaledInt(component.getHeight())));
        if (component.getParent() != null) {
            component.setLocation(DPIUtil.getScaledInt(component.getX()), DPIUtil.getScaledInt(component.getY()));
        }
    }

    public static Dimension getScaledDimension(Dimension dimension) {
        return DPIUtil.getScaledDimension(dimension.width, dimension.height);
    }

    public static Dimension getScaledDimension(int width, int height) {
        return new Dimension((int)Math.max(-1.0f, (float)width * scale), (int)Math.max(-1.0f, (float)height * scale));
    }

    public static ImageIcon sIcon(ImageIcon icon, int scaleType) {
        return DPIUtil.getScaledIcon(icon, scaleType);
    }

    public static ImageIcon sIcon(ImageIcon icon) {
        return DPIUtil.getScaledIcon(icon);
    }

    public static ImageIcon lIcon(URL url) {
        return DPIUtil.loadScaledIcon(url);
    }

    public static ImageIcon lIcon(URL url, int w, int h) {
        return DPIUtil.loadScaledIcon(url, w, h);
    }

    public static ImageIcon lIcon(URL url, int scaleType) {
        return DPIUtil.loadScaledIcon(url, scaleType);
    }

    public static ImageIcon lIcon(URL url, int w, int h, int scaleType) {
        return DPIUtil.loadScaledIcon(url, w, h, scaleType);
    }

    public static Dimension sDim(int width, int height) {
        return DPIUtil.getScaledDimension(width, height);
    }

    public static Dimension sDim(Dimension dimension) {
        return DPIUtil.getScaledDimension(dimension);
    }

    public static int sInt(int toScale) {
        return DPIUtil.getScaledInt(toScale);
    }

    public static void sComp(Component component) {
        DPIUtil.scaleComponent(component);
    }

    public static Font sFont(Font font) {
        return DPIUtil.getScaledFont(font);
    }
}

