/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.hypertalk;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;
import javax.swing.JOptionPane;

public class DiscoveryServer
implements Runnable {
    private Thread parentThread;
    public boolean online = false;
    String identifier;

    public DiscoveryServer(String identifier) {
        this.identifier = identifier.trim().toLowerCase();
    }

    private static InetAddress getClosestLocal(InetAddress remote) throws Exception {
        Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
        int matchCount = 0;
        InetAddress bestLocal = null;
        while (ifaces.hasMoreElements()) {
            NetworkInterface iface = ifaces.nextElement();
            Enumeration<InetAddress> addrs = iface.getInetAddresses();
            while (addrs.hasMoreElements()) {
                byte[] l;
                InetAddress local = addrs.nextElement();
                if (local.isLoopbackAddress() || !(local instanceof Inet4Address)) continue;
                byte[] r = remote.getAddress();
                if (r[0] == (l = local.getAddress())[0] && r[1] == l[1] && r[2] == l[2]) {
                    return local;
                }
                if (r[0] == l[0] && r[1] == l[1] && matchCount < 2) {
                    matchCount = 2;
                    bestLocal = local;
                    continue;
                }
                if (r[0] != l[0] || matchCount >= 1) continue;
                matchCount = 1;
                bestLocal = local;
            }
        }
        return bestLocal != null ? bestLocal : InetAddress.getLocalHost();
    }

    public void updateIdentifier(String identifier) {
        this.identifier = identifier.trim().toLowerCase();
    }

    public void startDiscovery() {
        if (!this.online && this.parentThread == null) {
            this.parentThread = new Thread(this);
            this.parentThread.start();
        }
    }

    public void stopDiscovery() {
        this.online = false;
        if (this.parentThread != null) {
            this.parentThread.interrupt();
        }
    }

    public void run() {
        try {
            int listenPort = 4446;
            DatagramSocket socket = new DatagramSocket(listenPort, InetAddress.getByName("0.0.0.0"));
            byte[] buf = new byte[256];
            System.out.println("Discovery server listening on UDP port " + listenPort);
            long lastReply = 0L;
            long minDelay = 500L;
            while (true) {
                Thread.sleep((long)(Math.random() * 500.0));
                DatagramPacket packet = new DatagramPacket(buf, buf.length);
                socket.receive(packet);
                if (System.currentTimeMillis() - lastReply <= minDelay) continue;
                String received = new String(packet.getData(), 0, packet.getLength());
                System.out.println("getting " + received);
                if (!received.startsWith("DISCOVER_REQUEST") || !received.endsWith("*") && !received.trim().toLowerCase().endsWith(this.identifier)) continue;
                lastReply = System.currentTimeMillis();
                String response = "DISCOVER_RESPONSE:" + DiscoveryServer.getClosestLocal(packet.getAddress()).getHostAddress();
                byte[] respData = response.getBytes();
                DatagramPacket respPacket = new DatagramPacket(respData, respData.length, packet.getAddress(), packet.getPort());
                socket.send(respPacket);
                System.out.println("Replied to discovery from " + packet.getAddress());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(null, "Failed to start discovery service, exiting!", "Error", 0);
            System.exit(1);
            this.parentThread = null;
            this.online = false;
            return;
        }
    }
}

