/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.games.brickblaster.util;

import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.filechooser.FileFilter;

public class FileExtentionFilter
extends FileFilter {
    private final HashSet<String> extentions = new HashSet();
    private final String desc;

    public FileExtentionFilter(String desc, String ... extentions) {
        this.extentions.addAll(Arrays.asList(extentions));
        StringBuilder sb = new StringBuilder();
        sb.append(desc);
        sb.append(" (");
        int i = 0;
        while (i < extentions.length) {
            sb.append("*.");
            sb.append(extentions[i]);
            if (extentions.length > i + 1) {
                sb.append(" | ");
            }
            ++i;
        }
        sb.append(")");
        this.desc = sb.toString();
    }

    public boolean accept(File arg0) {
        if (arg0.isDirectory()) {
            return true;
        }
        int idx = arg0.getName().lastIndexOf(".") + 1;
        if (idx == 0 || idx == arg0.getName().length()) {
            return false;
        }
        return this.extentions.contains(arg0.getName().substring(idx).toLowerCase());
    }

    public String getDescription() {
        return this.desc;
    }
}

