/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.games.brickblaster.level;

import java.io.IOException;
import java.io.InputStream;

public abstract class LevelLoader {
    public abstract int loadLevel(byte[] var1);

    public abstract boolean incrementLevelCounter();

    public abstract void reset();

    protected final void loadStandardLevelFromStream(InputStream stream, byte[] destination) throws IOException {
        this.loadStandardLevelFromStream(stream, destination, 0);
    }

    protected final void loadStandardLevelFromStream(InputStream stream, byte[] destination, int offset) throws IOException {
        if (offset > 0) {
            stream.skip(offset * (destination.length >> 1));
        }
        int i = 0;
        while (i < destination.length) {
            int read = stream.read();
            if (read != -1) {
                destination[i] = (byte)(read & 0xF);
                destination[i + 1] = (byte)((read & 0xF0) >> 4);
            }
            i += 2;
        }
    }

    protected final int calculateHitables(byte[] field) {
        int toHit = 0;
        int i = 0;
        while (i < field.length) {
            if (field[i] != 0 && field[i] != 7) {
                ++toHit;
            }
            ++i;
        }
        return toHit;
    }
}

