/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.games.brickblaster;

import com.vulpovile.games.brickblaster.beep.BeepSoundSystem;
import com.vulpovile.games.brickblaster.game.Ball;
import com.vulpovile.games.brickblaster.game.powerups.PowerUp;
import com.vulpovile.games.brickblaster.game.powerups.PowerUpProvider;
import com.vulpovile.games.brickblaster.level.InternalLevelLoader;
import com.vulpovile.games.brickblaster.level.LevelLoader;
import java.awt.AWTException;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.MouseInfo;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.image.VolatileImage;
import java.util.ArrayList;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GamePanel
extends JPanel
implements MouseListener,
MouseMotionListener,
MouseWheelListener,
KeyListener {
    private static final long serialVersionUID = 1L;
    public static final short W = 320;
    public static final short H = 240;
    public static final short PADDLE_DEFAULT_HALF_WIDTH = 20;
    private final BeepSoundSystem sound;
    public static int ticks = 0;
    private VolatileImage frameBuffer = null;
    private short resetTicks = (short)-1;
    private short paddle = 0;
    private short paddleHalfWidth = (short)20;
    private byte[] field = new byte[128];
    private Color[] colors = new Color[]{Color.BLUE, Color.GREEN, Color.CYAN, Color.RED, Color.MAGENTA, Color.YELLOW, Color.DARK_GRAY};
    private ArrayList<Ball> balls = new ArrayList(8);
    private int toHit = -1;
    private int ballsLeft = 5;
    private boolean hookMouse = false;
    private Robot robot = null;
    private Rectangle repaintRegion = null;
    private ArrayList<PowerUp> fallingPowerUps = new ArrayList();
    private ArrayList<PowerUp> obtainedPowerUps = new ArrayList();
    private boolean flip = false;
    private LevelLoader levelLoader = new InternalLevelLoader();

    public GamePanel(BeepSoundSystem sound) {
        this.addMouseMotionListener(this);
        this.addMouseWheelListener(this);
        this.addKeyListener(this);
        this.addMouseListener(this);
        this.sound = sound;
        this.setFocusable(true);
        this.requestFocus();
        this.requestFocusInWindow();
        this.setBackground(Color.BLACK);
        try {
            this.robot = new Robot();
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    public Graphics2D revalidateFramebuffer() {
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        if (this.frameBuffer == null || this.frameBuffer.validate(gc) == 2 || this.frameBuffer.getWidth() != 320 || this.frameBuffer.getHeight() != 240) {
            this.frameBuffer = gc.createCompatibleVolatileImage(320, 240);
        }
        return (Graphics2D)this.frameBuffer.getGraphics();
    }

    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = this.revalidateFramebuffer();
        super.paintComponent(g);
        g2d.setColor(Color.BLACK);
        g2d.fillRect(0, 0, 320, 240);
        int w = 40;
        int h = 11;
        int gapw = 2;
        int gaph = 2;
        if (this.flip) {
            g2d.scale(1.0, -1.0);
            g2d.translate(0, -240);
        }
        int i = 0;
        while (i < 8) {
            int j = 0;
            while (j < 16) {
                byte block = this.field[j * 8 + i];
                if (block > 0) {
                    g2d.setColor(this.colors[block - 1]);
                    g2d.fillRect(i * w + gapw, j * h + gaph, w - gapw, h - gaph);
                    g2d.setColor(this.colors[block - 1].darker());
                    g2d.fillRect(i * w + gapw + gapw, j * h + gaph + gaph, w - gapw * 2, h - gaph * 2);
                }
                ++j;
            }
            ++i;
        }
        g2d.setColor(Color.BLACK);
        g2d.fillRect(318, 0, 2, 240);
        i = 0;
        while (i < this.fallingPowerUps.size()) {
            PowerUp powerUp = this.fallingPowerUps.get(i);
            gapw = powerUp.pupHalfWidth >> 2;
            gaph = powerUp.pupHalfHeight >> 1;
            g2d.setColor(powerUp.color);
            g2d.fillRect(powerUp.x - powerUp.pupHalfWidth, powerUp.y - powerUp.pupHalfHeight, powerUp.pupHalfWidth << 1, powerUp.pupHalfHeight << 1);
            g2d.setColor(powerUp.color.darker());
            g2d.fillRect(powerUp.x - powerUp.pupHalfWidth + gapw, powerUp.y - powerUp.pupHalfHeight + gaph, (powerUp.pupHalfWidth << 1) - gapw, (powerUp.pupHalfHeight << 1) - gaph);
            int linePos = ticks % (powerUp.pupHalfWidth << 1);
            if (linePos << 1 < powerUp.pupHalfWidth << 1) {
                g2d.setColor(Color.WHITE);
                if (powerUp.nerf) {
                    g2d.fillRect(powerUp.x + powerUp.pupHalfWidth - (linePos << 1) - gapw, powerUp.y - powerUp.pupHalfHeight, gaph, powerUp.pupHalfHeight << 1);
                } else {
                    g2d.fillRect(powerUp.x - powerUp.pupHalfWidth + (linePos << 1), powerUp.y - powerUp.pupHalfHeight, gaph, powerUp.pupHalfHeight << 1);
                }
            }
            ++i;
        }
        g2d.setColor(Color.GRAY);
        g2d.fillRect(this.paddle - this.paddleHalfWidth, 225, this.paddleHalfWidth << 1, 7);
        g2d.setColor(Color.WHITE.darker());
        g2d.fillRect(this.paddle - this.paddleHalfWidth, 225, this.paddleHalfWidth << 1, 3);
        g2d.setColor(Color.WHITE);
        g2d.fillRect(this.paddle - this.paddleHalfWidth, 225, this.paddleHalfWidth << 1, 1);
        i = 0;
        while (i < this.balls.size()) {
            Ball b = this.balls.get(i);
            g2d.setColor(b.superBall ? Color.MAGENTA : Color.WHITE);
            if (b.ballY == -17903) {
                g2d.fillRect(this.paddle - b.ballWidthHalf + b.ballX, 225 - (b.ballHeightHalf << 1) - 3, b.ballWidthHalf << 1, b.ballHeightHalf << 1);
            } else {
                g2d.fillRect(b.ballX - b.ballWidthHalf, b.ballY - b.ballHeightHalf, b.ballWidthHalf << 1, b.ballHeightHalf << 1);
            }
            ++i;
        }
        g2d.setColor(Color.WHITE);
        i = 0;
        while (i < this.ballsLeft - 1) {
            g2d.fillRect(i * 10, 237, 5, 7);
            ++i;
        }
        g2d.dispose();
        g.drawImage(this.frameBuffer, 0, 0, this.getWidth(), this.getHeight(), this);
    }

    public void addRepaintRegion(Rectangle rect) {
        if (this.flip) {
            rect.y = 240 - rect.y - rect.height;
        }
        if (this.repaintRegion == null) {
            this.repaintRegion = rect;
        } else {
            this.repaintRegion.add(rect);
        }
    }

    public void tick() {
        ++ticks;
        if (this.toHit > 0 && this.resetTicks <= -1 && this.ballsLeft > 0) {
            PowerUp powerUp;
            int i = this.fallingPowerUps.size() - 1;
            while (i >= 0) {
                powerUp = this.fallingPowerUps.get(i);
                this.addRepaintRegion(new Rectangle(powerUp.x - powerUp.pupHalfWidth, powerUp.y - powerUp.pupHalfHeight, powerUp.pupHalfWidth << 1, powerUp.pupHalfHeight << 1));
                ++powerUp.y;
                if (powerUp.y > 240) {
                    this.fallingPowerUps.remove(i);
                } else if (powerUp.y + powerUp.pupHalfHeight > 225 && powerUp.y - powerUp.pupHalfHeight < 232 && powerUp.x > this.paddle - this.paddleHalfWidth - powerUp.pupHalfWidth && powerUp.x < this.paddle + this.paddleHalfWidth + powerUp.pupHalfWidth) {
                    this.sound.note(1200, 15, 0.5, 2);
                    this.sound.note(1600, 15, 0.5, 2);
                    powerUp.onObtain(this);
                    this.fallingPowerUps.remove(i);
                } else {
                    this.addRepaintRegion(new Rectangle(powerUp.x - powerUp.pupHalfWidth, powerUp.y - powerUp.pupHalfHeight, powerUp.pupHalfWidth << 1, powerUp.pupHalfHeight << 1));
                }
                --i;
            }
            i = this.obtainedPowerUps.size() - 1;
            while (i >= 0) {
                powerUp = this.obtainedPowerUps.get(i);
                if (powerUp.expiresIn != -13570) {
                    powerUp.expiresIn = (short)(powerUp.expiresIn - 1);
                    if (powerUp.expiresIn <= 0) {
                        this.obtainedPowerUps.remove(i);
                        powerUp.onExpire(this);
                    }
                }
                powerUp.tick(this);
                --i;
            }
            i = 0;
            while (i < this.balls.size()) {
                block53: {
                    Ball ball = this.balls.get(i);
                    if (ball.ballY != -17903 && ball.ballX != -17903) {
                        PowerUp powerUp2;
                        byte val;
                        int index2;
                        int index1;
                        int h;
                        int w;
                        this.addRepaintRegion(new Rectangle(ball.ballX - ball.ballWidthHalf, ball.ballY - ball.ballHeightHalf, ball.ballWidthHalf << 1, ball.ballHeightHalf << 1));
                        int y = 0;
                        while (y < Math.abs(ball.ballYVelocity)) {
                            ball.ballY = (int)((float)ball.ballY + Math.signum(ball.ballYVelocity));
                            if (ball.ballYVelocity > 0 && ball.ballY + ball.ballHeightHalf > 225 && ball.ballY - ball.ballHeightHalf < 232 && ball.ballX > this.paddle - this.paddleHalfWidth - ball.ballWidthHalf && ball.ballX < this.paddle + this.paddleHalfWidth + ball.ballWidthHalf) {
                                ball.ballYVelocity = -6;
                                ball.ballXVelocity = (ball.ballX - this.paddle) * 6 / this.paddleHalfWidth;
                                this.sound.note(1000, 50, 0.5, 0);
                            } else {
                                if (ball.ballY - ball.ballHeightHalf > 240) {
                                    ball.ballX = -17903;
                                    break block53;
                                }
                                if (ball.ballY < ball.ballHeightHalf && ball.ballYVelocity < 0) {
                                    ball.ballYVelocity = -ball.ballYVelocity;
                                    this.sound.note(200, 25, 0.5, 0);
                                    this.sound.note(100, 25, 0.5, 0);
                                } else if (ball.ballY < 180) {
                                    w = 40;
                                    h = 11;
                                    int xIdx1 = (ball.ballX + ball.ballWidthHalf) / w;
                                    int xIdx2 = (ball.ballX - ball.ballWidthHalf) / w;
                                    int yIdx = ball.ballYVelocity > 0 ? (ball.ballY + ball.ballHeightHalf) / h : (ball.ballY - ball.ballHeightHalf) / h;
                                    index1 = yIdx * 8 + xIdx1;
                                    index2 = yIdx * 8 + xIdx2;
                                    if (xIdx1 < 8 && yIdx >= 0 && yIdx < 16 && this.field[index1] > 0) {
                                        ball.ballY = (int)((float)ball.ballY - Math.signum(ball.ballYVelocity));
                                        val = this.field[index1];
                                        if (val != 7) {
                                            --this.toHit;
                                            this.addRepaintRegion(new Rectangle(xIdx1 * w, yIdx * h, w, h));
                                            powerUp2 = PowerUpProvider.providePowerUp(ball.ballX, ball.ballY, this.field[index1]);
                                            if (powerUp2 != null) {
                                                this.addRepaintRegion(new Rectangle(powerUp2.x - powerUp2.pupHalfWidth, powerUp2.y - powerUp2.pupHalfHeight, powerUp2.pupHalfWidth << 1, powerUp2.pupHalfHeight << 1));
                                                this.fallingPowerUps.add(powerUp2);
                                            }
                                            this.field[index1] = 0;
                                        }
                                        if (!ball.superBall || val == 7) {
                                            ball.ballYVelocity = -ball.ballYVelocity;
                                        }
                                        this.sound.note(100 * val, 25, 0.25, 0);
                                        this.sound.note(100 * (val + 2), 25, 0.25, 1);
                                    } else if (xIdx2 >= 0 && yIdx >= 0 && yIdx < 16 && this.field[index2] > 0) {
                                        ball.ballY = (int)((float)ball.ballY - Math.signum(ball.ballYVelocity));
                                        val = this.field[index2];
                                        if (val != 7) {
                                            --this.toHit;
                                            this.addRepaintRegion(new Rectangle(xIdx2 * w, yIdx * h, w, h));
                                            powerUp2 = PowerUpProvider.providePowerUp(ball.ballX, ball.ballY, this.field[index2]);
                                            if (powerUp2 != null) {
                                                this.addRepaintRegion(new Rectangle(powerUp2.x - powerUp2.pupHalfWidth, powerUp2.y - powerUp2.pupHalfHeight, powerUp2.pupHalfWidth << 1, powerUp2.pupHalfHeight << 1));
                                                this.fallingPowerUps.add(powerUp2);
                                            }
                                            this.field[index2] = 0;
                                        }
                                        if (!ball.superBall || val == 7) {
                                            ball.ballYVelocity = -ball.ballYVelocity;
                                        }
                                        this.sound.note(100 * val, 25, 0.25, 0);
                                        this.sound.note(100 * (val + 2), 25, 0.25, 1);
                                    }
                                }
                            }
                            ++y;
                        }
                        int x = 0;
                        while (x < Math.abs(ball.ballXVelocity)) {
                            if (ball.ballX != -17903) {
                                ball.ballX = (int)((float)ball.ballX + Math.signum(ball.ballXVelocity));
                                if (ball.ballX < ball.ballWidthHalf && ball.ballXVelocity < 0 || ball.ballX > 320 - ball.ballWidthHalf && ball.ballXVelocity > 0) {
                                    ball.ballXVelocity = -ball.ballXVelocity;
                                    this.sound.note(200, 25, 0.25, 0);
                                    this.sound.note(100, 25, 0.25, 0);
                                } else if (ball.ballY < 180) {
                                    w = 40;
                                    h = 11;
                                    int yIdx1 = (ball.ballY + ball.ballHeightHalf) / h;
                                    int yIdx2 = (ball.ballY - ball.ballHeightHalf) / h;
                                    int xIdx = ball.ballXVelocity > 0 ? (ball.ballX + ball.ballWidthHalf) / w : (ball.ballX - ball.ballWidthHalf) / w;
                                    index1 = yIdx1 * 8 + xIdx;
                                    index2 = yIdx2 * 8 + xIdx;
                                    if (yIdx1 < 16 && xIdx >= 0 && xIdx < 8 && this.field[index1] > 0) {
                                        ball.ballX = (int)((float)ball.ballX - Math.signum(ball.ballXVelocity));
                                        val = this.field[index1];
                                        if (val != 7) {
                                            --this.toHit;
                                            this.addRepaintRegion(new Rectangle(xIdx * w, yIdx1 * h, w, h));
                                            powerUp2 = PowerUpProvider.providePowerUp(ball.ballX, ball.ballY, this.field[index1]);
                                            if (powerUp2 != null) {
                                                this.addRepaintRegion(new Rectangle(powerUp2.x - powerUp2.pupHalfWidth, powerUp2.y - powerUp2.pupHalfHeight, powerUp2.pupHalfWidth << 1, powerUp2.pupHalfHeight << 1));
                                                this.fallingPowerUps.add(powerUp2);
                                            }
                                            this.field[index1] = 0;
                                        }
                                        if (!ball.superBall || val == 7) {
                                            ball.ballXVelocity = -ball.ballXVelocity;
                                        }
                                        this.sound.note(100 * val, 25, 0.25, 0);
                                        this.sound.note(100 * (val + 2), 25, 0.25, 1);
                                    } else if (yIdx2 < 16 && xIdx >= 0 && xIdx < 8 && this.field[index2] > 0) {
                                        ball.ballX = (int)((float)ball.ballX - Math.signum(ball.ballXVelocity));
                                        val = this.field[index2];
                                        if (val != 7) {
                                            --this.toHit;
                                            this.addRepaintRegion(new Rectangle(xIdx * w, yIdx2 * h, w, h));
                                            powerUp2 = PowerUpProvider.providePowerUp(ball.ballX, ball.ballY, this.field[index2]);
                                            if (powerUp2 != null) {
                                                this.addRepaintRegion(new Rectangle(powerUp2.x - powerUp2.pupHalfWidth, powerUp2.y - powerUp2.pupHalfHeight, powerUp2.pupHalfWidth << 1, powerUp2.pupHalfHeight << 1));
                                                this.fallingPowerUps.add(powerUp2);
                                            }
                                            this.field[index2] = 0;
                                        }
                                        if (!ball.superBall || val == 7) {
                                            ball.ballXVelocity = -ball.ballXVelocity;
                                        }
                                        this.sound.note(100 * val, 25, 0.25, 0);
                                        this.sound.note(100 * (val + 2), 25, 0.25, 1);
                                    }
                                }
                                ++x;
                                continue;
                            }
                            break block53;
                        }
                        this.addRepaintRegion(new Rectangle(ball.ballX - ball.ballWidthHalf, ball.ballY - ball.ballHeightHalf, ball.ballWidthHalf << 1, ball.ballHeightHalf << 1));
                    }
                }
                ++i;
            }
            i = this.balls.size() - 1;
            while (i >= 0) {
                if (this.balls.get((int)i).ballX == -17903) {
                    this.balls.remove(i);
                }
                --i;
            }
            if (this.balls.size() <= 0) {
                this.resetTicks = (short)120;
                this.sound.note(251, 150, 0.25, 0);
                this.sound.note(458, 150, 0.25, 1);
                this.sound.note(251, 300, 0.25, 0);
                this.sound.note(120, 300, 0.25, 1);
                --this.ballsLeft;
                this.addRepaintRegion(new Rectangle(0, 0, 320, 240));
            }
        } else if (this.resetTicks == 0 && this.toHit == -1) {
            this.revertDefaults();
            this.levelLoader.incrementLevelCounter();
            this.toHit = this.levelLoader.loadLevel(this.field);
            this.addRepaintRegion(new Rectangle(0, 0, 320, 240));
        } else if (this.resetTicks == 0) {
            if (this.ballsLeft == 0) {
                this.revertDefaults();
                this.ballsLeft = 5;
                this.toHit = this.levelLoader.loadLevel(this.field);
            }
            this.balls.clear();
            this.balls.add(new Ball());
            this.addRepaintRegion(new Rectangle(0, 0, 320, 240));
            this.resetTicks = (short)(this.resetTicks - 1);
        } else if (this.resetTicks > 0) {
            this.resetTicks = (short)(this.resetTicks - 1);
        }
        if (this.toHit == 0) {
            this.resetTicks = (short)120;
            --this.toHit;
            this.sound.note(400, 100, 0.2, 0);
            this.sound.note(500, 100, 0.2, 1);
            this.sound.note(0, 20, 0.2, 0);
            this.sound.note(0, 20, 0.2, 1);
            this.sound.note(400, 50, 0.2, 0);
            this.sound.note(500, 50, 0.2, 1);
            this.sound.note(500, 300, 0.2, 0);
            this.sound.note(600, 300, 0.2, 1);
            this.sound.note(600, 300, 0.2, 0);
            this.sound.note(800, 300, 0.2, 1);
            this.sound.note(1000, 300, 0.2, 0);
            this.sound.note(800, 300, 0.2, 1);
            this.sound.note(1200, 300, 0.2, 0);
            this.sound.note(1000, 300, 0.2, 1);
        }
        if (this.repaintRegion != null) {
            this.repaintRegion.x = this.repaintRegion.x * this.getWidth() / 320;
            this.repaintRegion.y = this.repaintRegion.y * this.getHeight() / 240;
            this.repaintRegion.width = (this.repaintRegion.width + 1) * this.getWidth() / 320;
            this.repaintRegion.height = (this.repaintRegion.height + 1) * this.getHeight() / 240;
            this.repaint(this.repaintRegion);
            this.repaintRegion = null;
        }
    }

    public void revertDefaults() {
        this.flip = false;
        this.paddleHalfWidth = (short)20;
        this.fallingPowerUps.clear();
        this.obtainedPowerUps.clear();
    }

    public void doContinue() {
        this.revertDefaults();
        this.balls.clear();
        this.balls.add(new Ball());
        this.toHit = -1;
        this.ballsLeft = 5;
        this.resetTicks = (short)-1;
        this.toHit = this.levelLoader.loadLevel(this.field);
        this.addRepaintRegion(new Rectangle(0, 0, 320, 240));
    }

    public void reset() {
        this.revertDefaults();
        this.sound.note(200, 100, 0.3, 1);
        this.sound.note(300, 100, 0.2, 0);
        this.sound.note(400, 100, 0.2, 2);
        this.sound.note(600, 100, 0.3, 1);
        this.sound.note(800, 100, 0.2, 0);
        this.sound.note(0, 100, 0.2, 2);
        this.balls.clear();
        this.balls.add(new Ball());
        this.toHit = -1;
        this.ballsLeft = 5;
        this.levelLoader.reset();
        this.resetTicks = (short)-1;
        this.toHit = this.levelLoader.loadLevel(this.field);
        this.addRepaintRegion(new Rectangle(0, 0, 320, 240));
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        Ball b;
        this.addRepaintRegion(new Rectangle(this.paddle - this.paddleHalfWidth, 225, this.paddleHalfWidth << 1, 7));
        int i = 0;
        while (i < this.balls.size()) {
            b = this.balls.get(i);
            if (b.ballY == -17903) {
                this.addRepaintRegion(new Rectangle(this.paddle - b.ballWidthHalf + b.ballX, 225 - (b.ballHeightHalf << 1) - 3, b.ballWidthHalf << 1, b.ballHeightHalf << 1));
            }
            ++i;
        }
        this.paddle = (short)((float)e.getX() * (1.0f + (float)(this.paddleHalfWidth << 1) / 320.0f) * (320.0f / (float)this.getWidth()) - (float)this.paddleHalfWidth);
        this.addRepaintRegion(new Rectangle(this.paddle - this.paddleHalfWidth, 225, this.paddleHalfWidth << 1, 7));
        i = 0;
        while (i < this.balls.size()) {
            b = this.balls.get(i);
            if (b.ballY == -17903) {
                this.addRepaintRegion(new Rectangle(this.paddle - b.ballWidthHalf + b.ballX, 225 - (b.ballHeightHalf << 1) - 3, b.ballWidthHalf << 1, b.ballHeightHalf << 1));
            }
            ++i;
        }
        if (this.hookMouse && this.robot != null) {
            this.robot.mouseMove(MouseInfo.getPointerInfo().getLocation().x, this.getLocationOnScreen().y + (this.getHeight() >> 1));
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        this.mouseMoved(e);
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        int i = 0;
        while (i < this.balls.size()) {
            if (this.balls.get((int)i).ballY == -17903) {
                Ball b = this.balls.get(i);
                this.addRepaintRegion(new Rectangle(this.paddle - b.ballWidthHalf + b.ballX, 225 - (b.ballHeightHalf << 1) - 3, b.ballWidthHalf << 1, b.ballHeightHalf << 1));
                b.ballX = Math.min(Math.max(b.ballX + e.getUnitsToScroll(), -this.paddleHalfWidth), this.paddleHalfWidth);
                this.addRepaintRegion(new Rectangle(this.paddle - b.ballWidthHalf + b.ballX, 225 - (b.ballHeightHalf << 1) - 3, b.ballWidthHalf << 1, b.ballHeightHalf << 1));
            }
            ++i;
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 82: {
                this.reset();
                break;
            }
            case 67: {
                this.doContinue();
                break;
            }
            case 78: {
                this.resetTicks = 0;
                this.toHit = -1;
                break;
            }
            case 72: {
                this.hookMouse = !this.hookMouse;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent arg0) {
    }

    @Override
    public void mouseEntered(MouseEvent arg0) {
    }

    @Override
    public void mouseExited(MouseEvent arg0) {
    }

    @Override
    public void mousePressed(MouseEvent arg0) {
    }

    @Override
    public void mouseReleased(MouseEvent arg0) {
        int i = 0;
        while (i < this.balls.size()) {
            if (this.balls.get((int)i).ballY == -17903) {
                Ball ball = this.balls.get(i);
                ball.ballX = this.paddle + ball.ballX;
                ball.ballY = 225 - (ball.ballHeightHalf << 1) - 3;
                ball.ballXVelocity = 0;
                ball.ballYVelocity = 4;
                break;
            }
            ++i;
        }
    }

    public ArrayList<Ball> getBalls() {
        return this.balls;
    }

    public boolean hasPowerUp(PowerUp powerUp) {
        return this.obtainedPowerUps.contains(powerUp);
    }

    public PowerUp getLikePowerup(PowerUp powerUp) {
        int idx = this.obtainedPowerUps.indexOf(powerUp);
        if (idx > -1) {
            return this.obtainedPowerUps.get(idx);
        }
        return null;
    }

    public void obtainPowerUp(PowerUp powerUp) {
        this.obtainedPowerUps.add(powerUp);
    }

    public void setFlipped(boolean flipped) {
        this.addRepaintRegion(new Rectangle(0, 0, 320, 240));
        this.flip = flipped;
    }

    public void setPaddleHalfWidth(short width) {
        this.addRepaintRegion(new Rectangle(this.paddle - this.paddleHalfWidth, 225, this.paddleHalfWidth << 1, 7));
        this.paddleHalfWidth = width;
        this.addRepaintRegion(new Rectangle(this.paddle - this.paddleHalfWidth, 225, this.paddleHalfWidth << 1, 7));
    }

    public short getPaddleHalfWidth() {
        return this.paddleHalfWidth;
    }

    public int getBallsLeft() {
        return this.ballsLeft;
    }

    public void setBallsLeft(int ballsLeft) {
        this.ballsLeft = ballsLeft;
        this.addRepaintRegion(new Rectangle(0, 237, 320, 7));
    }

    public void setLevelLoader(LevelLoader levelLoader) {
        this.levelLoader = levelLoader;
        this.reset();
    }
}

