/*
 * Decompiled with CFR 0.152.
 */
package com.vulpovile.games.brickblaster;

import com.vulpovile.games.brickblaster.AboutDialog;
import com.vulpovile.games.brickblaster.GamePanel;
import com.vulpovile.games.brickblaster.GameTickThread;
import com.vulpovile.games.brickblaster.beep.BeepSoundSystem;
import com.vulpovile.games.brickblaster.level.CompilationLevelLoader;
import com.vulpovile.games.brickblaster.level.SingleLevelLoader;
import com.vulpovile.games.brickblaster.util.FileExtentionFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class GameBase
extends JPanel
implements ActionListener {
    public static final char ERA = 'a';
    public static final byte GENERATION = 0;
    public static final byte MAJOR_VERSION = 0;
    public static final byte MINOR_VERSION = 4;
    public static final byte PATCH_VERSION = 2;
    public static final String PRODUCT_NAME = "BrickBlaster";
    public GameTickThread gameTickThread;
    private final BeepSoundSystem sound = new BeepSoundSystem(3);
    private final GamePanel paddlePanel = new GamePanel(this.sound);
    private final JMenuItem mntmAbout = new JMenuItem("About");
    private final JMenuItem mntmOpen = new JMenuItem("Open");
    private File lastFile = null;
    private static final long serialVersionUID = 1L;

    public GameBase() {
        this.setLayout(new BorderLayout());
        this.add((Component)this.paddlePanel, "Center");
        JToolBar toolBar = new JToolBar();
        this.add((Component)toolBar, "North");
        JMenuBar menuBar = new JMenuBar();
        toolBar.add(menuBar);
        JMenu mnFile = new JMenu("File");
        menuBar.add(mnFile);
        mnFile.add(this.mntmOpen);
        this.mntmOpen.addActionListener(this);
        JMenu mnHelp = new JMenu("Help");
        menuBar.add(mnHelp);
        this.mntmAbout.addActionListener(this);
        mnHelp.add(this.mntmAbout);
        this.sound.note(200, 150, 0.2, 0);
        this.sound.note(300, 150, 0.2, 0);
        this.sound.note(400, 150, 0.2, 0);
        this.sound.note(500, 150, 0.2, 0);
        this.sound.note(500, 150, 0.2, 1);
        this.sound.note(600, 150, 0.2, 1);
        this.sound.note(700, 150, 0.2, 1);
        this.sound.note(800, 150, 0.2, 1);
    }

    public void begin() {
        this.gameTickThread = new GameTickThread(this.paddlePanel, 33333333L);
        new Thread(this.gameTickThread).start();
    }

    public void destroy() {
        this.sound.destroy();
        this.gameTickThread.end();
    }

    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.mntmAbout) {
            new AboutDialog(this).setVisible(true);
        } else if (arg0.getSource() == this.mntmOpen) {
            JFileChooser jFileChooser = new JFileChooser(this.lastFile);
            jFileChooser.setFileFilter(new FileExtentionFilter("All Accepted Filetypes", "bbl", "bcl"));
            jFileChooser.addChoosableFileFilter(new FileExtentionFilter("BrickBlaster Levels", "bbl"));
            jFileChooser.addChoosableFileFilter(new FileExtentionFilter("BrickBlaster Compilations", "bcl"));
            if (jFileChooser.showOpenDialog(this) == 0 && jFileChooser.getSelectedFile() != null) {
                File file = jFileChooser.getSelectedFile();
                if (file.getName().endsWith("bbl")) {
                    SingleLevelLoader sll = new SingleLevelLoader(file);
                    this.paddlePanel.setLevelLoader(sll);
                } else if (file.getName().endsWith("bcl")) {
                    CompilationLevelLoader cll = new CompilationLevelLoader(file);
                    this.paddlePanel.setLevelLoader(cll);
                }
            }
        }
    }
}

