/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.generatedfile;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.apt.core.internal.AptPlugin;
import org.eclipse.jdt.apt.core.internal.util.ManyToMany;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeneratedFileMap
extends ManyToMany<IFile, IFile> {
    private static final int SERIALIZATION_VERSION = 1;
    private final IProject _proj;

    public GeneratedFileMap(IProject proj) {
        this._proj = proj;
        this.readState();
    }

    public synchronized void clearState() {
        boolean successfullyDeleted;
        this.clear();
        File state = this.getStateFile(this._proj);
        if (state != null && !(successfullyDeleted = state.delete()) && state.exists()) {
            AptPlugin.log(new IOException("Could not delete apt dependency state file"), state.getPath());
        }
        this.clearDirtyBit();
    }

    private String convertIFileToPath(IFile file) {
        IPath path = file.getProjectRelativePath();
        return path.toOSString();
    }

    private IFile convertPathToIFile(String projectRelativeString) {
        Path path = new Path(projectRelativeString);
        return this._proj.getFile((IPath)path);
    }

    private File getStateFile(IProject project) {
        if (!project.exists()) {
            return null;
        }
        IPath workingLocation = project.getWorkingLocation("org.eclipse.jdt.apt.core");
        return workingLocation.append("state.dat").toFile();
    }

    private void readState() {
        block18: {
            File file = this.getStateFile(this._proj);
            if (file == null || !file.exists()) {
                return;
            }
            FilterInputStream in = null;
            try {
                try {
                    in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                    int version = ((DataInputStream)in).readInt();
                    if (version != 1) {
                        throw new IOException("Dependency map file version does not match. Expected 1, but found " + version);
                    }
                    int sizeOfMap = ((DataInputStream)in).readInt();
                    int parentIndex = 0;
                    while (parentIndex < sizeOfMap) {
                        String parentPath = ((DataInputStream)in).readUTF();
                        IFile parent = this.convertPathToIFile(parentPath);
                        int numChildren = ((DataInputStream)in).readInt();
                        int childIndex = 0;
                        while (childIndex < numChildren) {
                            String childPath = ((DataInputStream)in).readUTF();
                            IFile child = this.convertPathToIFile(childPath);
                            this.put(parent, child);
                            ++childIndex;
                        }
                        ++parentIndex;
                    }
                    this.clearDirtyBit();
                }
                catch (IOException ioe) {
                    AptPlugin.log(ioe, "Could not deserialize APT dependencies");
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public synchronized void writeState() {
        block18: {
            if (!this.isDirty()) {
                return;
            }
            File file = this.getStateFile(this._proj);
            if (file == null) {
                return;
            }
            file.delete();
            FilterOutputStream out = null;
            try {
                try {
                    out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
                    ((DataOutputStream)out).writeInt(1);
                    Set parents = this.getKeySet();
                    ((DataOutputStream)out).writeInt(parents.size());
                    for (IFile parent : parents) {
                        ((DataOutputStream)out).writeUTF(this.convertIFileToPath(parent));
                        Set children = this.getValues(parent);
                        ((DataOutputStream)out).writeInt(children.size());
                        for (IFile child : children) {
                            ((DataOutputStream)out).writeUTF(this.convertIFileToPath(child));
                        }
                    }
                    this.clearDirtyBit();
                    ((DataOutputStream)out).flush();
                }
                catch (IOException ioe) {
                    AptPlugin.log(ioe, "Could not serialize APT dependencies");
                    if (out != null) {
                        try {
                            out.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block18;
                }
            }
            catch (Throwable throwable) {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

