/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.text.bundle;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.internal.core.ibundle.IBundleModel;
import org.eclipse.pde.internal.core.text.bundle.CompositeManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PackageFriend;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;

public class ExportPackageObject
extends PackageObject {
    private static final String INTERNAL = "x-internal";
    private static final String FRIENDS = "x-friends";
    private static final long serialVersionUID = 1L;
    private TreeMap fFriends = new TreeMap();

    public ExportPackageObject(ManifestHeader header, ManifestElement element, String versionAttribute) {
        super(header, element, versionAttribute);
        this.processFriends();
    }

    public ExportPackageObject(ManifestHeader header, IPackageFragment fragment, String versionAttribute) {
        super(header, fragment.getElementName(), null, versionAttribute);
    }

    public ExportPackageObject(ManifestHeader header, String id, String version, String versionAttribute) {
        super(header, id, version, versionAttribute);
    }

    protected void processFriends() {
        String[] friends = this.getDirectives(FRIENDS);
        if (friends != null) {
            int i = 0;
            while (i < friends.length) {
                this.fFriends.put(friends[i], new PackageFriend(this, friends[i]));
                ++i;
            }
        }
    }

    public boolean isInternal() {
        return "true".equals(this.getDirective(INTERNAL)) || this.getDirective(FRIENDS) != null;
    }

    public void removeInternalDirective() {
        this.setDirective(INTERNAL, null);
        ((CompositeManifestHeader)this.fHeader).update(true);
    }

    public void setInternal(boolean internal) {
        boolean old = this.isInternal();
        if (!internal) {
            this.setDirective(INTERNAL, null);
            this.setDirective(FRIENDS, null);
        } else if (this.fFriends.size() == 0) {
            this.setDirective(INTERNAL, "true");
        } else {
            Iterator iter = this.fFriends.keySet().iterator();
            while (iter.hasNext()) {
                this.addDirective(FRIENDS, iter.next().toString());
            }
        }
        this.fHeader.update();
        this.firePropertyChanged(this, INTERNAL, Boolean.toString(old), Boolean.toString(internal));
    }

    public PackageFriend[] getFriends() {
        return this.fFriends.values().toArray(new PackageFriend[this.fFriends.size()]);
    }

    public void addFriend(PackageFriend friend) {
        this.fFriends.put(friend.getName(), friend);
        this.addDirective(FRIENDS, friend.getName());
        this.setDirective(INTERNAL, null);
        this.fHeader.update();
        this.fireStructureChanged(friend, 1);
    }

    public void removeFriend(PackageFriend friend) {
        this.fFriends.remove(friend.getName());
        this.setDirective(FRIENDS, null);
        if (this.fFriends.size() == 0) {
            this.setDirective(INTERNAL, "true");
        } else {
            Iterator iter = this.fFriends.keySet().iterator();
            while (iter.hasNext()) {
                this.addDirective(FRIENDS, iter.next().toString());
            }
        }
        this.fHeader.update();
        this.fireStructureChanged(friend, 2);
    }

    public boolean hasFriend(String name) {
        return this.fFriends.containsKey(name);
    }

    public boolean hasSameVisibility(ExportPackageObject object) {
        if (object.isInternal() != this.isInternal()) {
            return false;
        }
        if (this.fFriends.size() != object.fFriends.size()) {
            return false;
        }
        Iterator iter = this.fFriends.keySet().iterator();
        while (iter.hasNext()) {
            if (object.fFriends.containsKey(iter.next())) continue;
            return false;
        }
        return true;
    }

    public void setUsesDirective(String value) {
        String oldValue = this.getUsesDirective();
        this.setDirective("uses", value);
        this.fHeader.update();
        this.firePropertyChanged(this, "uses", oldValue, value);
    }

    public String getUsesDirective() {
        return this.getDirective("uses");
    }

    protected void appendValuesToBuffer(StringBuffer sb, TreeMap table) {
        if (table == null) {
            return;
        }
        Object usesValue = null;
        if (table.containsKey("uses")) {
            usesValue = table.remove("uses");
        }
        super.appendValuesToBuffer(sb, table);
        if (usesValue != null) {
            table.put("uses", usesValue);
            this.formatUsesDirective(sb, usesValue);
        }
    }

    private void formatUsesDirective(StringBuffer sb, Object usesValue) {
        StringTokenizer tokenizer = null;
        if (usesValue instanceof String) {
            tokenizer = new StringTokenizer((String)usesValue, ",");
        }
        boolean newLine = tokenizer != null ? tokenizer.countTokens() > 3 : ((ArrayList)usesValue).size() > 3;
        String eol = this.getHeader().getLineLimiter();
        sb.append(';');
        if (newLine) {
            sb.append(eol).append("  ");
        }
        sb.append("uses");
        sb.append(":=\"");
        if (tokenizer != null) {
            while (tokenizer.hasMoreTokens()) {
                sb.append(tokenizer.nextToken());
                if (!tokenizer.hasMoreTokens()) continue;
                sb.append(',');
                if (!newLine) continue;
                sb.append(eol).append("   ");
            }
        } else {
            ArrayList list = (ArrayList)usesValue;
            int i = 0;
            while (i < list.size()) {
                if (i != 0) {
                    sb.append(',');
                    if (newLine) {
                        sb.append(eol).append("   ");
                    }
                }
                sb.append(list.get(i));
                ++i;
            }
        }
        sb.append("\"");
    }

    public void write(String indent, PrintWriter writer) {
        writer.write(this.write());
    }

    public void reconnect(IBundleModel model, ExportPackageHeader header, String versionAttribute) {
        super.reconnect(model, header, versionAttribute);
        this.reconnectFriends();
    }

    private void reconnectFriends() {
        Iterator keys = this.fFriends.keySet().iterator();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            PackageFriend friend = (PackageFriend)this.fFriends.get(key);
            friend.reconnect(this);
        }
    }
}

