/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.product;

import java.io.PrintWriter;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.pde.internal.core.iproduct.IJREInfo;
import org.eclipse.pde.internal.core.iproduct.IProductModel;
import org.eclipse.pde.internal.core.product.ProductObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JREInfo
extends ProductObject
implements IJREInfo {
    private static final long serialVersionUID = 1L;
    private String fJVMLin = "";
    private String fJVMMac = "";
    private String fJVMSol = "";
    private String fJVMWin = "";
    private int fJVMLinType = 0;
    private int fJVMMacType = 0;
    private int fJVMSolType = 0;
    private int fJVMWinType = 0;

    public JREInfo(IProductModel model) {
        super(model);
    }

    public String getJVM(int platform) {
        switch (platform) {
            case 0: {
                return this.fJVMLin;
            }
            case 1: {
                return this.fJVMMac;
            }
            case 2: {
                return this.fJVMSol;
            }
            case 3: {
                return this.fJVMWin;
            }
        }
        return "";
    }

    public String getJVMLocation(String os) {
        if ("win32".equals(os)) {
            return this.getJVMLocation(this.fJVMWin, this.fJVMWinType);
        }
        if ("linux".equals(os)) {
            return this.getJVMLocation(this.fJVMLin, this.fJVMLinType);
        }
        if ("macosx".equals(os)) {
            return this.getJVMLocation(this.fJVMMac, this.fJVMMacType);
        }
        if ("solaris".equals(os)) {
            return this.getJVMLocation(this.fJVMSol, this.fJVMSolType);
        }
        return "";
    }

    private String getJVMLocation(String name, int type) {
        if (type == 1) {
            IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
            IExecutionEnvironment environment = manager.getEnvironment(name);
            IVMInstall vm = null;
            if (environment != null) {
                vm = environment.getDefaultVM();
                if (vm == null) {
                    IVMInstall[] installs = environment.getCompatibleVMs();
                    int i = 0;
                    while (i < installs.length) {
                        IVMInstall install = installs[i];
                        if (environment.isStrictlyCompatible(install)) {
                            return install.getInstallLocation().getAbsolutePath();
                        }
                        ++i;
                    }
                    if (vm == null && installs.length > 0) {
                        return installs[0].getInstallLocation().getAbsolutePath();
                    }
                }
                return vm.getInstallLocation().getAbsolutePath();
            }
        } else if (type == 0) {
            IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
            int i = 0;
            while (i < types.length) {
                IVMInstall[] installs = types[i].getVMInstalls();
                int k = 0;
                while (k < installs.length) {
                    if (installs[k].getName().equals(name)) {
                        return installs[k].getInstallLocation().getAbsolutePath();
                    }
                    ++k;
                }
                ++i;
            }
        }
        return null;
    }

    public void setJVM(String args, int platform, int type) {
        if (args == null) {
            args = "";
        }
        switch (platform) {
            case 0: {
                String old = this.fJVMLin;
                this.fJVMLin = args;
                this.fJVMLinType = type;
                if (!this.isEditable()) break;
                this.firePropertyChanged("linux", old, this.fJVMLin);
                break;
            }
            case 1: {
                String old = this.fJVMMac;
                this.fJVMMac = args;
                this.fJVMMacType = type;
                if (!this.isEditable()) break;
                this.firePropertyChanged("macos", old, this.fJVMMac);
                break;
            }
            case 2: {
                String old = this.fJVMSol;
                this.fJVMSol = args;
                this.fJVMSolType = type;
                if (!this.isEditable()) break;
                this.firePropertyChanged("solaris", old, this.fJVMSol);
                break;
            }
            case 3: {
                String old = this.fJVMWin;
                this.fJVMWin = args;
                this.fJVMWinType = type;
                if (!this.isEditable()) break;
                this.firePropertyChanged("windows", old, this.fJVMWin);
            }
        }
    }

    public void parse(Node node) {
        NodeList list = node.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            Node child = list.item(i);
            if (child.getNodeType() == 1) {
                if (child.getNodeName().equals("linux")) {
                    this.fJVMLin = this.getText(child);
                    this.fJVMLinType = this.parseTypeString(((Element)child).getAttribute("type"));
                } else if (child.getNodeName().equals("macos")) {
                    this.fJVMMac = this.getText(child);
                    this.fJVMMacType = this.parseTypeString(((Element)child).getAttribute("type"));
                } else if (child.getNodeName().equals("solaris")) {
                    this.fJVMSol = this.getText(child);
                    this.fJVMSolType = this.parseTypeString(((Element)child).getAttribute("type"));
                } else if (child.getNodeName().equals("windows")) {
                    this.fJVMWin = this.getText(child);
                    this.fJVMWinType = this.parseTypeString(((Element)child).getAttribute("type"));
                }
            }
            ++i;
        }
    }

    private String getText(Node node) {
        node.normalize();
        Node text = node.getFirstChild();
        if (text != null && text.getNodeType() == 3) {
            return text.getNodeValue();
        }
        return "";
    }

    public void write(String indent, PrintWriter writer) {
        writer.println(String.valueOf(indent) + "<vm>");
        if (this.fJVMLin.length() > 0) {
            writer.println(String.valueOf(indent) + "   " + "<" + "linux" + " type=\"" + this.getWritableTypeString(this.fJVMLinType) + "\">" + this.getWritableString(this.fJVMLin) + "</" + "linux" + ">");
        }
        if (this.fJVMMac.length() > 0) {
            writer.println(String.valueOf(indent) + "   " + "<" + "macos" + " type=\"" + this.getWritableTypeString(this.fJVMMacType) + "\">" + this.getWritableString(this.fJVMMac) + "</" + "macos" + ">");
        }
        if (this.fJVMSol.length() > 0) {
            writer.println(String.valueOf(indent) + "   " + "<" + "solaris" + " type=\"" + this.getWritableTypeString(this.fJVMSolType) + "\">" + this.getWritableString(this.fJVMSol) + "</" + "solaris" + ">");
        }
        if (this.fJVMWin.length() > 0) {
            writer.println(String.valueOf(indent) + "   " + "<" + "windows" + " type=\"" + this.getWritableTypeString(this.fJVMWinType) + "\">" + this.getWritableString(this.fJVMWin) + "</" + "windows" + ">");
        }
        writer.println(String.valueOf(indent) + "</vm>");
    }

    private String getWritableTypeString(int type) {
        if (type == 1) {
            return "ee";
        }
        if (type == 0) {
            return "jre";
        }
        return "";
    }

    private int parseTypeString(String type) {
        if (type.equalsIgnoreCase("ee")) {
            return 1;
        }
        if (type.equalsIgnoreCase("jre")) {
            return 0;
        }
        return 0;
    }

    public int getJVMType(int platform) {
        switch (platform) {
            case 0: {
                return this.fJVMLinType;
            }
            case 1: {
                return this.fJVMMacType;
            }
            case 2: {
                return this.fJVMSolType;
            }
            case 3: {
                return this.fJVMWinType;
            }
        }
        return 0;
    }
}

