/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.plugin.IdentifiablePluginObject;
import org.eclipse.pde.internal.core.plugin.PluginObject;

public abstract class PluginParent
extends IdentifiablePluginObject
implements IPluginParent {
    protected ArrayList fChildren = new ArrayList(1);

    public void add(int index, IPluginObject child) throws CoreException {
        this.ensureModelEditable();
        this.fChildren.add(index, child);
        this.postAdd(child);
    }

    public void add(IPluginObject child) throws CoreException {
        this.ensureModelEditable();
        this.fChildren.add(child);
        this.postAdd(child);
    }

    void appendChild(IPluginElement child) {
        this.fChildren.add(child);
    }

    protected void postAdd(IPluginObject child) {
        ((PluginObject)child).setInTheModel(true);
        ((PluginObject)child).setParent(this);
        this.fireStructureChanged(child, 1);
    }

    public int getChildCount() {
        return this.fChildren.size();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof IPluginParent) {
            IPluginParent target = (IPluginParent)obj;
            if (target.getChildCount() != this.getChildCount()) {
                return false;
            }
            IPluginObject[] tchildren = target.getChildren();
            int i = 0;
            while (i < tchildren.length) {
                IPluginObject tchild = tchildren[i];
                if (!tchild.equals(this.fChildren.get(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public int getIndexOf(IPluginObject child) {
        return this.fChildren.indexOf(child);
    }

    public void swap(IPluginObject child1, IPluginObject child2) throws CoreException {
        this.ensureModelEditable();
        int index1 = this.fChildren.indexOf(child1);
        int index2 = this.fChildren.indexOf(child2);
        if (index1 == -1 || index2 == -1) {
            this.throwCoreException(PDECoreMessages.PluginParent_siblingsNotFoundException);
        }
        this.fChildren.set(index2, child1);
        this.fChildren.set(index1, child2);
        this.firePropertyChanged(this, "sibling_order", child1, child2);
    }

    public IPluginObject[] getChildren() {
        return this.fChildren.toArray(new IPluginObject[this.fChildren.size()]);
    }

    public void remove(IPluginObject child) throws CoreException {
        this.ensureModelEditable();
        this.fChildren.remove(child);
        ((PluginObject)child).setInTheModel(false);
        this.fireStructureChanged(child, 2);
    }
}

