/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.cheatsheet.simple;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.IWorkspaceModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.cheatsheet.simple.SimpleCSModel;

public class SimpleCSWorkspaceModel
extends SimpleCSModel
implements IWorkspaceModel {
    private static final long serialVersionUID = 1L;
    private IFile fFile;
    private boolean fDirty;
    private boolean fEditable;

    public SimpleCSWorkspaceModel(IFile file, boolean editable) {
        this.fFile = file;
        this.fEditable = editable;
    }

    public void load() throws CoreException {
        if (this.fFile.exists()) {
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(this.fFile.getContents(true));
                this.load(stream, false);
            }
            catch (CoreException coreException) {}
        }
    }

    public boolean isInSync() {
        IPath path = this.fFile.getLocation();
        if (path == null) {
            return false;
        }
        return this.isInSync(path.toFile());
    }

    public IResource getUnderlyingResource() {
        return this.fFile;
    }

    public String getInstallLocation() {
        return this.fFile.getLocation().toOSString();
    }

    public void save() {
        try {
            String contents = this.getContents();
            ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes("UTF8"));
            if (this.fFile.exists()) {
                this.fFile.setContents((InputStream)stream, false, false, null);
            } else {
                this.fFile.create((InputStream)stream, false, null);
            }
            stream.close();
        }
        catch (CoreException e) {
            PDECore.logException(e);
        }
        catch (IOException iOException) {}
    }

    private String getContents() {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        this.setLoaded(true);
        this.save(writer);
        writer.flush();
        try {
            swriter.close();
        }
        catch (IOException iOException) {}
        return swriter.toString();
    }

    public boolean isDirty() {
        return this.fDirty;
    }

    public void save(PrintWriter writer) {
        if (this.isLoaded()) {
            this.getSimpleCS().write("", writer);
        }
        this.setDirty(false);
    }

    public void setDirty(boolean dirty) {
        this.fDirty = dirty;
    }

    public void fireModelChanged(IModelChangedEvent event) {
        this.setDirty(true);
        super.fireModelChanged(event);
    }

    public boolean isEditable() {
        return this.fEditable;
    }

    public void reload() {
        if (this.fFile.exists()) {
            BufferedInputStream stream = null;
            try {
                stream = new BufferedInputStream(this.fFile.getContents(true));
                this.reload(stream, false);
                this.setDirty(false);
            }
            catch (CoreException coreException) {}
        }
    }
}

