/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.cheatsheet.simple;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.pde.internal.core.XMLPrintHandler;
import org.eclipse.pde.internal.core.cheatsheet.simple.SimpleCSObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModel;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModelFactory;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSRepeatedSubItem;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSSubItem;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleCSRepeatedSubItem
extends SimpleCSObject
implements ISimpleCSRepeatedSubItem {
    private String fValues;
    private ISimpleCSSubItem fSubItem;
    private static final long serialVersionUID = 1L;

    public SimpleCSRepeatedSubItem(ISimpleCSModel model, ISimpleCSObject parent) {
        super(model, parent);
        this.reset();
    }

    public ISimpleCSSubItem getSubItem() {
        return this.fSubItem;
    }

    public String getValues() {
        return this.fValues;
    }

    public void setSubItem(ISimpleCSSubItem subitem) {
        ISimpleCSSubItem old = this.fSubItem;
        this.fSubItem = subitem;
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)subitem, old);
        }
    }

    public void setValues(String values) {
        String old = this.fValues;
        this.fValues = values;
        if (this.isEditable()) {
            this.firePropertyChanged("values", old, this.fValues);
        }
    }

    public void parse(Element element) {
        this.fValues = element.getAttribute("values");
        NodeList children = element.getChildNodes();
        ISimpleCSModelFactory factory = this.getModel().getFactory();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                String name = child.getNodeName();
                Element childElement = (Element)child;
                if (name.equals("subitem")) {
                    this.fSubItem = factory.createSimpleCSSubItem(this);
                    this.fSubItem.parse(childElement);
                    break;
                }
            }
            ++i;
        }
    }

    public void write(String indent, PrintWriter writer) {
        StringBuffer buffer = new StringBuffer();
        String newIndent = String.valueOf(indent) + "   ";
        try {
            buffer.append("repeated-subitem");
            if (this.fValues != null && this.fValues.length() > 0) {
                buffer.append(XMLPrintHandler.wrapAttribute("values", this.fValues));
            }
            XMLPrintHandler.printBeginElement(writer, buffer.toString(), indent, false);
            if (this.fSubItem != null) {
                this.fSubItem.write(newIndent, writer);
            }
            XMLPrintHandler.printEndElement(writer, "repeated-subitem", indent);
        }
        catch (IOException iOException) {}
    }

    public void reset() {
        this.fValues = null;
        this.fSubItem = null;
    }

    public int getType() {
        return 9;
    }

    public String getName() {
        return "repeated-subitem";
    }

    public List getChildren() {
        ArrayList<ISimpleCSSubItem> list = new ArrayList<ISimpleCSSubItem>();
        if (this.fSubItem != null) {
            list.add(this.fSubItem);
        }
        return list;
    }
}

