/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.cheatsheet.simple;

import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.SAXParser;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.internal.core.AbstractModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.XMLDefaultHandler;
import org.eclipse.pde.internal.core.cheatsheet.simple.SimpleCSModelFactory;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCS;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModel;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModelFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.helpers.DefaultHandler;

public class SimpleCSModel
extends AbstractModel
implements ISimpleCSModel {
    private ISimpleCSModelFactory fFactory;
    private ISimpleCS fSimpleCS;
    private static final long serialVersionUID = 1L;

    protected void updateTimeStamp() {
    }

    public ISimpleCSModelFactory getFactory() {
        if (this.fFactory == null) {
            this.fFactory = new SimpleCSModelFactory(this);
        }
        return this.fFactory;
    }

    public ISimpleCS getSimpleCS() {
        if (this.fSimpleCS == null) {
            this.fSimpleCS = this.getFactory().createSimpleCS();
        }
        return this.fSimpleCS;
    }

    public boolean isInSync() {
        return true;
    }

    public void load() throws CoreException {
    }

    public void load(InputStream source, boolean outOfSync) throws CoreException {
        block15: {
            try {
                try {
                    SAXParser parser = this.getSaxParser();
                    XMLDefaultHandler handler = new XMLDefaultHandler();
                    parser.parse(source, (DefaultHandler)handler);
                    if (handler.isPrepared()) {
                        this.processDocument(handler.getDocument());
                        this.setLoaded(true);
                    }
                }
                catch (Exception e) {
                    this.setException(e);
                    PDECore.logException(e);
                    try {
                        if (source != null) {
                            source.close();
                        }
                        break block15;
                    }
                    catch (IOException iOException) {}
                    break block15;
                }
            }
            catch (Throwable throwable) {
                try {
                    if (source != null) {
                        source.close();
                    }
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                if (source != null) {
                    source.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    public void reload(InputStream source, boolean outOfSync) throws CoreException {
        this.load(source, outOfSync);
        this.fireModelChanged(new ModelChangedEvent(this, 99, new Object[]{this.fSimpleCS}, null));
    }

    public boolean isEditable() {
        return false;
    }

    private void processDocument(Document doc) {
        Element rootNode = doc.getDocumentElement();
        if (this.fSimpleCS == null) {
            this.fSimpleCS = this.getFactory().createSimpleCS();
        } else {
            this.fSimpleCS.reset();
        }
        this.fSimpleCS.parse(rootNode);
    }
}

