/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.cheatsheet.simple;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.pde.internal.core.XMLPrintHandler;
import org.eclipse.pde.internal.core.cheatsheet.simple.SimpleCSObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSDescription;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSItem;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModel;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSModelFactory;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSOnCompletion;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSRunContainerObject;
import org.eclipse.pde.internal.core.icheatsheet.simple.ISimpleCSSubItemObject;
import org.eclipse.pde.internal.core.util.PDETextHelper;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SimpleCSItem
extends SimpleCSObject
implements ISimpleCSItem {
    private ISimpleCSOnCompletion fOnCompletion;
    private ISimpleCSRunContainerObject fExecutable;
    private boolean fSkip;
    private boolean fDialog;
    private ISimpleCSDescription fDescription;
    private String fTitle;
    private String fContextId;
    private String fHref;
    private ArrayList fSubItems;
    private static final long serialVersionUID = 1L;

    public SimpleCSItem(ISimpleCSModel model, ISimpleCSObject parent) {
        super(model, parent);
        this.reset();
    }

    public String getContextId() {
        return this.fContextId;
    }

    public ISimpleCSDescription getDescription() {
        return this.fDescription;
    }

    public boolean getDialog() {
        return this.fDialog;
    }

    public ISimpleCSRunContainerObject getExecutable() {
        return this.fExecutable;
    }

    public String getHref() {
        return this.fHref;
    }

    public boolean getSkip() {
        return this.fSkip;
    }

    public ISimpleCSSubItemObject[] getSubItems() {
        return this.fSubItems.toArray(new ISimpleCSSubItemObject[this.fSubItems.size()]);
    }

    public String getTitle() {
        return this.fTitle;
    }

    public void setContextId(String contextId) {
        String old = this.fContextId;
        this.fContextId = contextId;
        if (this.isEditable()) {
            this.firePropertyChanged("contextId", old, this.fContextId);
        }
    }

    public void setDescription(ISimpleCSDescription description) {
        ISimpleCSDescription old = this.fDescription;
        this.fDescription = description;
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)description, old);
        }
    }

    public void setDialog(boolean dialog) {
        Boolean old = this.fDialog;
        this.fDialog = dialog;
        if (this.isEditable()) {
            this.firePropertyChanged("dialog", old, this.fDialog);
        }
    }

    public void setExecutable(ISimpleCSRunContainerObject executable) {
        ISimpleCSRunContainerObject old = this.fExecutable;
        this.fExecutable = executable;
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)executable, old);
        }
    }

    public void setHref(String href) {
        String old = this.fHref;
        this.fHref = href;
        if (this.isEditable()) {
            this.firePropertyChanged("href", old, this.fHref);
        }
    }

    public void setSkip(boolean skip) {
        Boolean old = this.fSkip;
        this.fSkip = skip;
        if (this.isEditable()) {
            this.firePropertyChanged("skip", old, this.fSkip);
        }
    }

    public void setTitle(String title) {
        String old = this.fTitle;
        this.fTitle = title;
        if (this.isEditable()) {
            this.firePropertyChanged("title", old, this.fTitle);
        }
    }

    public void parse(Element element) {
        this.fTitle = element.getAttribute("title").trim();
        if (element.getAttribute("dialog").compareTo("false") == 0) {
            this.fDialog = false;
        }
        if (element.getAttribute("skip").compareTo("true") == 0) {
            this.fSkip = true;
        }
        this.fContextId = element.getAttribute("contextId").trim();
        this.fHref = element.getAttribute("href").trim();
        NodeList children = element.getChildNodes();
        ISimpleCSModelFactory factory = this.getModel().getFactory();
        int i = 0;
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child.getNodeType() == 1) {
                ISimpleCSSubItemObject subitem;
                String name = child.getNodeName();
                Element childElement = (Element)child;
                if (name.equals("description")) {
                    this.fDescription = factory.createSimpleCSDescription(this);
                    this.fDescription.parse(childElement);
                } else if (name.equals("action")) {
                    this.fExecutable = factory.createSimpleCSAction(this);
                    this.fExecutable.parse(childElement);
                } else if (name.equals("command")) {
                    this.fExecutable = factory.createSimpleCSCommand(this);
                    this.fExecutable.parse(childElement);
                } else if (name.equals("perform-when")) {
                    this.fExecutable = factory.createSimpleCSPerformWhen(this);
                    this.fExecutable.parse(childElement);
                } else if (name.equals("subitem")) {
                    subitem = factory.createSimpleCSSubItem(this);
                    this.fSubItems.add(subitem);
                    subitem.parse(childElement);
                } else if (name.equals("repeated-subitem")) {
                    subitem = factory.createSimpleCSRepeatedSubItem(this);
                    this.fSubItems.add(subitem);
                    subitem.parse(childElement);
                } else if (name.equals("conditional-subitem")) {
                    subitem = factory.createSimpleCSConditionalSubItem(this);
                    this.fSubItems.add(subitem);
                    subitem.parse(childElement);
                } else if (name.equals("onCompletion")) {
                    this.fOnCompletion = factory.createSimpleCSOnCompletion(this);
                    this.fOnCompletion.parse(childElement);
                }
            }
            ++i;
        }
    }

    public void write(String indent, PrintWriter writer) {
        StringBuffer buffer = new StringBuffer();
        String newIndent = String.valueOf(indent) + "   ";
        try {
            buffer.append("item");
            if (this.fTitle != null && this.fTitle.length() > 0) {
                buffer.append(XMLPrintHandler.wrapAttribute("title", PDETextHelper.translateWriteText(this.fTitle.trim(), SUBSTITUTE_CHARS)));
            }
            buffer.append(XMLPrintHandler.wrapAttribute("dialog", new Boolean(this.fDialog).toString()));
            buffer.append(XMLPrintHandler.wrapAttribute("skip", new Boolean(this.fSkip).toString()));
            if (this.fContextId != null && this.fContextId.length() > 0) {
                buffer.append(XMLPrintHandler.wrapAttribute("contextId", PDETextHelper.translateWriteText(this.fContextId.trim(), SUBSTITUTE_CHARS)));
            } else if (this.fHref != null && this.fHref.length() > 0) {
                buffer.append(XMLPrintHandler.wrapAttribute("href", PDETextHelper.translateWriteText(this.fHref.trim(), SUBSTITUTE_CHARS)));
            }
            XMLPrintHandler.printBeginElement(writer, buffer.toString(), indent, false);
            if (this.fDescription != null) {
                this.fDescription.write(newIndent, writer);
            }
            if (this.fExecutable != null) {
                this.fExecutable.write(newIndent, writer);
            }
            Iterator iterator = this.fSubItems.iterator();
            while (iterator.hasNext()) {
                ISimpleCSSubItemObject subitem = (ISimpleCSSubItemObject)iterator.next();
                subitem.write(newIndent, writer);
            }
            if (this.fOnCompletion != null) {
                this.fOnCompletion.write(newIndent, writer);
            }
            XMLPrintHandler.printEndElement(writer, "item", indent);
        }
        catch (IOException iOException) {}
    }

    public void reset() {
        this.fOnCompletion = null;
        this.fExecutable = null;
        this.fSkip = false;
        this.fDialog = true;
        this.fDescription = null;
        this.fTitle = null;
        this.fContextId = null;
        this.fHref = null;
        this.fSubItems = new ArrayList();
    }

    public void addSubItem(ISimpleCSSubItemObject subitem) {
        this.fSubItems.add(subitem);
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)subitem, 1);
        }
    }

    public ISimpleCSOnCompletion getOnCompletion() {
        return this.fOnCompletion;
    }

    public void removeSubItem(ISimpleCSSubItemObject subitem) {
        this.fSubItems.remove(subitem);
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)subitem, 2);
        }
    }

    public void setOnCompletion(ISimpleCSOnCompletion onCompletion) {
        ISimpleCSOnCompletion old = this.fOnCompletion;
        this.fOnCompletion = onCompletion;
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)onCompletion, old);
        }
    }

    public int getType() {
        return 6;
    }

    public String getName() {
        return this.fTitle;
    }

    public List getChildren() {
        ArrayList<ISimpleCSRunContainerObject> list = new ArrayList<ISimpleCSRunContainerObject>();
        if (this.fSubItems.size() > 0) {
            list.addAll(this.fSubItems);
        }
        if (this.fExecutable != null && this.fExecutable.getType() == 8) {
            list.add(this.fExecutable);
        }
        return list;
    }

    public void addSubItem(int index, ISimpleCSSubItemObject subitem) {
        if (index < 0) {
            return;
        }
        if (index >= this.fSubItems.size()) {
            this.fSubItems.add(subitem);
        } else {
            this.fSubItems.add(index, subitem);
        }
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)subitem, 1);
        }
    }

    public int indexOfSubItem(ISimpleCSSubItemObject subitem) {
        return this.fSubItems.indexOf(subitem);
    }

    public boolean isFirstSubItem(ISimpleCSSubItemObject subitem) {
        int position = this.fSubItems.indexOf(subitem);
        return position == 0;
    }

    public boolean isLastSubItem(ISimpleCSSubItemObject subitem) {
        int lastPosition;
        int position = this.fSubItems.indexOf(subitem);
        return position == (lastPosition = this.fSubItems.size() - 1);
    }

    public void removeSubItem(int index) {
        if (index < 0 || index > this.fSubItems.size() - 1) {
            return;
        }
        ISimpleCSSubItemObject subitem = (ISimpleCSSubItemObject)this.fSubItems.remove(index);
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)subitem, 2);
        }
    }

    public int getSubItemCount() {
        return this.fSubItems.size();
    }

    public boolean hasSubItems() {
        return !this.fSubItems.isEmpty();
    }

    public ISimpleCSSubItemObject getNextSibling(ISimpleCSSubItemObject subitem) {
        int position = this.fSubItems.indexOf(subitem);
        int lastIndex = this.fSubItems.size() - 1;
        if (position == -1 || position == lastIndex) {
            return null;
        }
        return (ISimpleCSSubItemObject)this.fSubItems.get(position + 1);
    }

    public ISimpleCSSubItemObject getPreviousSibling(ISimpleCSSubItemObject subitem) {
        int position = this.fSubItems.indexOf(subitem);
        if (position == -1 || position == 0) {
            return null;
        }
        return (ISimpleCSSubItemObject)this.fSubItems.get(position - 1);
    }

    public void moveSubItem(ISimpleCSSubItemObject subitem, int newRelativeIndex) {
        int currentIndex = this.fSubItems.indexOf(subitem);
        if (currentIndex == -1) {
            return;
        }
        int newIndex = newRelativeIndex + currentIndex;
        if (newIndex < 0 || newIndex >= this.fSubItems.size()) {
            return;
        }
        this.fSubItems.remove(subitem);
        this.fSubItems.add(newIndex, subitem);
        if (this.isEditable()) {
            this.fireStructureChanged((ISimpleCSObject)subitem, 1);
        }
    }
}

