/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.builders;

import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IncrementalProjectBuilder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.builders.BuildErrorReporter;
import org.eclipse.pde.internal.core.builders.BundleErrorReporter;
import org.eclipse.pde.internal.core.builders.CompilerFlags;
import org.eclipse.pde.internal.core.builders.DefaultSAXParser;
import org.eclipse.pde.internal.core.builders.ExtensionsErrorReporter;
import org.eclipse.pde.internal.core.builders.FragmentErrorReporter;
import org.eclipse.pde.internal.core.builders.PluginErrorReporter;
import org.eclipse.pde.internal.core.builders.XMLErrorReporter;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;

public class ManifestConsistencyChecker
extends IncrementalProjectBuilder {
    private int MANIFEST = 1;
    private int EXTENSIONS = 2;
    private int BUILD = 4;
    private static boolean DEBUG = false;
    private static IProject[] EMPTY_LIST = new IProject[0];
    private SelfVisitor fSelfVisitor = new SelfVisitor();
    private ClassChangeVisitor fClassFileVisitor = new ClassChangeVisitor();

    static {
        DEBUG = PDECore.getDefault().isDebugging() && "true".equals(Platform.getDebugOption((String)"org.eclipse.pde.core/validation"));
    }

    private boolean isLocalizationFile(IResource file) {
        IPluginModelBase model = PluginRegistry.findModel(this.getProject());
        String localization = null;
        localization = model instanceof IBundlePluginModelBase ? ((IBundlePluginModelBase)model).getBundleLocalization() : "plugin";
        if (localization != null) {
            return file.getProjectRelativePath().equals((Object)new Path(String.valueOf(localization) + ".properties"));
        }
        return false;
    }

    protected IProject[] build(int kind, Map args, IProgressMonitor monitor) throws CoreException {
        int type;
        if (PDECore.getDefault().getBundle().getState() != 32 || monitor.isCanceled()) {
            return EMPTY_LIST;
        }
        IProject project = this.getProject();
        if (!WorkspaceModelManager.isBinaryProject(project) && (type = this.getDeltaType(project)) != 0) {
            this.validateProject(type, monitor);
        }
        return EMPTY_LIST;
    }

    private int getDeltaType(IProject project) throws CoreException {
        IResourceDelta delta = this.getDelta(project);
        if (delta == null) {
            if (DEBUG) {
                System.out.println("Project [" + this.getProject().getName() + "] - full build");
            }
            return this.MANIFEST | this.EXTENSIONS | this.BUILD;
        }
        if (Boolean.TRUE.equals(project.getSessionProperty(PDECore.TOUCH_PROJECT))) {
            project.setSessionProperty(PDECore.TOUCH_PROJECT, null);
            if (DEBUG) {
                System.out.println("Dependencies Changed: Project [" + this.getProject().getName() + "] - full build");
            }
            return this.MANIFEST | this.EXTENSIONS | this.BUILD;
        }
        this.fSelfVisitor.reset();
        delta.accept((IResourceDeltaVisitor)this.fSelfVisitor);
        int type = this.fSelfVisitor.getType();
        if ((type & this.MANIFEST | this.EXTENSIONS) != (this.MANIFEST | this.EXTENSIONS)) {
            this.fClassFileVisitor.reset();
            delta.accept((IResourceDeltaVisitor)this.fClassFileVisitor);
            if (this.fClassFileVisitor.hasChanged()) {
                type |= this.MANIFEST | this.EXTENSIONS;
                if (DEBUG) {
                    System.out.println("Class files changed due to dependency changes: Project [" + this.getProject().getName() + "] - rebuild manifest files");
                }
            }
        }
        return type;
    }

    private void validateProject(int type, IProgressMonitor monitor) {
        if ((type & this.MANIFEST | this.EXTENSIONS) != 0) {
            IFile manifestFile;
            IProject project = this.getProject();
            IFile file = project.getFile("plugin.xml");
            if (!file.exists()) {
                file = project.getFile("fragment.xml");
            }
            if (file.exists()) {
                this.validateFiles(file, type, monitor);
            } else if ((type & this.MANIFEST) != 0 && (manifestFile = project.getFile("META-INF/MANIFEST.MF")).exists()) {
                this.validateManifestFile(manifestFile, monitor);
            }
        }
        if ((type & this.BUILD) != 0) {
            this.validateBuildProperties(monitor);
        }
    }

    private void validateManifestFile(IFile file, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        String message = NLS.bind((String)PDECoreMessages.Builders_verifying, (Object)file.getFullPath().toString());
        monitor.subTask(message);
        BundleErrorReporter reporter = new BundleErrorReporter(file);
        if (reporter != null) {
            reporter.validateContent(monitor);
            monitor.subTask(PDECoreMessages.Builders_updating);
        }
        monitor.done();
    }

    private void validateFiles(IFile file, int type, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        String message = NLS.bind((String)PDECoreMessages.Builders_verifying, (Object)file.getFullPath().toString());
        monitor.subTask(message);
        IFile bundleManifest = file.getProject().getFile("META-INF/MANIFEST.MF");
        ExtensionsErrorReporter reporter = null;
        BundleErrorReporter bundleReporter = null;
        if (bundleManifest.exists()) {
            if ((type & this.EXTENSIONS) != 0) {
                reporter = new ExtensionsErrorReporter(file);
            }
            if ((type & this.MANIFEST) != 0) {
                bundleReporter = new BundleErrorReporter(bundleManifest);
            }
        } else if ((type & this.MANIFEST) != 0 || (type & this.EXTENSIONS) != 0) {
            if (file.getName().equals("plugin.xml")) {
                reporter = new PluginErrorReporter(file);
            } else if (file.getName().equals("fragment.xml")) {
                reporter = new FragmentErrorReporter(file);
            }
        }
        if (reporter != null) {
            DefaultSAXParser.parse(file, reporter);
            ((XMLErrorReporter)reporter).validateContent(monitor);
            monitor.subTask(PDECoreMessages.Builders_updating);
        }
        if (bundleReporter != null) {
            bundleReporter.validateContent(monitor);
            monitor.subTask(PDECoreMessages.Builders_updating);
        }
        monitor.done();
    }

    private void validateBuildProperties(IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        IProject project = this.getProject();
        try {
            project.deleteMarkers("org.eclipse.pde.core.problem", false, 0);
        }
        catch (CoreException coreException) {}
        IFile file = project.getFile("build.properties");
        if (!file.exists()) {
            int severity = CompilerFlags.getFlag(project, "compilers.p.build");
            if (severity == 2) {
                return;
            }
            try {
                IMarker marker = project.createMarker("org.eclipse.pde.core.problem");
                marker.setAttribute("severity", severity == 0 ? 2 : 1);
                marker.setAttribute("message", (Object)PDECoreMessages.ManifestConsistencyChecker_buildDoesNotExist);
            }
            catch (CoreException coreException) {}
        } else {
            monitor.subTask(PDECoreMessages.ManifestConsistencyChecker_buildPropertiesSubtask);
            BuildErrorReporter ber = new BuildErrorReporter(file);
            ber.validateContent(monitor);
        }
    }

    class ClassChangeVisitor
    implements IResourceDeltaVisitor {
        boolean hasChanged = false;
        boolean veto = false;

        ClassChangeVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            int kind;
            if (delta != null && !this.veto && (kind = delta.getKind()) == 4) {
                IResource resource = delta.getResource();
                if (resource instanceof IFile) {
                    String extension = resource.getFileExtension();
                    if ("java".equals(extension)) {
                        this.veto = true;
                    } else if ("class".equals(extension) && !this.hasChanged) {
                        this.hasChanged = true;
                    }
                }
                return !this.veto;
            }
            return false;
        }

        public void reset() {
            this.veto = false;
            this.hasChanged = false;
        }

        public boolean hasChanged() {
            return this.hasChanged && !this.veto;
        }
    }

    class SelfVisitor
    implements IResourceDeltaVisitor {
        int type = 0;

        SelfVisitor() {
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            if (delta != null && this.type != (ManifestConsistencyChecker.this.MANIFEST | ManifestConsistencyChecker.this.EXTENSIONS | ManifestConsistencyChecker.this.BUILD)) {
                int kind = delta.getKind();
                if (kind == 1 || kind == 2) {
                    this.type = ManifestConsistencyChecker.this.MANIFEST | ManifestConsistencyChecker.this.EXTENSIONS | ManifestConsistencyChecker.this.BUILD;
                    if (DEBUG) {
                        System.out.print("Needs to rebuild project [" + ManifestConsistencyChecker.this.getProject().getName() + "]: ");
                        System.out.print(delta.getResource().getProjectRelativePath().toString());
                        System.out.print(" - ");
                        System.out.println(kind == 1 ? "added" : "removed");
                    }
                    return false;
                }
                IResource resource = delta.getResource();
                if (resource instanceof IFile) {
                    String name = resource.getName();
                    IPath path = resource.getProjectRelativePath();
                    if (ManifestConsistencyChecker.this.isLocalizationFile(resource)) {
                        this.type |= ManifestConsistencyChecker.this.MANIFEST | ManifestConsistencyChecker.this.EXTENSIONS;
                        if (DEBUG) {
                            System.out.print("Needs to rebuild manifest and extensions in project [" + ManifestConsistencyChecker.this.getProject().getName() + "]: ");
                            System.out.print(delta.getResource().getProjectRelativePath().toString());
                            System.out.println(" - changed");
                        }
                    } else if (path.equals((Object)ICoreConstants.MANIFEST_PATH)) {
                        this.type |= ManifestConsistencyChecker.this.MANIFEST | ManifestConsistencyChecker.this.EXTENSIONS | ManifestConsistencyChecker.this.BUILD;
                        if (DEBUG) {
                            System.out.print("Needs to rebuild project [" + ManifestConsistencyChecker.this.getProject().getName() + "]: ");
                            System.out.print(delta.getResource().getProjectRelativePath().toString());
                            System.out.println(" - changed");
                        }
                    } else if (name.endsWith(".exsd") || path.equals((Object)ICoreConstants.PLUGIN_PATH) || path.equals((Object)ICoreConstants.FRAGMENT_PATH)) {
                        this.type |= ManifestConsistencyChecker.this.EXTENSIONS;
                        if (DEBUG) {
                            System.out.print("Needs to rebuild extensions in project [" + ManifestConsistencyChecker.this.getProject().getName() + "]: ");
                            System.out.print(delta.getResource().getProjectRelativePath().toString());
                            System.out.println(" - changed");
                        }
                    } else if (path.equals((Object)ICoreConstants.BUILD_PROPERTIES_PATH)) {
                        this.type |= ManifestConsistencyChecker.this.BUILD;
                        if (DEBUG) {
                            System.out.print("Needs to rebuild build.properties in project [" + ManifestConsistencyChecker.this.getProject().getName() + "]: ");
                            System.out.print(delta.getResource().getProjectRelativePath().toString());
                            System.out.println(" - changed");
                        }
                    }
                }
            }
            return this.type != (ManifestConsistencyChecker.this.MANIFEST | ManifestConsistencyChecker.this.EXTENSIONS | ManifestConsistencyChecker.this.BUILD);
        }

        public int getType() {
            return this.type;
        }

        public void reset() {
            this.type = 0;
        }
    }
}

