/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.osgi.util.ManifestElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ExecutionEnvironmentAnalyzer;
import org.eclipse.pde.internal.core.MinimalState;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.core.util.VersionUtil;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;

public class TargetPlatformHelper {
    private static final String SYSTEM_BUNDLE = "org.eclipse.osgi";
    private static String REFERENCE_PREFIX = "reference:";
    private static String FILE_URL_PREFIX = "file:";
    private static Map fCachedLocations;

    public static Properties getConfigIniProperties() {
        File iniFile = new File(TargetPlatform.getLocation(), "configuration/config.ini");
        if (!iniFile.exists()) {
            return null;
        }
        Properties pini = new Properties();
        try {
            FileInputStream fis = new FileInputStream(iniFile);
            pini.load(fis);
            fis.close();
            return pini;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getBundleList() {
        String osgiBundles;
        Properties properties = TargetPlatformHelper.getConfigIniProperties();
        String string = osgiBundles = properties == null ? null : properties.getProperty("osgi.bundles");
        if (osgiBundles == null) {
            StringBuffer buffer = new StringBuffer();
            if (TargetPlatformHelper.getTargetVersion() > 3.1) {
                buffer.append("org.eclipse.equinox.common@2:start,");
                buffer.append("org.eclipse.update.configurator@3:start,");
                buffer.append("org.eclipse.core.runtime@start");
            } else {
                buffer.append("org.eclipse.core.runtime@2:start,");
                buffer.append("org.eclipse.update.configurator@3:start");
            }
            osgiBundles = buffer.toString();
        } else {
            osgiBundles = TargetPlatformHelper.stripPathInformation(osgiBundles);
        }
        return osgiBundles;
    }

    public static String stripPathInformation(String osgiBundles) {
        StringBuffer result = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(osgiBundles, ",");
        while (tokenizer.hasMoreElements()) {
            Path path;
            String id;
            String token = tokenizer.nextToken();
            int index = token.indexOf(64);
            String bundle = index > 0 ? token.substring(0, index) : token;
            if ((bundle = bundle.trim()).startsWith(REFERENCE_PREFIX) && bundle.length() > REFERENCE_PREFIX.length()) {
                bundle = bundle.substring(REFERENCE_PREFIX.length());
            }
            if (bundle.startsWith(FILE_URL_PREFIX) && bundle.length() > FILE_URL_PREFIX.length()) {
                bundle = bundle.substring(FILE_URL_PREFIX.length());
            }
            String string = id = (path = new Path(bundle)).isAbsolute() ? TargetPlatformHelper.getSymbolicName(bundle) : path.lastSegment();
            if (result.length() > 0) {
                result.append(",");
            }
            result.append(id != null ? id : bundle);
            if (index <= -1) continue;
            result.append(token.substring(index).trim());
        }
        return result.toString();
    }

    private static synchronized String getSymbolicName(String path) {
        File file;
        if (fCachedLocations == null) {
            fCachedLocations = new HashMap();
        }
        if ((file = new File(path)).exists() && !fCachedLocations.containsKey(path)) {
            try {
                Dictionary dictionary = MinimalState.loadManifest(file);
                String value = (String)dictionary.get("Bundle-SymbolicName");
                if (value != null) {
                    String id;
                    ManifestElement[] elements = ManifestElement.parseHeader((String)"Bundle-SymbolicName", (String)value);
                    String string = id = elements.length > 0 ? elements[0].getValue() : null;
                    if (id != null) {
                        fCachedLocations.put(path, elements[0].getValue());
                    }
                }
            }
            catch (IOException iOException) {
            }
            catch (BundleException bundleException) {}
        }
        return (String)fCachedLocations.get(path);
    }

    public static void checkPluginPropertiesConsistency(Map map, File configDir) {
        File runtimeDir = new File(configDir, "org.eclipse.core.runtime");
        if (runtimeDir.exists() && runtimeDir.isDirectory()) {
            long timestamp = runtimeDir.lastModified();
            Iterator iter = map.values().iterator();
            while (iter.hasNext()) {
                if (!TargetPlatformHelper.hasChanged((IPluginModelBase)iter.next(), timestamp)) continue;
                CoreUtility.deleteContent(runtimeDir);
                break;
            }
        }
    }

    private static boolean hasChanged(IPluginModelBase model, long timestamp) {
        if (model.getUnderlyingResource() != null) {
            File[] files = new File(model.getInstallLocation()).listFiles();
            int i = 0;
            while (i < files.length) {
                String name;
                if (!files[i].isDirectory() && (name = files[i].getName()).startsWith("plugin") && name.endsWith(".properties") && files[i].lastModified() > timestamp) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static Set getApplicationNameSet() {
        TreeSet<String> result = new TreeSet<String>();
        IPluginModelBase[] plugins = PluginRegistry.getActiveModels();
        int i = 0;
        while (i < plugins.length) {
            IPluginExtension[] extensions = plugins[i].getPluginBase().getExtensions();
            int j = 0;
            while (j < extensions.length) {
                String id;
                if ("org.eclipse.core.runtime.applications".equals(extensions[j].getPoint()) && extensions[j].getId() != null && !(id = IdUtil.getFullId(extensions[j])).startsWith("org.eclipse.pde.junit.runtime")) {
                    result.add(IdUtil.getFullId(extensions[j]));
                }
                ++j;
            }
            ++i;
        }
        result.add("org.eclipse.ui.ide.workbench");
        return result;
    }

    public static String[] getApplicationNames() {
        Set result = TargetPlatformHelper.getApplicationNameSet();
        return result.toArray(new String[result.size()]);
    }

    public static TreeSet getProductNameSet() {
        TreeSet<String> result = new TreeSet<String>();
        IPluginModelBase[] plugins = PluginRegistry.getActiveModels();
        int i = 0;
        while (i < plugins.length) {
            IPluginExtension[] extensions = plugins[i].getPluginBase().getExtensions();
            int j = 0;
            while (j < extensions.length) {
                String id;
                IPluginObject[] children;
                if ("org.eclipse.core.runtime.products".equals(extensions[j].getPoint()) && (children = extensions[j].getChildren()).length == 1 && "product".equals(children[0].getName()) && (id = extensions[j].getId()) != null && id.trim().length() > 0) {
                    result.add(IdUtil.getFullId(extensions[j]));
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static String[] getProductNames() {
        TreeSet result = TargetPlatformHelper.getProductNameSet();
        return result.toArray(new String[result.size()]);
    }

    public static Dictionary getTargetEnvironment() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        ((Dictionary)result).put("osgi.os", TargetPlatform.getOS());
        ((Dictionary)result).put("osgi.ws", TargetPlatform.getWS());
        ((Dictionary)result).put("osgi.nl", TargetPlatform.getNL());
        ((Dictionary)result).put("osgi.arch", TargetPlatform.getOSArch());
        ((Dictionary)result).put("osgi.resolveOptional", "true");
        ((Dictionary)result).put("osgi.resolverMode", "development");
        return result;
    }

    public static Dictionary[] getPlatformProperties(String[] profiles, MinimalState state) {
        if (profiles == null || profiles.length == 0) {
            return new Dictionary[]{TargetPlatformHelper.getTargetEnvironment()};
        }
        ArrayList<Dictionary> result = new ArrayList<Dictionary>(profiles.length);
        int i = 0;
        while (i < profiles.length) {
            Properties profileProps = TargetPlatformHelper.getJavaProfileProperties(profiles[i], state.getState());
            if (profileProps != null) {
                String ee;
                Dictionary props = TargetPlatformHelper.getTargetEnvironment();
                String systemPackages = profileProps.getProperty("org.osgi.framework.system.packages");
                if (systemPackages != null) {
                    props.put("org.osgi.framework.system.packages", systemPackages);
                }
                if ((ee = profileProps.getProperty("org.osgi.framework.executionenvironment")) != null) {
                    props.put("org.osgi.framework.executionenvironment", ee);
                }
                result.add(props);
            }
            ++i;
        }
        if (result.size() > 0) {
            return result.toArray(new Dictionary[result.size()]);
        }
        return new Dictionary[]{TargetPlatformHelper.getTargetEnvironment()};
    }

    /*
     * Loose catch block
     */
    private static Properties getJavaProfileProperties(String ee, State state) {
        block36: {
            ZipFile zipFile;
            InputStream is;
            block33: {
                Properties properties;
                block34: {
                    BundleDescription osgiBundle = state.getBundle(SYSTEM_BUNDLE, null);
                    if (osgiBundle == null) {
                        return null;
                    }
                    File location = new File(osgiBundle.getLocation());
                    String filename = String.valueOf(ee.replace('/', '_')) + ".profile";
                    is = null;
                    zipFile = null;
                    if (location.isDirectory()) {
                        File file = new File(location, filename);
                        if (file.exists()) {
                            is = new FileInputStream(file);
                        }
                    } else {
                        zipFile = null;
                        try {
                            zipFile = new ZipFile(location, 1);
                            ZipEntry entry = zipFile.getEntry(filename);
                            if (entry != null) {
                                is = zipFile.getInputStream(entry);
                            }
                        }
                        catch (IOException iOException) {}
                    }
                    if (is == null) break block33;
                    Properties profile = new Properties();
                    profile.load(is);
                    properties = profile;
                    if (is == null) break block34;
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException iOException) {}
                }
                return properties;
                catch (IOException iOException) {
                    block35: {
                        try {
                            if (is == null) break block35;
                        }
                        catch (Throwable throwable) {
                            if (is != null) {
                                try {
                                    is.close();
                                }
                                catch (IOException iOException2) {}
                            }
                            if (zipFile != null) {
                                try {
                                    zipFile.close();
                                }
                                catch (IOException iOException3) {}
                            }
                            throw throwable;
                        }
                        try {
                            is.close();
                        }
                        catch (IOException iOException4) {}
                    }
                    if (zipFile != null) {
                        try {
                            zipFile.close();
                        }
                        catch (IOException iOException5) {}
                    }
                    break block36;
                }
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public static String[] getKnownExecutionEnvironments() {
        String jreProfile = System.getProperty("pde.jreProfile");
        if (jreProfile != null && jreProfile.length() > 0) {
            if ("none".equals(jreProfile)) {
                return new String[0];
            }
            return new String[]{jreProfile};
        }
        return ExecutionEnvironmentAnalyzer.getKnownExecutionEnvironments();
    }

    public static String getTargetVersionString() {
        IPluginModelBase model = PluginRegistry.findModel(SYSTEM_BUNDLE);
        if (model == null) {
            return "3.3";
        }
        String version = model.getPluginBase().getVersion();
        if (VersionUtil.validateVersion(version).getSeverity() == 0) {
            Version vid = new Version(version);
            int major = vid.getMajor();
            int minor = vid.getMinor();
            if (major == 3 && minor == 0) {
                return "3.0";
            }
            if (major == 3 && minor == 1) {
                return "3.1";
            }
            if (major == 3 && minor == 2) {
                return "3.2";
            }
        }
        return "3.3";
    }

    public static double getTargetVersion() {
        return Double.parseDouble(TargetPlatformHelper.getTargetVersionString());
    }

    public static PDEState getPDEState() {
        return PDECore.getDefault().getModelManager().getState();
    }

    public static State getState() {
        return TargetPlatformHelper.getPDEState().getState();
    }

    public static Map getPatchMap(PDEState state) {
        HashMap<Long, String> properties = new HashMap<Long, String>();
        IPluginModelBase[] models = PluginRegistry.getActiveModels();
        int i = 0;
        while (i < models.length) {
            BundleDescription desc = models[i].getBundleDescription();
            if (desc != null) {
                Long id = new Long(desc.getBundleId());
                if (ClasspathUtilCore.hasExtensibleAPI(models[i])) {
                    properties.put(id, "Eclipse-ExtensibleAPI: true");
                } else if (ClasspathUtilCore.isPatchFragment(models[i])) {
                    properties.put(id, "Eclipse-PatchFragment: true");
                }
            }
            ++i;
        }
        return properties;
    }

    public static HashMap getBundleClasspaths(PDEState state) {
        HashMap<Long, String[]> properties = new HashMap<Long, String[]>();
        BundleDescription[] bundles = state.getState().getBundles();
        int i = 0;
        while (i < bundles.length) {
            properties.put(new Long(bundles[i].getBundleId()), TargetPlatformHelper.getValue(bundles[i], state));
            ++i;
        }
        return properties;
    }

    private static String[] getValue(BundleDescription bundle, PDEState state) {
        IPluginModelBase model = PluginRegistry.findModel(bundle);
        String[] result = null;
        if (model != null) {
            IPluginLibrary[] libs = model.getPluginBase().getLibraries();
            result = new String[libs.length];
            int i = 0;
            while (i < libs.length) {
                result[i] = libs[i].getName();
                ++i;
            }
        } else {
            String[] libs = state.getLibraryNames(bundle.getBundleId());
            result = new String[libs.length];
            int i = 0;
            while (i < libs.length) {
                result[i] = libs[i];
                ++i;
            }
        }
        if (result.length == 0) {
            return new String[]{"."};
        }
        return result;
    }

    public static String[] getFeaturePaths() {
        IFeatureModel[] models = PDECore.getDefault().getFeatureModelManager().getModels();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < models.length) {
            String location = models[i].getInstallLocation();
            if (location != null) {
                list.add(String.valueOf(location) + '/' + "feature.xml");
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    public static boolean matchesCurrentEnvironment(IPluginModelBase model) {
        BundleContext context = PDECore.getDefault().getBundleContext();
        Dictionary environment = TargetPlatformHelper.getTargetEnvironment();
        BundleDescription bundle = model.getBundleDescription();
        String filterSpec = bundle != null ? bundle.getPlatformFilter() : null;
        try {
            return filterSpec == null || context.createFilter(filterSpec).match(environment);
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            return false;
        }
    }

    public static boolean usesNewApplicationModel() {
        return PluginRegistry.findModel("org.eclipse.equinox.app") != null;
    }
}

