/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.JavaElementChangeListener;
import org.eclipse.pde.internal.core.JavadocLocationManager;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.SearchablePluginsManager;
import org.eclipse.pde.internal.core.SourceLocationManager;
import org.eclipse.pde.internal.core.TargetDefinitionManager;
import org.eclipse.pde.internal.core.TracingOptionsManager;
import org.eclipse.pde.internal.core.builders.CompilerFlags;
import org.eclipse.pde.internal.core.builders.FeatureRebuilder;
import org.eclipse.pde.internal.core.builders.PluginRebuilder;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.osgi.framework.BundleContext;

public class PDECore
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.pde.core";
    public static final IPath REQUIRED_PLUGINS_CONTAINER_PATH = new Path("org.eclipse.pde.core.requiredPlugins");
    public static final IPath JAVA_SEARCH_CONTAINER_PATH = new Path("org.eclipse.pde.core.externalJavaSearch");
    public static final String BINARY_PROJECT_VALUE = "binary";
    public static final String BINARY_REPOSITORY_PROVIDER = "org.eclipse.pde.core.BinaryRepositoryProvider";
    public static final QualifiedName EXTERNAL_PROJECT_PROPERTY = new QualifiedName("org.eclipse.pde.core", "imported");
    public static final QualifiedName TOUCH_PROJECT = new QualifiedName("org.eclipse.pde.core", "TOUCH_PROJECT");
    public static final QualifiedName SCHEMA_PREVIEW_FILE = new QualifiedName("org.eclipse.pde.core", "SCHEMA_PREVIEW_FILE");
    private static PDECore inst;
    private static IPluginModelBase[] registryPlugins;
    private PluginModelManager fModelManager;
    private FeatureModelManager fFeatureModelManager;
    private TargetDefinitionManager fTargetProfileManager;
    private SchemaRegistry fSchemaRegistry;
    private SourceLocationManager fSourceLocationManager;
    private JavadocLocationManager fJavadocLocationManager;
    private SearchablePluginsManager fSearchablePluginsManager;
    private TracingOptionsManager fTracingOptionsManager;
    private BundleContext fBundleContext;
    private JavaElementChangeListener fJavaElementChangeListener;
    private FeatureRebuilder fFeatureRebuilder;
    private PluginRebuilder fPluginRebuilder;

    public static PDECore getDefault() {
        return inst;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public static void log(IStatus status) {
        if (status != null) {
            ResourcesPlugin.getPlugin().getLog().log(status);
        }
    }

    public static void log(Throwable e) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else if (e.getMessage() != null) {
            status = new Status(4, PLUGIN_ID, 0, e.getMessage(), e);
        }
        PDECore.log(status);
    }

    public static void logErrorMessage(String message) {
        PDECore.log((IStatus)new Status(4, PLUGIN_ID, 4, message, null));
    }

    public static void logException(Throwable e) {
        PDECore.logException(e, null);
    }

    public static void logException(Throwable e, String message) {
        if (e instanceof InvocationTargetException) {
            e = ((InvocationTargetException)e).getTargetException();
        }
        IStatus status = null;
        if (e instanceof CoreException) {
            status = ((CoreException)e).getStatus();
        } else {
            if (message == null) {
                message = e.getMessage();
            }
            if (message == null) {
                message = e.toString();
            }
            status = new Status(4, PLUGIN_ID, 0, message, e);
        }
        PDECore.log(status);
    }

    public PDECore() {
        inst = this;
    }

    public URL getInstallURL() {
        try {
            return FileLocator.resolve((URL)PDECore.getDefault().getBundle().getEntry("/"));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public IPluginModelBase findPluginInHost(String id) {
        if (registryPlugins == null) {
            URL[] pluginPaths = ConfiguratorUtils.getCurrentPlatformConfiguration().getPluginPath();
            PDEState state = new PDEState(pluginPaths, false, (IProgressMonitor)new NullProgressMonitor());
            registryPlugins = state.getTargetModels();
        }
        int i = 0;
        while (i < registryPlugins.length) {
            if (registryPlugins[i].getPluginBase().getId().equals(id)) {
                return registryPlugins[i];
            }
            ++i;
        }
        return null;
    }

    public PluginModelManager getModelManager() {
        if (this.fModelManager == null) {
            this.fModelManager = new PluginModelManager();
        }
        return this.fModelManager;
    }

    public TargetDefinitionManager getTargetProfileManager() {
        if (this.fTargetProfileManager == null) {
            this.fTargetProfileManager = new TargetDefinitionManager();
        }
        return this.fTargetProfileManager;
    }

    public FeatureModelManager getFeatureModelManager() {
        if (this.fFeatureModelManager == null) {
            this.fFeatureModelManager = new FeatureModelManager();
        }
        return this.fFeatureModelManager;
    }

    public JavaElementChangeListener getJavaElementChangeListener() {
        return this.fJavaElementChangeListener;
    }

    public SchemaRegistry getSchemaRegistry() {
        if (this.fSchemaRegistry == null) {
            this.fSchemaRegistry = new SchemaRegistry();
        }
        return this.fSchemaRegistry;
    }

    public SourceLocationManager getSourceLocationManager() {
        if (this.fSourceLocationManager == null) {
            this.fSourceLocationManager = new SourceLocationManager();
        }
        return this.fSourceLocationManager;
    }

    public JavadocLocationManager getJavadocLocationManager() {
        if (this.fJavadocLocationManager == null) {
            this.fJavadocLocationManager = new JavadocLocationManager();
        }
        return this.fJavadocLocationManager;
    }

    public TracingOptionsManager getTracingOptionsManager() {
        if (this.fTracingOptionsManager == null) {
            this.fTracingOptionsManager = new TracingOptionsManager();
        }
        return this.fTracingOptionsManager;
    }

    public SearchablePluginsManager getSearchablePluginsManager() {
        if (this.fSearchablePluginsManager == null) {
            this.fSearchablePluginsManager = new SearchablePluginsManager();
            try {
                PDECore.getWorkspace().addSaveParticipant((Plugin)inst, (ISaveParticipant)this.fSearchablePluginsManager);
            }
            catch (CoreException e) {
                PDECore.log(e);
            }
        }
        return this.fSearchablePluginsManager;
    }

    public boolean areModelsInitialized() {
        return this.fModelManager != null && this.fModelManager.isInitialized();
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.fBundleContext = context;
        CompilerFlags.initializeDefaults();
        this.fJavaElementChangeListener = new JavaElementChangeListener();
        this.fJavaElementChangeListener.start();
        this.fPluginRebuilder = new PluginRebuilder();
        this.fPluginRebuilder.start();
        this.fFeatureRebuilder = new FeatureRebuilder();
        this.fFeatureRebuilder.start();
    }

    public BundleContext getBundleContext() {
        return this.fBundleContext;
    }

    public void stop(BundleContext context) throws CoreException {
        PDECore.getDefault().savePluginPreferences();
        this.fJavaElementChangeListener.shutdown();
        this.fPluginRebuilder.stop();
        this.fFeatureRebuilder.stop();
        if (this.fSchemaRegistry != null) {
            this.fSchemaRegistry.shutdown();
            this.fSchemaRegistry = null;
        }
        if (this.fTargetProfileManager != null) {
            this.fTargetProfileManager.shutdown();
            this.fTargetProfileManager = null;
        }
        if (this.fSearchablePluginsManager != null) {
            PDECore.getWorkspace().removeSaveParticipant((Plugin)inst);
            this.fSearchablePluginsManager.shutdown();
            this.fSearchablePluginsManager = null;
        }
        if (this.fFeatureModelManager != null) {
            this.fFeatureModelManager.shutdown();
            this.fFeatureModelManager = null;
        }
        if (this.fModelManager != null) {
            this.fModelManager.shutdown();
            this.fModelManager = null;
        }
    }
}

