/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.ExternalFeatureModelManager;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDECoreMessages;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.PluginPathFinder;
import org.eclipse.pde.internal.core.TargetPlatformResetJob;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.itarget.IAdditionalLocation;
import org.eclipse.pde.internal.core.itarget.IArgumentsInfo;
import org.eclipse.pde.internal.core.itarget.IEnvironmentInfo;
import org.eclipse.pde.internal.core.itarget.IImplicitDependenciesInfo;
import org.eclipse.pde.internal.core.itarget.ILocationInfo;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.core.itarget.ITargetJRE;
import org.eclipse.pde.internal.core.itarget.ITargetPlugin;

public class LoadTargetOperation
implements IWorkspaceRunnable {
    private ITarget fTarget;
    private Map fRequiredPlugins = new HashMap();
    private List fMissingFeatures = new ArrayList();
    private IPath fPath = null;

    public LoadTargetOperation(ITarget target) {
        this(target, null);
    }

    public LoadTargetOperation(ITarget target, IPath workspaceLoc) {
        this.fTarget = target;
        this.fPath = workspaceLoc;
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        try {
            Preferences preferences = PDECore.getDefault().getPluginPreferences();
            monitor.beginTask(PDECoreMessages.LoadTargetOperation_mainTaskName, 100);
            this.loadEnvironmentInfo(preferences, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
            this.loadProgramArgs(preferences, (IProgressMonitor)new SubProgressMonitor(monitor, 5));
            this.loadJREInfo(preferences, (IProgressMonitor)new SubProgressMonitor(monitor, 15));
            this.loadImplicitPlugins(preferences, (IProgressMonitor)new SubProgressMonitor(monitor, 15));
            this.loadPlugins(preferences, (IProgressMonitor)new SubProgressMonitor(monitor, 60));
            this.loadAdditionalPreferences(preferences);
            PDECore.getDefault().savePluginPreferences();
        }
        finally {
            monitor.done();
        }
    }

    public Object[] getMissingPlugins() {
        return this.fRequiredPlugins.values().toArray();
    }

    public Object[] getMissingFeatures() {
        return this.fMissingFeatures.toArray();
    }

    protected void loadProgramArgs(Preferences pref, IProgressMonitor monitor) {
        IArgumentsInfo args = this.fTarget.getArguments();
        monitor.beginTask(PDECoreMessages.LoadTargetOperation_argsTaskName, 2);
        pref.setValue("program_args", args != null ? args.getProgramArguments() : "");
        monitor.worked(1);
        pref.setValue("vm_args", args != null ? args.getVMArguments() : "");
        monitor.done();
    }

    protected void loadEnvironmentInfo(Preferences pref, IProgressMonitor monitor) {
        IEnvironmentInfo env = this.fTarget.getEnvironment();
        monitor.beginTask(PDECoreMessages.LoadTargetOperation_envTaskName, 1);
        if (env == null) {
            pref.setToDefault("org.eclipse.pde.ui.arch");
            pref.setToDefault("org.eclipse.pde.ui.nl");
            pref.setToDefault("org.eclipse.pde.ui.os");
            pref.setToDefault("org.eclipse.pde.ui.ws");
        } else {
            pref.setValue("org.eclipse.pde.ui.arch", env.getDisplayArch());
            pref.setValue("org.eclipse.pde.ui.nl", env.getDisplayNL());
            pref.setValue("org.eclipse.pde.ui.os", env.getDisplayOS());
            pref.setValue("org.eclipse.pde.ui.ws", env.getDisplayWS());
        }
        monitor.done();
    }

    protected void loadJREInfo(Preferences pref, IProgressMonitor monitor) {
        ITargetJRE jreInfo = this.fTarget.getTargetJREInfo();
        monitor.beginTask(PDECoreMessages.LoadTargetOperation_jreTaskName, 1);
        if (jreInfo != null) {
            String jre = jreInfo.getCompatibleJRE();
            IVMInstall install = JavaRuntime.getDefaultVMInstall();
            if (install != null && !jre.equals(install.getName())) {
                try {
                    JavaRuntime.setDefaultVMInstall((IVMInstall)this.getVMInstall(jre), null);
                }
                catch (CoreException coreException) {}
            }
        }
        monitor.done();
    }

    private IVMInstall getVMInstall(String name) {
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstall[] installs = types[i].getVMInstalls();
            int k = 0;
            while (k < installs.length) {
                if (installs[i].getName().equals(name)) {
                    return installs[i];
                }
                ++k;
            }
            ++i;
        }
        return JavaRuntime.getDefaultVMInstall();
    }

    protected void loadImplicitPlugins(Preferences pref, IProgressMonitor monitor) {
        IImplicitDependenciesInfo info = this.fTarget.getImplicitPluginsInfo();
        if (info != null) {
            ITargetPlugin[] plugins = info.getPlugins();
            monitor.beginTask(PDECoreMessages.LoadTargetOperation_implicitPluginsTaskName, plugins.length + 1);
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < plugins.length) {
                buffer.append(plugins[i].getId()).append(',');
                monitor.worked(1);
                ++i;
            }
            if (plugins.length > 0) {
                buffer.setLength(buffer.length() - 1);
            }
            pref.setValue("implicit_dependencies", buffer.toString());
        }
        monitor.done();
    }

    protected void loadPlugins(Preferences pref, IProgressMonitor monitor) {
        String path;
        monitor.beginTask(PDECoreMessages.LoadTargetOperation_loadPluginsTaskName, 100);
        ILocationInfo info = this.fTarget.getLocationInfo();
        String currentPath = pref.getString("platform_path");
        if (info == null || info.useDefault()) {
            path = TargetPlatform.getDefaultLocation();
        } else {
            try {
                IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
                path = manager.performStringSubstitution(info.getPath());
            }
            catch (CoreException coreException) {
                return;
            }
        }
        monitor.worked(10);
        List additional = this.getAdditionalLocs();
        this.handleReload(path, additional, pref, (IProgressMonitor)new SubProgressMonitor(monitor, 85));
        pref.setValue("platform_path", path);
        String mode = new Path(path).equals((Object)new Path(TargetPlatform.getDefaultLocation())) ? "useThis" : "useOther";
        pref.setValue("target_mode", mode);
        ListIterator li = additional.listIterator();
        StringBuffer buffer = new StringBuffer();
        while (li.hasNext()) {
            buffer.append(li.next()).append(",");
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        pref.setValue("additional_locations", buffer.toString());
        String newValue = currentPath;
        int i = 0;
        while (i < 4) {
            String value = pref.getString("saved_platform" + i);
            pref.setValue("saved_platform" + i, newValue);
            if (value.equals(currentPath)) break;
            newValue = value;
            ++i;
        }
        monitor.done();
    }

    protected void loadAdditionalPreferences(Preferences pref) {
        if (this.fPath == null) {
            return;
        }
        String newValue = "${workspace_loc:".concat(this.fPath.toOSString()).concat("}");
        pref.setValue("target.profile", newValue);
    }

    private List getAdditionalLocs() {
        ArrayList<Object> additional = new ArrayList<Object>();
        IAdditionalLocation[] locations = this.fTarget.getAdditionalDirectories();
        IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
        int i = 0;
        while (i < locations.length) {
            try {
                additional.add(manager.performStringSubstitution(locations[i].getPath()));
            }
            catch (CoreException coreException) {
                additional.add(locations[i]);
            }
            ++i;
        }
        return additional;
    }

    private void handleReload(String targetLocation, List additionalLocations, Preferences pref, IProgressMonitor monitor) {
        monitor.beginTask(PDECoreMessages.LoadTargetOperation_reloadTaskName, 85);
        URL[] paths = this.getURLs(targetLocation, additionalLocations);
        PDEState state = new PDEState(paths, true, (IProgressMonitor)new SubProgressMonitor(monitor, 45));
        ExternalFeatureModelManager featureManager = this.getFeatureManager(targetLocation, additionalLocations);
        IFeatureModel[] models = featureManager.getModels();
        HashMap<String, IFeatureModel> features = new HashMap<String, IFeatureModel>();
        int i = 0;
        while (i < models.length) {
            features.put(models[i].getFeature().getId(), models[i]);
            ++i;
        }
        monitor.worked(5);
        models = PDECore.getDefault().getFeatureModelManager().getWorkspaceModels();
        i = 0;
        while (i < models.length) {
            features.put(models[i].getFeature().getId(), models[i]);
            ++i;
        }
        monitor.worked(5);
        this.handlePluginSelection(state, features, pref, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
        TargetPlatformResetJob job = new TargetPlatformResetJob(state);
        job.schedule();
        monitor.done();
    }

    private URL[] getURLs(String targetLocation, List additionalLocations) {
        int length = additionalLocations.size();
        File[] locations = new File[2 * length + 2];
        ListIterator li = additionalLocations.listIterator();
        while (li.hasNext()) {
            File dir;
            locations[2 * length] = dir = new File((String)li.next());
            locations[2 * length + 1] = new File(dir, "plugins");
            --length;
        }
        File targetDir = new File(targetLocation);
        locations[0] = new File(targetLocation);
        locations[1] = new File(targetDir, "plugins");
        return PluginPathFinder.scanLocations(locations);
    }

    private ExternalFeatureModelManager getFeatureManager(String targetLocation, List additionalLocations) {
        StringBuffer buffer = new StringBuffer();
        ListIterator li = additionalLocations.listIterator();
        while (li.hasNext()) {
            buffer.append(li.next()).append(',');
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        ExternalFeatureModelManager featureManager = new ExternalFeatureModelManager();
        featureManager.loadModels(targetLocation, buffer.toString());
        return featureManager;
    }

    protected IPluginModelBase[] handlePluginSelection(PDEState state, Map featureMap, Preferences pref, IProgressMonitor monitor) {
        monitor.beginTask(PDECoreMessages.LoadTargetOperation_selectPluginsTaskName, 80);
        HashSet optionalPlugins = new HashSet();
        this.getPluginIds(featureMap, null, optionalPlugins, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
        return this.handlePluginSelection(state, optionalPlugins, pref, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
    }

    protected IPluginModelBase[] handlePluginSelection(PDEState state, FeatureModelManager manager, Preferences pref, IProgressMonitor monitor) {
        monitor.beginTask(PDECoreMessages.LoadTargetOperation_selectPluginsTaskName, 80);
        HashSet optionalPlugins = new HashSet();
        this.getPluginIds(null, manager, optionalPlugins, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
        return this.handlePluginSelection(state, optionalPlugins, pref, (IProgressMonitor)new SubProgressMonitor(monitor, 40));
    }

    private IPluginModelBase[] handlePluginSelection(PDEState state, Set optionalPlugins, Preferences pref, IProgressMonitor monitor) {
        ArrayList<IPluginModelBase> changed = new ArrayList<IPluginModelBase>();
        boolean useAll = this.fTarget.useAllPlugins();
        IPluginModelBase[] models = state.getTargetModels();
        monitor.beginTask(PDECoreMessages.LoadTargetOperation_enablePluginsTaskName, models.length);
        boolean anyPluginsEnabled = false;
        int i = 0;
        while (i < models.length) {
            String id = models[i].getBundleDescription().getSymbolicName();
            if (models[i].isEnabled() != (useAll || optionalPlugins.contains(id) || this.fRequiredPlugins.containsKey(id))) {
                changed.add(models[i]);
                models[i].setEnabled(!models[i].isEnabled());
            }
            this.fRequiredPlugins.remove(id);
            if (!anyPluginsEnabled) {
                anyPluginsEnabled |= models[i].isEnabled();
            }
            monitor.worked(1);
            ++i;
        }
        if (useAll) {
            pref.setValue("checkedPlugins", "[savedAll]");
        } else if (!anyPluginsEnabled) {
            pref.setValue("checkedPlugins", "[savedNone]");
        }
        monitor.done();
        return changed.toArray(new IPluginModelBase[changed.size()]);
    }

    /*
     * Unable to fully structure code
     */
    private void getPluginIds(Map featureMap, FeatureModelManager manager, Set optionalPlugins, IProgressMonitor monitor) {
        targetFeatures = this.fTarget.getFeatures();
        plugins = this.fTarget.getPlugins();
        monitor.beginTask(PDECoreMessages.LoadTargetOperation_findPluginsTaskName, targetFeatures.length + plugins.length);
        if (this.fTarget.useAllPlugins()) {
            monitor.done();
            return;
        }
        useMap = featureMap != null;
        features = new Stack<IFeatureModel>();
        i = 0;
        while (i < targetFeatures.length) {
            block11: {
                v0 = model = useMap != false ? (IFeatureModel)featureMap.get(targetFeatures[i].getId()) : manager.findFeatureModel(targetFeatures[i].getId());
                if (model == null) break block11;
                features.push(model);
                ** GOTO lbl42
            }
            if (targetFeatures[i].isOptional()) ** GOTO lbl42
            this.fMissingFeatures.add(targetFeatures[i]);
            break;
lbl-1000:
            // 1 sources

            {
                feature = ((IFeatureModel)features.pop()).getFeature();
                featurePlugins = feature.getPlugins();
                j = 0;
                while (j < featurePlugins.length) {
                    if (targetFeatures[i].isOptional() || featurePlugins[j].isFragment()) {
                        optionalPlugins.add(featurePlugins[j].getId());
                    } else {
                        this.fRequiredPlugins.put(featurePlugins[j].getId(), featurePlugins[j]);
                    }
                    ++j;
                }
                children = feature.getIncludedFeatures();
                j = 0;
                while (j < children.length) {
                    v1 = model = useMap != false ? (IFeatureModel)featureMap.get(children[j].getId()) : manager.findFeatureModel(children[j].getId());
                    if (model != null) {
                        features.push(model);
                    }
                    ++j;
                }
lbl42:
                // 3 sources

                ** while (!features.isEmpty())
            }
lbl43:
            // 1 sources

            monitor.worked(1);
            ++i;
        }
        i = 0;
        while (i < plugins.length) {
            if (plugins[i].isOptional()) {
                optionalPlugins.add(plugins[i].getId());
            } else {
                this.fRequiredPlugins.put(plugins[i].getId(), plugins[i]);
            }
            monitor.worked(1);
            ++i;
        }
        monitor.done();
    }
}

