/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility2;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.jdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.swt.graphics.Image;

public class UnimplementedMethodsCompletionProposal
extends ASTRewriteCorrectionProposal {
    private ASTNode fTypeNode;
    private IMethodBinding[] fMethodsToOverride;

    public UnimplementedMethodsCompletionProposal(ICompilationUnit cu, ASTNode typeNode, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, (Image)null);
        this.setDisplayName(CorrectionMessages.UnimplementedMethodsCompletionProposal_description);
        this.setImage(JavaPluginImages.get("org.eclipse.jdt.ui.correction_change.gif"));
        this.fTypeNode = typeNode;
        this.fMethodsToOverride = null;
    }

    protected ASTRewrite getRewrite() throws CoreException {
        ListRewrite listRewrite;
        ITypeBinding binding;
        AnonymousClassDeclaration decl;
        AST ast = this.fTypeNode.getAST();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        if (this.fTypeNode instanceof AnonymousClassDeclaration) {
            decl = (AnonymousClassDeclaration)this.fTypeNode;
            binding = decl.resolveBinding();
            listRewrite = rewrite.getListRewrite((ASTNode)decl, AnonymousClassDeclaration.BODY_DECLARATIONS_PROPERTY);
        } else {
            decl = (AbstractTypeDeclaration)this.fTypeNode;
            binding = decl.resolveBinding();
            listRewrite = rewrite.getListRewrite((ASTNode)decl, decl.getBodyDeclarationsProperty());
        }
        IMethodBinding[] methods = StubUtility2.getUnimplementedMethods(binding);
        this.fMethodsToOverride = methods;
        CodeGenerationSettings settings = JavaPreferencesSettings.getCodeGenerationSettings(this.getCompilationUnit().getJavaProject());
        if (binding.isAnonymous()) {
            settings.createComments = false;
        }
        ImportRewrite imports = this.createImportRewrite((CompilationUnit)this.fTypeNode.getRoot());
        ContextSensitiveImportRewriteContext context = new ContextSensitiveImportRewriteContext((CompilationUnit)this.fTypeNode.getRoot(), this.fTypeNode.getStartPosition(), imports);
        int i = 0;
        while (i < methods.length) {
            MethodDeclaration newMethodDecl = StubUtility2.createImplementationStub(this.getCompilationUnit(), rewrite, imports, ast, methods[i], binding.getName(), settings, binding.isInterface(), context);
            listRewrite.insertLast((ASTNode)newMethodDecl, null);
            ++i;
        }
        return rewrite;
    }

    public String getAdditionalProposalInfo() {
        try {
            this.getChange();
            StringBuffer buf = new StringBuffer();
            buf.append("<b>");
            buf.append(Messages.format(CorrectionMessages.UnimplementedMethodsCompletionProposal_info, String.valueOf(this.fMethodsToOverride.length)));
            buf.append("</b><ul>");
            int i = 0;
            while (i < this.fMethodsToOverride.length) {
                buf.append("<li>");
                buf.append(BindingLabelProvider.getBindingLabel((IBinding)this.fMethodsToOverride[i], JavaElementLabels.ALL_FULLY_QUALIFIED));
                buf.append("</li>");
                ++i;
            }
            buf.append("</ul>");
            return buf.toString();
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
            return null;
        }
    }
}

