/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.SerialVersionLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;

public final class SerialVersionComputationHelper {
    private static final String LAUNCH_CONFIG_TYPE = "org.eclipse.jdt.ui.serial.support";
    private static final String SERIAL_SUPPORT_CLASS = "org.eclipse.jdt.internal.ui.text.correction.SerialVersionComputer";

    public static long[] computeSerialIDs(IRuntimeClasspathEntry[] classPath, IJavaProject project, String[] classNames, IProgressMonitor monitor) throws CoreException {
        long[] result;
        block7: {
            Assert.isNotNull((Object)classPath);
            Assert.isNotNull((Object)project);
            Assert.isNotNull((Object)classNames);
            Assert.isNotNull((Object)monitor);
            result = new long[]{};
            ILaunchConfigurationWorkingCopy copy = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(LAUNCH_CONFIG_TYPE).newInstance(null, LAUNCH_CONFIG_TYPE + System.currentTimeMillis());
            copy.setAttribute("org.eclipse.debug.ui.private", true);
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_DEFAULT_CLASSPATH, false);
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, SERIAL_SUPPORT_CLASS);
            StringBuffer buffer = new StringBuffer();
            int index = 0;
            while (index < classNames.length) {
                buffer.append(classNames[index]);
                buffer.append(' ');
                ++index;
            }
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, buffer.toString());
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, project.getElementName());
            ArrayList<String> mementos = new ArrayList<String>(classPath.length);
            IRuntimeClasspathEntry entry = null;
            int index2 = 0;
            while (index2 < classPath.length) {
                entry = classPath[index2];
                mementos.add(entry.getMemento());
                ++index2;
            }
            copy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_CLASSPATH, mementos);
            ILaunchConfiguration configuration = copy.doSave();
            try {
                ILaunchConfigurationDelegate delegate = configuration.getType().getDelegate("run");
                if (delegate instanceof SerialVersionLaunchConfigurationDelegate) {
                    SerialVersionLaunchConfigurationDelegate extension = (SerialVersionLaunchConfigurationDelegate)delegate;
                    configuration.launch("run", monitor, true, false);
                    result = extension.getSerialVersionIDs();
                    String message = extension.getErrorMessage();
                    if (message != null) {
                        throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, message, null));
                    }
                    break block7;
                }
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), 0, CorrectionMessages.SerialVersionHashProposal_wrong_launch_delegate, null));
            }
            finally {
                configuration.delete();
            }
        }
        return result;
    }

    private SerialVersionComputationHelper() {
    }
}

