/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.infoviews;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.javadoc.JavaDocLocations;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.infoviews.AbstractInfoView;
import org.eclipse.jdt.internal.ui.infoviews.InfoViewMessages;
import org.eclipse.jdt.internal.ui.infoviews.TextSelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.JavadocContentAccess;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.internal.text.html.HTMLPrinter;
import org.eclipse.jface.internal.text.html.HTMLTextPresenter;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IAbstractTextEditorHelpContextIds;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.osgi.framework.Bundle;

public class JavadocView
extends AbstractInfoView {
    private static final String DO_NOT_WARN_PREFERENCE_KEY = "JavadocView.error.doNotWarn";
    private static final boolean WARNING_DIALOG_ENABLED = false;
    private static final long LABEL_FLAGS = JavaElementLabels.ALL_FULLY_QUALIFIED | 0x40L | 1L | 2L | 0x10L | 0x8000L | 0x200000L;
    private Browser fBrowser;
    private StyledText fText;
    private DefaultInformationControl.IInformationPresenter fPresenter;
    private TextPresentation fPresentation = new TextPresentation();
    private SelectAllAction fSelectAllAction;
    private static String fgStyleSheet;
    private static boolean fgStyleSheetLoaded;
    private boolean fIsUsingBrowserWidget;
    private RGB fBackgroundColorRGB;
    private IPropertyChangeListener fFontListener;

    static {
        fgStyleSheetLoaded = false;
    }

    protected void internalCreatePartControl(Composite parent) {
        try {
            this.fBrowser = new Browser(parent, 0);
            this.fIsUsingBrowserWidget = true;
        }
        catch (SWTError sWTError) {
            IPreferenceStore store = JavaPlugin.getDefault().getPreferenceStore();
            store.getBoolean(DO_NOT_WARN_PREFERENCE_KEY);
            this.fIsUsingBrowserWidget = false;
        }
        if (!this.fIsUsingBrowserWidget) {
            this.fText = new StyledText(parent, 768);
            this.fText.setEditable(false);
            this.fPresenter = new HTMLTextPresenter(false);
            this.fText.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    JavadocView.this.setInput(JavadocView.this.fText.getText());
                }
            });
        }
        JavadocView.initStyleSheet();
        this.listenForFontChanges();
        this.getViewSite().setSelectionProvider((ISelectionProvider)new SelectionProvider(this.getControl()));
    }

    private void listenForFontChanges() {
        this.fFontListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("org.eclipse.jdt.ui.javadocfont".equals(event.getProperty())) {
                    fgStyleSheetLoaded = false;
                    Display display = JavadocView.this.getSite().getPage().getWorkbenchWindow().getWorkbench().getDisplay();
                    if (!display.isDisposed()) {
                        display.asyncExec(new Runnable(this, display){
                            final /* synthetic */ 3 this$1;
                            private final /* synthetic */ Display val$display;
                            {
                                this.this$1 = var1_1;
                                this.val$display = display;
                            }

                            public void run() {
                                if (!this.val$display.isDisposed()) {
                                    JavadocView.access$3();
                                    JavadocView.access$4(3.access$0(this.this$1));
                                }
                            }
                        });
                    }
                }
            }

            static /* synthetic */ JavadocView access$0(3 var0) {
                return var0.JavadocView.this;
            }
        };
        JFaceResources.getFontRegistry().addListener(this.fFontListener);
    }

    private static void initStyleSheet() {
        if (fgStyleSheetLoaded) {
            return;
        }
        fgStyleSheetLoaded = true;
        fgStyleSheet = JavadocView.loadStyleSheet();
    }

    private static String loadStyleSheet() {
        Bundle bundle = Platform.getBundle((String)JavaPlugin.getPluginId());
        URL styleSheetURL = bundle.getEntry("/JavadocViewStyleSheet.css");
        if (styleSheetURL == null) {
            return null;
        }
        try {
            styleSheetURL = FileLocator.toFileURL((URL)styleSheetURL);
            BufferedReader reader = new BufferedReader(new InputStreamReader(styleSheetURL.openStream()));
            StringBuffer buffer = new StringBuffer(200);
            String line = reader.readLine();
            while (line != null) {
                buffer.append(line);
                buffer.append('\n');
                line = reader.readLine();
            }
            FontData fontData = JFaceResources.getFontRegistry().getFontData("org.eclipse.jdt.ui.javadocfont")[0];
            return HTMLPrinter.convertTopLevelFont((String)buffer.toString(), (FontData)fontData);
        }
        catch (IOException ex) {
            JavaPlugin.log(ex);
            return null;
        }
    }

    protected void createActions() {
        super.createActions();
        this.fSelectAllAction = new SelectAllAction(this.getControl(), (SelectionProvider)this.getSelectionProvider());
    }

    protected IAction getSelectAllAction() {
        if (this.fIsUsingBrowserWidget) {
            return null;
        }
        return this.fSelectAllAction;
    }

    protected IAction getCopyToClipboardAction() {
        if (this.fIsUsingBrowserWidget) {
            return null;
        }
        return super.getCopyToClipboardAction();
    }

    protected void setForeground(Color color) {
        this.getControl().setForeground(color);
    }

    protected void setBackground(Color color) {
        this.getControl().setBackground(color);
        this.fBackgroundColorRGB = color.getRGB();
        this.refresh();
    }

    private void refresh() {
        IJavaElement input = this.getInput();
        if (input == null) {
            StringBuffer buffer = new StringBuffer("");
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (RGB)this.fBackgroundColorRGB, (String)fgStyleSheet);
            this.setInput(buffer.toString());
        } else {
            this.setInput(this.computeInput(input));
        }
    }

    protected String getBackgroundColorKey() {
        return "org.eclipse.jdt.ui.JavadocView.backgroundColor";
    }

    protected void internalDispose() {
        this.fText = null;
        this.fBrowser = null;
        if (this.fFontListener != null) {
            JFaceResources.getFontRegistry().removeListener(this.fFontListener);
            this.fFontListener = null;
        }
    }

    public void setFocus() {
        this.getControl().setFocus();
    }

    protected Object computeInput(Object input) {
        String javadocHtml;
        if (this.getControl() == null || !(input instanceof IJavaElement)) {
            return null;
        }
        IJavaElement je = (IJavaElement)input;
        switch (je.getElementType()) {
            case 5: {
                try {
                    javadocHtml = this.getJavadocHtml((IJavaElement[])((ICompilationUnit)je).getTypes());
                }
                catch (JavaModelException javaModelException) {
                    javadocHtml = null;
                }
                break;
            }
            case 6: {
                javadocHtml = this.getJavadocHtml(new IJavaElement[]{((IClassFile)je).getType()});
                break;
            }
            default: {
                javadocHtml = this.getJavadocHtml(new IJavaElement[]{je});
            }
        }
        if (javadocHtml == null) {
            return "";
        }
        return javadocHtml;
    }

    protected void setInput(Object input) {
        String javadocHtml = (String)input;
        if (this.fIsUsingBrowserWidget) {
            if (javadocHtml != null && javadocHtml.length() > 0) {
                boolean RTL;
                boolean bl = RTL = (this.getSite().getShell().getStyle() & 0x4000000) != 0;
                if (RTL) {
                    StringBuffer buffer = new StringBuffer(javadocHtml);
                    HTMLPrinter.insertStyles((StringBuffer)buffer, (String[])new String[]{"direction:rtl"});
                    javadocHtml = buffer.toString();
                }
            }
            this.fBrowser.setText(javadocHtml);
        } else {
            this.fPresentation.clear();
            Rectangle size = this.fText.getClientArea();
            try {
                javadocHtml = ((DefaultInformationControl.IInformationPresenterExtension)this.fPresenter).updatePresentation((Drawable)this.getSite().getShell(), javadocHtml, this.fPresentation, size.width, size.height);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return;
            }
            this.fText.setText(javadocHtml);
            TextPresentation.applyTextPresentation((TextPresentation)this.fPresentation, (StyledText)this.fText);
        }
    }

    private String getJavadocHtml(IJavaElement[] result) {
        StringBuffer buffer = new StringBuffer();
        int nResults = result.length;
        if (nResults == 0) {
            return null;
        }
        if (nResults > 1) {
            int i = 0;
            while (i < result.length) {
                HTMLPrinter.startBulletList((StringBuffer)buffer);
                IJavaElement curr = result[i];
                if (curr instanceof IMember) {
                    HTMLPrinter.addBullet((StringBuffer)buffer, (String)this.getInfoText((IMember)curr));
                }
                HTMLPrinter.endBulletList((StringBuffer)buffer);
                ++i;
            }
        } else {
            IJavaElement curr = result[0];
            if (curr instanceof IMember) {
                Reader reader;
                IMember member = (IMember)curr;
                try {
                    reader = JavadocContentAccess.getHTMLContentReader(member, true, true);
                    if (reader == null && member.isBinary()) {
                        boolean hasSource;
                        boolean hasAttachedJavadoc = JavaDocLocations.getJavadocBaseLocation((IJavaElement)member) != null;
                        IPackageFragmentRoot root = (IPackageFragmentRoot)member.getAncestor(3);
                        boolean hasAttachedSource = root != null && root.getSourceAttachmentPath() != null;
                        IOpenable openable = member.getOpenable();
                        boolean bl = hasSource = openable.getBuffer() != null;
                        if (!hasAttachedSource && !hasAttachedJavadoc) {
                            reader = new StringReader(InfoViewMessages.JavadocView_noAttachments);
                        } else if (!hasAttachedJavadoc && !hasSource) {
                            reader = new StringReader(InfoViewMessages.JavadocView_noAttachedJavadoc);
                        } else if (!hasAttachedSource) {
                            reader = new StringReader(InfoViewMessages.JavadocView_noAttachedSource);
                        } else if (!hasSource) {
                            reader = new StringReader(InfoViewMessages.JavadocView_noInformation);
                        }
                    }
                }
                catch (JavaModelException ex) {
                    reader = new StringReader(InfoViewMessages.JavadocView_error_gettingJavadoc);
                    JavaPlugin.log(ex.getStatus());
                }
                if (reader != null) {
                    HTMLPrinter.addParagraph((StringBuffer)buffer, (Reader)reader);
                }
            }
        }
        boolean flushContent = true;
        if (buffer.length() > 0 || flushContent) {
            HTMLPrinter.insertPageProlog((StringBuffer)buffer, (int)0, (RGB)this.fBackgroundColorRGB, (String)fgStyleSheet);
            HTMLPrinter.addPageEpilog((StringBuffer)buffer);
            return buffer.toString();
        }
        return null;
    }

    private String getInfoText(IMember member) {
        return JavaElementLabels.getElementLabel((IJavaElement)member, LABEL_FLAGS);
    }

    protected boolean isIgnoringNewInput(IJavaElement je, IWorkbenchPart part, ISelection selection) {
        if (super.isIgnoringNewInput(je, part, selection) && part instanceof ITextEditor && selection instanceof ITextSelection) {
            ITextEditor editor = (ITextEditor)part;
            IDocumentProvider docProvider = editor.getDocumentProvider();
            if (docProvider == null) {
                return false;
            }
            IDocument document = docProvider.getDocument((Object)editor.getEditorInput());
            if (!(document instanceof IDocumentExtension3)) {
                return false;
            }
            try {
                int offset = ((ITextSelection)selection).getOffset();
                String partition = ((IDocumentExtension3)document).getContentType("___java_partitioning", offset, false);
                return partition != "__java_javadoc";
            }
            catch (BadPartitioningException badPartitioningException) {
                return false;
            }
            catch (BadLocationException badLocationException) {
                return false;
            }
        }
        return false;
    }

    protected IJavaElement findSelectedJavaElement(IWorkbenchPart part, ISelection selection) {
        IJavaElement element;
        block7: {
            IDocument document;
            ITextSelection textSelection;
            block9: {
                IDocumentProvider documentProvider;
                JavaEditor editor;
                block8: {
                    element = super.findSelectedJavaElement(part, selection);
                    if (element != null || !(part instanceof JavaEditor) || !(selection instanceof ITextSelection)) break block7;
                    editor = (JavaEditor)part;
                    textSelection = (ITextSelection)selection;
                    documentProvider = editor.getDocumentProvider();
                    if (documentProvider != null) break block8;
                    return null;
                }
                document = documentProvider.getDocument((Object)editor.getEditorInput());
                if (document != null) break block9;
                return null;
            }
            ITypedRegion typedRegion = TextUtilities.getPartition((IDocument)document, (String)"___java_partitioning", (int)textSelection.getOffset(), (boolean)false);
            if ("__java_javadoc".equals(typedRegion.getType())) {
                return TextSelectionConverter.getElementAtOffset((JavaEditor)part, textSelection);
            }
            return null;
        }
        try {
            return element;
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    protected Control getControl() {
        if (this.fIsUsingBrowserWidget) {
            return this.fBrowser;
        }
        return this.fText;
    }

    protected String getHelpContextId() {
        return "org.eclipse.jdt.ui.javadoc_view_context";
    }

    static /* synthetic */ void access$3() {
        JavadocView.initStyleSheet();
    }

    static /* synthetic */ void access$4(JavadocView javadocView) {
        javadocView.refresh();
    }

    private class SelectAllAction
    extends Action {
        private Control fControl;
        private SelectionProvider fSelectionProvider;

        public SelectAllAction(Control control, SelectionProvider selectionProvider) {
            super("selectAll");
            Assert.isNotNull((Object)control);
            Assert.isNotNull((Object)selectionProvider);
            this.fControl = control;
            this.fSelectionProvider = selectionProvider;
            this.setEnabled(!JavadocView.this.fIsUsingBrowserWidget);
            this.setText(InfoViewMessages.SelectAllAction_label);
            this.setToolTipText(InfoViewMessages.SelectAllAction_tooltip);
            this.setDescription(InfoViewMessages.SelectAllAction_description);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, IAbstractTextEditorHelpContextIds.SELECT_ALL_ACTION);
        }

        public void run() {
            if (this.fControl instanceof StyledText) {
                ((StyledText)this.fControl).selectAll();
            } else if (this.fSelectionProvider != null) {
                this.fSelectionProvider.fireSelectionChanged();
            }
        }
    }

    private static class SelectionProvider
    implements ISelectionProvider {
        private ListenerList fListeners = new ListenerList(1);
        private Control fControl;

        public SelectionProvider(Control control) {
            Assert.isNotNull((Object)control);
            this.fControl = control;
            if (this.fControl instanceof StyledText) {
                ((StyledText)this.fControl).addSelectionListener((SelectionListener)new SelectionAdapter(this){
                    final /* synthetic */ SelectionProvider this$1;
                    {
                        this.this$1 = selectionProvider;
                    }

                    public void widgetSelected(SelectionEvent e) {
                        this.this$1.fireSelectionChanged();
                    }
                });
            }
        }

        public void fireSelectionChanged() {
            ISelection selection = this.getSelection();
            SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
            Object[] selectionChangedListeners = this.fListeners.getListeners();
            int i = 0;
            while (i < selectionChangedListeners.length) {
                ((ISelectionChangedListener)selectionChangedListeners[i]).selectionChanged(event);
                ++i;
            }
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.add((Object)listener);
        }

        public ISelection getSelection() {
            if (this.fControl instanceof StyledText) {
                Document document = new Document(((StyledText)this.fControl).getSelectionText());
                return new TextSelection((IDocument)document, 0, document.getLength());
            }
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
        }
    }
}

