/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.AbstractJavaElementRenameChange;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public final class RenamePackageChange
extends AbstractJavaElementRenameChange {
    private Map fCompilationUnitStamps;
    private final boolean fRenameSubpackages;

    private static IPath createPath(String packageName) {
        return new Path(packageName.replace('.', '/'));
    }

    public RenamePackageChange(IPackageFragment pack, String newName, boolean renameSubpackages) {
        this(pack.getPath(), pack.getElementName(), newName, -1L, null, renameSubpackages);
        Assert.isTrue((!pack.isReadOnly() ? 1 : 0) != 0, (String)"package must not be read only");
    }

    private RenamePackageChange(IPath resourcePath, String oldName, String newName, long stampToRestore, Map compilationUnitStamps, boolean renameSubpackages) {
        super(resourcePath, oldName, newName, stampToRestore);
        this.fCompilationUnitStamps = compilationUnitStamps;
        this.fRenameSubpackages = renameSubpackages;
    }

    private void addStamps(Map stamps, ICompilationUnit[] units) {
        int i = 0;
        while (i < units.length) {
            IResource resource = units[i].getResource();
            long stamp = -1L;
            if (resource != null && (stamp = resource.getModificationStamp()) != -1L) {
                stamps.put(resource, new Long(stamp));
            }
            ++i;
        }
    }

    protected IPath createNewPath() {
        IPackageFragment oldPackage = this.getPackage();
        IPath oldPackageName = RenamePackageChange.createPath(oldPackage.getElementName());
        IPath newPackageName = RenamePackageChange.createPath(this.getNewName());
        return this.getResourcePath().removeLastSegments(oldPackageName.segmentCount()).append(newPackageName);
    }

    protected IPath createNewPath(IPackageFragment oldPackage) {
        IPath oldPackagePath = RenamePackageChange.createPath(oldPackage.getElementName());
        IPath newPackagePath = RenamePackageChange.createPath(this.getNewName(oldPackage));
        return oldPackage.getPath().removeLastSegments(oldPackagePath.segmentCount()).append(newPackagePath);
    }

    protected Change createUndoChange(long stampToRestore) throws CoreException {
        IPackageFragment pack = this.getPackage();
        if (pack == null) {
            return new NullChange();
        }
        HashMap stamps = new HashMap();
        if (!this.fRenameSubpackages) {
            this.addStamps(stamps, pack.getCompilationUnits());
        } else {
            IPackageFragment[] allPackages = JavaElementUtil.getPackageAndSubpackages(pack);
            int i = 0;
            while (i < allPackages.length) {
                IPackageFragment currentPackage = allPackages[i];
                this.addStamps(stamps, currentPackage.getCompilationUnits());
                ++i;
            }
        }
        return new RenamePackageChange(this.createNewPath(), this.getNewName(), this.getOldName(), stampToRestore, stamps, this.fRenameSubpackages);
    }

    protected void doRename(IProgressMonitor pm) throws CoreException {
        IPackageFragment pack = this.getPackage();
        if (pack == null) {
            return;
        }
        if (!this.fRenameSubpackages) {
            this.renamePackage(pack, pm, this.createNewPath(), this.getNewName());
        } else {
            IPackageFragment[] allPackages = JavaElementUtil.getPackageAndSubpackages(pack);
            pm.beginTask("", allPackages.length);
            try {
                int i = 0;
                while (i < allPackages.length) {
                    IPackageFragment currentPackage = allPackages[i];
                    this.renamePackage(currentPackage, (IProgressMonitor)new SubProgressMonitor(pm, 1), this.createNewPath(currentPackage), this.getNewName(currentPackage));
                    ++i;
                }
            }
            finally {
                pm.done();
            }
        }
    }

    public String getName() {
        String msg = this.fRenameSubpackages ? RefactoringCoreMessages.RenamePackageChange_name_with_subpackages : RefactoringCoreMessages.RenamePackageChange_name;
        return Messages.format(msg, new String[]{this.getOldName(), this.getNewName()});
    }

    private String getNewName(IPackageFragment subpackage) {
        return String.valueOf(this.getNewName()) + subpackage.getElementName().substring(this.getOldName().length());
    }

    private IPackageFragment getPackage() {
        return (IPackageFragment)this.getModifiedElement();
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result;
        pm.beginTask("", 2);
        try {
            result = new RefactoringStatus();
            IJavaElement element = (IJavaElement)this.getModifiedElement();
            result.merge(this.isValid((IProgressMonitor)new SubProgressMonitor(pm, 1), 2));
            if (result.hasFatalError()) {
                RefactoringStatus refactoringStatus = result;
                return refactoringStatus;
            }
            if (element != null && element.exists() && element instanceof IPackageFragment) {
                IPackageFragment pack = (IPackageFragment)element;
                if (this.fRenameSubpackages) {
                    IPackageFragment[] allPackages = JavaElementUtil.getPackageAndSubpackages(pack);
                    SubProgressMonitor subPm = new SubProgressMonitor(pm, 1);
                    subPm.beginTask("", allPackages.length);
                    int i = 0;
                    while (i < allPackages.length) {
                        RenamePackageChange.checkIfModifiable(result, allPackages[i], 2);
                        if (result.hasFatalError()) {
                            RefactoringStatus refactoringStatus = result;
                            return refactoringStatus;
                        }
                        this.isValid(result, allPackages[i], (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)subPm, 1));
                        ++i;
                    }
                } else {
                    this.isValid(result, pack, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                }
            }
        }
        finally {
            pm.done();
        }
        return result;
    }

    private void isValid(RefactoringStatus result, IPackageFragment pack, IProgressMonitor pm) throws JavaModelException {
        ICompilationUnit[] units = pack.getCompilationUnits();
        pm.beginTask("", units.length);
        int i = 0;
        while (i < units.length) {
            pm.subTask(Messages.format(RefactoringCoreMessages.RenamePackageChange_checking_change, pack.getElementName()));
            RenamePackageChange.checkIfModifiable(result, units[i], 3);
            pm.worked(1);
            ++i;
        }
        pm.done();
    }

    private void renamePackage(IPackageFragment pack, IProgressMonitor pm, IPath newPath, String newName) throws JavaModelException, CoreException {
        IPackageFragment newPack;
        pack.rename(newName, false, pm);
        if (this.fCompilationUnitStamps != null && (newPack = (IPackageFragment)JavaCore.create((IFolder)ResourcesPlugin.getWorkspace().getRoot().getFolder(newPath))).exists()) {
            ICompilationUnit[] units = newPack.getCompilationUnits();
            int i = 0;
            while (i < units.length) {
                Long stamp;
                IResource resource = units[i].getResource();
                if (resource != null && (stamp = (Long)this.fCompilationUnitStamps.get(resource)) != null) {
                    resource.revertModificationStamp(stamp.longValue());
                }
                ++i;
            }
        }
    }
}

