/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.ui.launcher;

import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class OSGiLaunchConfigurationInitializer {
    protected static final String DEFAULT = "default";

    public void initialize(ILaunchConfigurationWorkingCopy configuration) {
        this.initializeFrameworkDefaults(configuration);
        this.initializeBundleState(configuration);
        this.initializeSourcePathProvider(configuration);
    }

    protected void initializeSourcePathProvider(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_SOURCE_PATH_PROVIDER, "org.eclipse.pde.ui.workbenchClasspathProvider");
    }

    protected void initializeFrameworkDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("default_auto_start", true);
        configuration.setAttribute("default_start_level", 4);
    }

    protected void initializeBundleState(ILaunchConfigurationWorkingCopy configuration) {
        StringBuffer explugins = new StringBuffer();
        StringBuffer wsplugins = new StringBuffer();
        IPluginModelBase[] models = PluginRegistry.getActiveModels();
        int i = 0;
        while (i < models.length) {
            String id = models[i].getPluginBase().getId();
            boolean inWorkspace = models[i].getUnderlyingResource() != null;
            this.appendBundle(inWorkspace ? wsplugins : explugins, id);
            ++i;
        }
        configuration.setAttribute("workspace_bundles", wsplugins.toString());
        configuration.setAttribute("target_bundles", explugins.toString());
        configuration.setAttribute("automaticAdd", true);
    }

    private void appendBundle(StringBuffer buffer, String bundleID) {
        if (buffer.length() > 0) {
            buffer.append(",");
        }
        buffer.append(bundleID);
        buffer.append("@");
        buffer.append(this.getStartLevel(bundleID));
        buffer.append(":");
        buffer.append(this.getAutoStart(bundleID));
    }

    protected String getStartLevel(String bundleID) {
        return DEFAULT;
    }

    protected String getAutoStart(String bundleID) {
        return DEFAULT;
    }
}

