/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ISharedExtensionsModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.search.dependencies.AddNewDependenciesOperation;
import org.eclipse.pde.internal.ui.search.dependencies.CalculateUsesOperation;
import org.eclipse.pde.internal.ui.search.dependencies.GatherUnusedDependenciesOperation;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.pde.internal.ui.wizards.tools.IOrganizeManifestsSettings;
import org.eclipse.pde.internal.ui.wizards.tools.OrganizeManifest;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class OrganizeManifestsOperation
implements IRunnableWithProgress,
IOrganizeManifestsSettings {
    protected boolean fAddMissing = true;
    protected boolean fMarkInternal = true;
    protected String fPackageFilter = "*.internal*";
    protected boolean fRemoveUnresolved = true;
    protected boolean fCalculateUses = false;
    protected boolean fModifyDep = true;
    protected boolean fRemoveDependencies = true;
    protected boolean fUnusedDependencies;
    protected boolean fRemoveLazy = true;
    protected boolean fPrefixIconNL;
    protected boolean fUnusedKeys;
    protected boolean fAddDependencies;
    private ArrayList fProjectList;
    private IProject fCurrentProject;

    public OrganizeManifestsOperation(ArrayList projectList) {
        this.fProjectList = projectList;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        monitor.beginTask(PDEUIMessages.OrganizeManifestJob_taskName, this.fProjectList.size());
        int i = 0;
        while (i < this.fProjectList.size() && !monitor.isCanceled()) {
            this.cleanProject((IProject)this.fProjectList.get(i), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ++i;
        }
    }

    private void cleanProject(IProject project, IProgressMonitor monitor) {
        this.fCurrentProject = project;
        monitor.beginTask(this.fCurrentProject.getName(), this.getTotalTicksPerProject());
        final Exception[] ee = new Exception[1];
        ModelModification modification = new ModelModification(this.fCurrentProject){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (model instanceof IBundlePluginModelBase) {
                    try {
                        OrganizeManifestsOperation.this.runCleanup(monitor, (IBundlePluginModelBase)model);
                    }
                    catch (InvocationTargetException e) {
                        ee[0] = e;
                    }
                    catch (InterruptedException e) {
                        ee[0] = e;
                    }
                }
            }
        };
        PDEModelUtility.modifyModel(modification, monitor);
        if (ee[0] != null) {
            PDEPlugin.log(ee[0]);
        }
    }

    private void runCleanup(IProgressMonitor monitor, IBundlePluginModelBase modelBase) throws InvocationTargetException, InterruptedException {
        WorkspaceModifyOperation op;
        IBundle bundle = modelBase.getBundleModel().getBundle();
        ISharedExtensionsModel sharedExtensionsModel = modelBase.getExtensionsModel();
        IPluginModelBase extensionsModel = null;
        if (sharedExtensionsModel instanceof IPluginModelBase) {
            extensionsModel = (IPluginModelBase)sharedExtensionsModel;
        }
        String projectName = this.fCurrentProject.getName();
        if (this.fAddMissing || this.fRemoveUnresolved) {
            monitor.subTask(NLS.bind((String)PDEUIMessages.OrganizeManifestsOperation_export, (Object)projectName));
            if (!monitor.isCanceled()) {
                OrganizeManifest.organizeExportPackages(bundle, this.fCurrentProject, this.fAddMissing, this.fRemoveUnresolved);
            }
            if (this.fAddMissing) {
                monitor.worked(1);
            }
            if (this.fRemoveUnresolved) {
                monitor.worked(1);
            }
        }
        if (this.fMarkInternal) {
            monitor.subTask(NLS.bind((String)PDEUIMessages.OrganizeManifestsOperation_filterInternal, (Object)projectName));
            if (!monitor.isCanceled()) {
                OrganizeManifest.markPackagesInternal(bundle, this.fPackageFilter);
            }
            monitor.worked(1);
        }
        if (this.fModifyDep) {
            String message = this.fRemoveDependencies ? NLS.bind((String)PDEUIMessages.OrganizeManifestsOperation_removeUnresolved, (Object)projectName) : NLS.bind((String)PDEUIMessages.OrganizeManifestsOperation_markOptionalUnresolved, (Object)projectName);
            monitor.subTask(message);
            if (!monitor.isCanceled()) {
                OrganizeManifest.organizeImportPackages(bundle, this.fRemoveDependencies);
            }
            monitor.worked(1);
            if (!monitor.isCanceled()) {
                OrganizeManifest.organizeRequireBundles(bundle, this.fRemoveDependencies);
            }
            monitor.worked(1);
        }
        if (this.fCalculateUses && !monitor.isCanceled()) {
            op = new CalculateUsesOperation(this.fCurrentProject, modelBase);
            op.run((IProgressMonitor)new SubProgressMonitor(monitor, 2));
        }
        if (this.fAddDependencies) {
            monitor.subTask(NLS.bind((String)PDEUIMessages.OrganizeManifestsOperation_additionalDeps, (Object)projectName));
            if (!monitor.isCanceled()) {
                op = new AddNewDependenciesOperation(this.fCurrentProject, modelBase);
                op.run((IProgressMonitor)new SubProgressMonitor(monitor, 4));
            }
        }
        if (this.fUnusedDependencies) {
            monitor.subTask(NLS.bind((String)PDEUIMessages.OrganizeManifestsOperation_unusedDeps, (Object)projectName));
            if (!monitor.isCanceled()) {
                SubProgressMonitor submon = new SubProgressMonitor(monitor, 4);
                GatherUnusedDependenciesOperation udo = new GatherUnusedDependenciesOperation((IPluginModelBase)modelBase);
                udo.run((IProgressMonitor)submon);
                GatherUnusedDependenciesOperation.removeDependencies((IPluginModelBase)modelBase, udo.getList().toArray());
                submon.done();
            }
        }
        if (this.fRemoveLazy) {
            monitor.subTask(NLS.bind((String)PDEUIMessages.OrganizeManifestsOperation_lazyStart, (Object)this.fCurrentProject.getName()));
            if (!monitor.isCanceled()) {
                OrganizeManifest.removeUnneededLazyStart(bundle);
            }
            monitor.worked(1);
        }
        if (this.fPrefixIconNL) {
            monitor.subTask(NLS.bind((String)PDEUIMessages.OrganizeManifestsOperation_nlIconPath, (Object)projectName));
            if (!monitor.isCanceled()) {
                OrganizeManifest.prefixIconPaths(extensionsModel);
            }
            monitor.worked(1);
        }
        if (this.fUnusedKeys) {
            monitor.subTask(NLS.bind((String)PDEUIMessages.OrganizeManifestsOperation_unusedKeys, (Object)projectName));
            if (!monitor.isCanceled()) {
                OrganizeManifest.removeUnusedKeys(this.fCurrentProject, bundle, extensionsModel);
            }
            monitor.worked(1);
        }
    }

    private int getTotalTicksPerProject() {
        int ticks = 0;
        if (this.fAddMissing) {
            ++ticks;
        }
        if (this.fMarkInternal) {
            ++ticks;
        }
        if (this.fRemoveUnresolved) {
            ++ticks;
        }
        if (this.fCalculateUses) {
            ticks += 4;
        }
        if (this.fModifyDep) {
            ticks += 2;
        }
        if (this.fUnusedDependencies) {
            ticks += 4;
        }
        if (this.fAddDependencies) {
            ticks += 4;
        }
        if (this.fRemoveLazy) {
            ++ticks;
        }
        if (this.fPrefixIconNL) {
            ++ticks;
        }
        if (this.fUnusedKeys) {
            ++ticks;
        }
        return ticks;
    }

    public void setOperations(IDialogSettings settings) {
        this.fAddMissing = !settings.getBoolean("OrganizeManifests.ExportedPackages.addMissing");
        this.fMarkInternal = !settings.getBoolean("OrganizeManifests.ExportedPackages.makeInternal");
        this.fPackageFilter = settings.get("OrganizeManifests.ExportedPackages.packageFilter");
        this.fRemoveUnresolved = !settings.getBoolean("OrganizeManifests.ExportedPackages.removeUnresolved");
        this.fCalculateUses = settings.getBoolean("OrganizeManifests.calculateUses");
        this.fModifyDep = !settings.getBoolean("OrganizeManifests.RequireImport.modifyDep");
        this.fRemoveDependencies = !settings.getBoolean("OrganizeManifests.RequireImport.resolve:markOptional");
        this.fUnusedDependencies = settings.getBoolean("OrganizeManifests.RequireImport.findRemoveUnused");
        this.fRemoveLazy = !settings.getBoolean("OrganizeManifests.General.cleanup");
        this.fPrefixIconNL = settings.getBoolean("OrganizeManifests.Translation.nls");
        this.fUnusedKeys = settings.getBoolean("OrganizeManifests.Translation.unusedKeys");
        this.fAddDependencies = settings.getBoolean("OrganizeManifests.AddDependencies");
    }
}

