/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelFactory;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.bundle.WorkspaceBundlePluginModel;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.core.util.IdUtil;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.pde.internal.ui.wizards.plugin.ClasspathComputer;
import org.eclipse.pde.internal.ui.wizards.tools.OrganizeManifest;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class ConvertedProjectsPage
extends WizardPage {
    private CheckboxTableViewer projectViewer;
    private TablePart tablePart;
    private IProject[] fSelected;
    private IProject[] fUnconverted;
    private String fLibraryName;
    private String[] fSrcEntries;
    private String[] fLibEntries;

    public ConvertedProjectsPage(IProject[] projects, Vector initialSelection) {
        super("convertedProjects");
        this.setTitle(PDEUIMessages.ConvertedProjectWizard_title);
        this.setDescription(PDEUIMessages.ConvertedProjectWizard_desc);
        this.tablePart = new TablePart(PDEUIMessages.ConvertedProjectWizard_projectList);
        this.fSelected = initialSelection.toArray(new IProject[initialSelection.size()]);
        this.fUnconverted = projects;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 5;
        container.setLayout((Layout)layout);
        this.tablePart.createControl(container);
        this.projectViewer = this.tablePart.getTableViewer();
        this.projectViewer.setContentProvider((IContentProvider)new ProjectContentProvider());
        this.projectViewer.setLabelProvider((IBaseLabelProvider)new ProjectLabelProvider());
        this.projectViewer.setInput((Object)PDEPlugin.getWorkspace());
        this.tablePart.setSelection(this.fSelected);
        this.tablePart.updateCounter(this.fSelected.length);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.converted_projects");
    }

    private String createInitialName(String id) {
        int loc = id.lastIndexOf(46);
        if (loc == -1) {
            return id;
        }
        StringBuffer buf = new StringBuffer(id.substring(loc + 1));
        buf.setCharAt(0, Character.toUpperCase(buf.charAt(0)));
        return buf.toString();
    }

    private void createManifestFile(IFile file, IProgressMonitor monitor) throws CoreException {
        boolean missingInfo;
        WorkspaceBundlePluginModel model = new WorkspaceBundlePluginModel(file, null);
        model.load();
        IBundle pluginBundle = model.getBundleModel().getBundle();
        String pluginId = pluginBundle.getHeader("Bundle-SymbolicName");
        String pluginName = pluginBundle.getHeader("Bundle-Name");
        String pluginVersion = pluginBundle.getHeader("Bundle-Version");
        boolean bl = missingInfo = pluginId == null || pluginName == null || pluginVersion == null;
        if (pluginId == null) {
            pluginId = IdUtil.getValidId((String)file.getProject().getName());
        }
        if (pluginVersion == null) {
            pluginVersion = "1.0.0";
        }
        if (pluginName == null) {
            pluginName = this.createInitialName(pluginId);
        }
        pluginBundle.setHeader("Bundle-SymbolicName", pluginId);
        pluginBundle.setHeader("Bundle-Version", pluginVersion);
        pluginBundle.setHeader("Bundle-Name", pluginName);
        if (missingInfo) {
            IPluginModelFactory factory = model.getPluginFactory();
            IPluginBase base = model.getPluginBase();
            if (this.fLibraryName != null && !this.fLibraryName.equals(".")) {
                IPluginLibrary library = factory.createLibrary();
                library.setName(this.fLibraryName);
                library.setExported(true);
                base.add(library);
            }
            int i = 0;
            while (i < this.fLibEntries.length) {
                IPluginLibrary library = factory.createLibrary();
                library.setName(this.fLibEntries[i]);
                library.setExported(true);
                base.add(library);
                ++i;
            }
            if (TargetPlatformHelper.getTargetVersion() >= 3.1) {
                pluginBundle.setHeader("Bundle-ManifestVersion", "2");
            }
        }
        model.save();
        monitor.done();
        this.organizeExports(file.getProject());
    }

    private boolean isOldTarget() {
        return TargetPlatformHelper.getTargetVersion() < 3.1;
    }

    public boolean finish() {
        final Object[] selected = this.tablePart.getSelection();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                try {
                    try {
                        ConvertedProjectsPage.this.convertProjects(selected, monitor);
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                        monitor.done();
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException e) {
            PDEPlugin.logException(e);
            return false;
        }
        return true;
    }

    public void convertProject(IProject project, IProgressMonitor monitor) throws CoreException {
        CoreUtility.addNatureToProject((IProject)project, (String)"org.eclipse.pde.PluginNature", (IProgressMonitor)monitor);
        this.loadClasspathEntries(project, monitor);
        this.loadLibraryName(project);
        this.createManifestFile(project.getFile("META-INF/MANIFEST.MF"), monitor);
        IFile buildFile = project.getFile("build.properties");
        if (!buildFile.exists()) {
            WorkspaceBuildModel model = new WorkspaceBuildModel(buildFile);
            IBuild build = model.getBuild(true);
            IBuildEntry entry = model.getFactory().createEntry("bin.includes");
            if (project.getFile("plugin.xml").exists()) {
                entry.addToken("plugin.xml");
            }
            if (project.getFile("META-INF/MANIFEST.MF").exists()) {
                entry.addToken("META-INF/");
            }
            int i = 0;
            while (i < this.fLibEntries.length) {
                entry.addToken(this.fLibEntries[i]);
                ++i;
            }
            if (this.fSrcEntries.length > 0) {
                entry.addToken(this.fLibraryName);
                IBuildEntry source = model.getFactory().createEntry("source." + this.fLibraryName);
                int i2 = 0;
                while (i2 < this.fSrcEntries.length) {
                    source.addToken(this.fSrcEntries[i2]);
                    ++i2;
                }
                build.add(source);
            }
            if (entry.getTokens().length > 0) {
                build.add(entry);
            }
            model.save();
        }
    }

    private void convertProjects(Object[] selected, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(PDEUIMessages.ConvertedProjectWizard_converting, selected.length);
        int i = 0;
        while (i < selected.length) {
            this.convertProject((IProject)selected[i], monitor);
            monitor.worked(1);
            ++i;
        }
        monitor.done();
    }

    private void loadClasspathEntries(IProject project, IProgressMonitor monitor) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] currentClassPath = new IClasspathEntry[]{};
        ArrayList<String> sources = new ArrayList<String>();
        ArrayList<String> libraries = new ArrayList<String>();
        try {
            currentClassPath = javaProject.getRawClasspath();
        }
        catch (JavaModelException javaModelException) {}
        int i = 0;
        while (i < currentClassPath.length) {
            int contentType = currentClassPath[i].getEntryKind();
            if (contentType == 3) {
                String relativePath = this.getRelativePath(currentClassPath[i], project);
                if (relativePath.equals("")) {
                    sources.add(".");
                } else {
                    sources.add(String.valueOf(relativePath) + "/");
                }
            } else if (contentType == 1) {
                String path = this.getRelativePath(currentClassPath[i], project);
                if (path.length() > 0) {
                    libraries.add(path);
                } else {
                    libraries.add(".");
                }
            }
            ++i;
        }
        this.fSrcEntries = sources.toArray(new String[sources.size()]);
        this.fLibEntries = libraries.toArray(new String[libraries.size()]);
        IClasspathEntry[] classPath = new IClasspathEntry[currentClassPath.length + 1];
        System.arraycopy(currentClassPath, 0, classPath, 0, currentClassPath.length);
        classPath[classPath.length - 1] = ClasspathComputer.createContainerEntry();
        try {
            javaProject.setRawClasspath(classPath, monitor);
        }
        catch (JavaModelException javaModelException) {}
    }

    private String getRelativePath(IClasspathEntry cpe, IProject project) {
        IPath path = project.getFile(cpe.getPath()).getProjectRelativePath();
        return path.removeFirstSegments(1).toString();
    }

    private void loadLibraryName(IProject project) {
        if (this.isOldTarget() || this.fLibEntries.length > 0 && this.fSrcEntries.length > 0) {
            String libName = project.getName();
            int i = libName.lastIndexOf(".");
            if (i != -1) {
                libName = libName.substring(i + 1);
            }
            this.fLibraryName = String.valueOf(libName) + ".jar";
        } else {
            this.fLibraryName = ".";
        }
    }

    private void organizeExports(final IProject project) {
        PDEModelUtility.modifyModel(new ModelModification(project.getFile("META-INF/MANIFEST.MF")){

            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (!(model instanceof IBundlePluginModelBase)) {
                    return;
                }
                OrganizeManifest.organizeExportPackages(((IBundlePluginModelBase)model).getBundleModel().getBundle(), project, true, true);
            }
        }, null);
    }

    public class ProjectContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        public Object[] getElements(Object parent) {
            if (ConvertedProjectsPage.this.fUnconverted != null) {
                return ConvertedProjectsPage.this.fUnconverted;
            }
            return new Object[0];
        }
    }

    public class ProjectLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public String getColumnText(Object obj, int index) {
            if (index == 0) {
                return ((IProject)obj).getName();
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
        }
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart(String mainLabel) {
            super(mainLabel);
        }

        public void updateCounter(int count) {
            super.updateCounter(count);
            ConvertedProjectsPage.this.setPageComplete(count > 0);
        }
    }
}

