/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.internal.core.FeatureModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.wizards.exports.ExportOptionsTab;
import org.eclipse.pde.internal.ui.wizards.exports.FeatureExportWizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;

public class FeatureOptionsTab
extends ExportOptionsTab {
    private static final String S_MULTI_PLATFORM = "multiplatform";
    private Button fMultiPlatform;

    public FeatureOptionsTab(FeatureExportWizardPage page) {
        super(page);
    }

    protected void addCrossPlatformOption(Composite comp) {
        FeatureModelManager manager = PDECore.getDefault().getFeatureModelManager();
        IFeatureModel model = manager.findFeatureModel("org.eclipse.platform.launchers");
        if (model != null) {
            this.fMultiPlatform = new Button(comp, 32);
            this.fMultiPlatform.setText(PDEUIMessages.ExportWizard_multi_platform);
        }
    }

    protected boolean getInitialJarButtonSelection(IDialogSettings settings) {
        return settings.getBoolean("exportUpdate");
    }

    protected String getJarButtonText() {
        return PDEUIMessages.BaseExportWizardPage_fPackageJARs;
    }

    protected void initialize(IDialogSettings settings) {
        super.initialize(settings);
        if (this.fMultiPlatform != null) {
            this.fMultiPlatform.setSelection(settings.getBoolean(S_MULTI_PLATFORM));
        }
    }

    protected void saveSettings(IDialogSettings settings) {
        super.saveSettings(settings);
        if (this.fMultiPlatform != null) {
            settings.put(S_MULTI_PLATFORM, this.fMultiPlatform.getSelection());
        }
    }

    protected void hookListeners() {
        super.hookListeners();
        if (this.fMultiPlatform != null) {
            this.fMultiPlatform.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FeatureOptionsTab.this.fPage.pageChanged();
                }
            });
        }
    }

    protected boolean doMultiplePlatform() {
        return this.fMultiPlatform != null && this.fMultiPlatform.getSelection();
    }
}

