/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.refactoring;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.core.text.IDocumentAttribute;
import org.eclipse.pde.internal.core.text.plugin.FragmentModel;
import org.eclipse.pde.internal.core.text.plugin.PluginModel;
import org.eclipse.pde.internal.core.text.plugin.PluginNode;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class PluginManifestChange {
    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Change createRenameChange(IFile file, Object[] affectedElements, String[] newNames, TextChange textChange, IProgressMonitor monitor) throws CoreException {
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        try {
            MultiTextEdit multiEdit;
            block17: {
                TextEdit edit;
                void var9_11;
                manager.connect(file.getFullPath(), monitor);
                ITextFileBuffer buffer = manager.getTextFileBuffer(file.getFullPath());
                multiEdit = new MultiTextEdit();
                IDocument document = buffer.getDocument();
                try {
                    if ("fragment.xml".equals(file.getName())) {
                        FragmentModel fragmentModel = new FragmentModel(document, false);
                    } else {
                        PluginModel pluginModel = new PluginModel(document, false);
                    }
                    var9_11.load();
                    if (!var9_11.isLoaded()) {
                        return null;
                    }
                }
                catch (CoreException coreException) {
                    return null;
                }
                int i = 0;
                block7: while (true) {
                    PluginNode plugin;
                    IDocumentAttribute attr;
                    TextEdit edit2;
                    if (i >= affectedElements.length) {
                        if (!multiEdit.hasChildren()) return null;
                        if (textChange != null) {
                            edit = textChange.getEdit();
                            if (!(edit instanceof MultiTextEdit)) break;
                            ((MultiTextEdit)edit).addChild((TextEdit)multiEdit);
                            multiEdit = (MultiTextEdit)edit;
                        }
                        break block17;
                    }
                    if (var9_11 instanceof PluginModel && affectedElements[i] instanceof IJavaElement && (edit2 = PluginManifestChange.createTextEdit(attr = (plugin = (PluginNode)var9_11.getPluginBase()).getDocumentAttribute("class"), (IJavaElement)affectedElements[i], newNames[i])) != null) {
                        multiEdit.addChild(edit2);
                    }
                    SchemaRegistry registry = PDECore.getDefault().getSchemaRegistry();
                    IPluginExtension[] extensions = var9_11.getPluginBase().getExtensions();
                    int j = 0;
                    while (true) {
                        if (j >= extensions.length) {
                            ++i;
                            continue block7;
                        }
                        ISchema schema = registry.getSchema(extensions[j].getPoint());
                        if (schema != null) {
                            PluginManifestChange.addExtensionAttributeEdit(schema, (IPluginParent)extensions[j], multiEdit, affectedElements[i], newNames[i]);
                        }
                        ++j;
                    }
                    break;
                }
                multiEdit.addChild(edit);
            }
            TextFileChange change = new TextFileChange("", file);
            change.setEdit((TextEdit)multiEdit);
            TextFileChange textFileChange = change;
            return textFileChange;
        }
        finally {
            manager.disconnect(file.getFullPath(), monitor);
        }
    }

    private static void addExtensionAttributeEdit(ISchema schema, IPluginParent parent, MultiTextEdit multi, Object element, String newName) {
        IPluginObject[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            IPluginElement child = (IPluginElement)children[i];
            ISchemaElement schemaElement = schema.findElement(child.getName());
            if (schemaElement != null) {
                IPluginAttribute[] attributes = child.getAttributes();
                int j = 0;
                while (j < attributes.length) {
                    IPluginAttribute attr = attributes[j];
                    ISchemaAttribute attInfo = schemaElement.getAttribute(attr.getName());
                    if (attInfo != null) {
                        TextEdit edit;
                        IDocumentAttribute docAttr;
                        if (element instanceof IJavaElement && attInfo.getKind() == 1) {
                            docAttr = (IDocumentAttribute)attr;
                            edit = PluginManifestChange.createTextEdit(docAttr, (IJavaElement)element, newName);
                            if (edit != null) {
                                multi.addChild(edit);
                            }
                        } else if (element instanceof IResource && attInfo.getKind() == 2 && (edit = PluginManifestChange.createTextEdit(docAttr = (IDocumentAttribute)attr, (IResource)element, newName)) != null) {
                            multi.addChild(edit);
                        }
                    }
                    ++j;
                }
            }
            PluginManifestChange.addExtensionAttributeEdit(schema, (IPluginParent)child, multi, element, newName);
            ++i;
        }
    }

    private static TextEdit createTextEdit(IDocumentAttribute attr, IJavaElement element, String newName) {
        int offset;
        String value;
        if (attr == null) {
            return null;
        }
        String oldName = element instanceof IType ? ((IType)element).getFullyQualifiedName('$') : element.getElementName();
        if ((oldName.equals(value = attr.getAttributeValue()) || PluginManifestChange.isGoodMatch(value, oldName, element instanceof IPackageFragment)) && (offset = attr.getValueOffset()) >= 0) {
            return new ReplaceEdit(offset, oldName.length(), newName);
        }
        return null;
    }

    private static TextEdit createTextEdit(IDocumentAttribute attr, IResource resource, String newName) {
        int offset;
        String value;
        String oldName;
        if (attr != null && ((oldName = resource.getProjectRelativePath().toString()).equals(value = attr.getAttributeValue()) || resource instanceof IContainer && PluginManifestChange.isGoodFolderMatch(value, oldName)) && (offset = attr.getValueOffset()) >= 0) {
            return new ReplaceEdit(offset, oldName.length(), newName);
        }
        return null;
    }

    private static boolean isGoodMatch(String value, String oldName, boolean isPackage) {
        boolean goodLengthMatch;
        if (value == null || value.length() <= oldName.length()) {
            return false;
        }
        boolean bl = isPackage ? value.lastIndexOf(46) <= oldName.length() : (goodLengthMatch = value.charAt(oldName.length()) == '$');
        return value.startsWith(oldName) && goodLengthMatch;
    }

    private static boolean isGoodFolderMatch(String value, String oldName) {
        return new Path(oldName).isPrefixOf((IPath)new Path(value));
    }
}

