/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import java.util.Dictionary;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.IModelProviderEvent;
import org.eclipse.pde.internal.core.MinimalState;
import org.eclipse.pde.internal.core.ModelProviderEvent;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEState;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.itarget.IEnvironmentInfo;
import org.eclipse.pde.internal.core.itarget.ITarget;
import org.eclipse.pde.internal.core.itarget.ITargetJRE;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.VMHelper;
import org.eclipse.pde.internal.ui.preferences.TargetPlatformPreferencePage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class TargetEnvironmentTab {
    private Combo fOSCombo;
    private Combo fWSCombo;
    private Combo fNLCombo;
    private Combo fArchCombo;
    private Preferences preferences;
    private TreeSet fNLChoices;
    private TreeSet fOSChoices;
    private TreeSet fWSChoices;
    private TreeSet fArchChoices;
    private Combo fJRECombo;
    private static boolean LOCALES_INITIALIZED = false;
    private String fDefaultJRE;
    private TargetPlatformPreferencePage fPage;

    public TargetEnvironmentTab(TargetPlatformPreferencePage page) {
        this.fPage = page;
        this.preferences = PDECore.getDefault().getPluginPreferences();
    }

    private void initializeChoices() {
        this.fOSChoices = new TreeSet();
        String[] os = Platform.knownOSValues();
        int i = 0;
        while (i < os.length) {
            this.fOSChoices.add(os[i]);
            ++i;
        }
        this.addExtraChoices(this.fOSChoices, this.preferences.getString("org.eclipse.pde.os.extra"));
        this.fWSChoices = new TreeSet();
        String[] ws = Platform.knownWSValues();
        int i2 = 0;
        while (i2 < ws.length) {
            this.fWSChoices.add(ws[i2]);
            ++i2;
        }
        this.addExtraChoices(this.fWSChoices, this.preferences.getString("org.eclipse.pde.ws.extra"));
        this.fArchChoices = new TreeSet();
        String[] arch = Platform.knownOSArchValues();
        int i3 = 0;
        while (i3 < arch.length) {
            this.fArchChoices.add(arch[i3]);
            ++i3;
        }
        this.addExtraChoices(this.fArchChoices, this.preferences.getString("org.eclipse.pde.arch.extra"));
        this.fNLChoices = new TreeSet();
        if (LOCALES_INITIALIZED) {
            this.initializeAllLocales();
        } else {
            this.fNLChoices.add(this.expandLocaleName(this.preferences.getString("org.eclipse.pde.ui.nl")));
        }
    }

    protected void updateChoices() {
        if (LOCALES_INITIALIZED) {
            return;
        }
        String current = this.fNLCombo.getText();
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    TargetEnvironmentTab.this.initializeAllLocales();
                    LOCALES_INITIALIZED = true;
                }
            });
        }
        catch (InvocationTargetException e) {
            PDEPlugin.log(e);
        }
        catch (InterruptedException e) {
            PDEPlugin.log(e);
        }
        if (!this.fNLCombo.isDisposed()) {
            this.fNLCombo.setItems(this.fNLChoices.toArray(new String[this.fNLChoices.size()]));
            this.fNLCombo.setText(current);
        }
    }

    private void initializeAllLocales() {
        String[] nl = TargetEnvironmentTab.getLocales();
        int i = 0;
        while (i < nl.length) {
            this.fNLChoices.add(nl[i]);
            ++i;
        }
        this.addExtraChoices(this.fNLChoices, this.preferences.getString("org.eclipse.pde.nl.extra"));
    }

    private void addExtraChoices(Set set, String preference) {
        StringTokenizer tokenizer = new StringTokenizer(preference, ",");
        while (tokenizer.hasMoreTokens()) {
            set.add(tokenizer.nextToken().trim());
        }
    }

    public Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 15;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        this.createTargetEnvironmentGroup(container);
        this.createJREGroup(container);
        Dialog.applyDialogFont((Control)container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, "org.eclipse.pde.doc.user.target_environment_preference_page");
        return container;
    }

    private void createJREGroup(Composite container) {
        Group group = new Group(container, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText(PDEUIMessages.EnvironmentBlock_jreTitle);
        Label label = new Label((Composite)group, 0);
        label.setText(PDEUIMessages.EnvironmentBlock_jreGroup);
        this.fJRECombo = new Combo((Composite)group, 12);
        this.fJRECombo.setLayoutData((Object)new GridData(768));
        this.fJRECombo.setItems(VMHelper.getVMInstallNames());
        this.fDefaultJRE = VMHelper.getDefaultVMInstallName();
        this.fJRECombo.setText(this.fDefaultJRE);
        label = new Label((Composite)group, 64);
        label.setText(PDEUIMessages.EnvironmentBlock_jreNote);
        GridData gd = new GridData();
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 25;
        gd.widthHint = 400;
        label.setLayoutData((Object)gd);
    }

    private void createTargetEnvironmentGroup(Composite container) {
        Group group = new Group(container, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        group.setText(PDEUIMessages.EnvironmentBlock_targetEnv);
        this.initializeChoices();
        Label label = new Label((Composite)group, 0);
        label.setText(PDEUIMessages.Preferences_TargetEnvironmentPage_os);
        this.fOSCombo = new Combo((Composite)group, 2052);
        this.fOSCombo.setLayoutData((Object)new GridData(768));
        this.fOSCombo.setItems(this.fOSChoices.toArray(new String[this.fOSChoices.size()]));
        label = new Label((Composite)group, 0);
        label.setText(PDEUIMessages.Preferences_TargetEnvironmentPage_ws);
        this.fWSCombo = new Combo((Composite)group, 2052);
        this.fWSCombo.setLayoutData((Object)new GridData(768));
        this.fWSCombo.setItems(this.fWSChoices.toArray(new String[this.fWSChoices.size()]));
        label = new Label((Composite)group, 0);
        label.setText(PDEUIMessages.Preferences_TargetEnvironmentPage_arch);
        this.fArchCombo = new Combo((Composite)group, 2052);
        this.fArchCombo.setLayoutData((Object)new GridData(768));
        this.fArchCombo.setItems(this.fArchChoices.toArray(new String[this.fArchChoices.size()]));
        label = new Label((Composite)group, 0);
        label.setText(PDEUIMessages.Preferences_TargetEnvironmentPage_nl);
        this.fNLCombo = new Combo((Composite)group, 2052);
        this.fNLCombo.setLayoutData((Object)new GridData(768));
        this.fNLCombo.setItems(this.fNLChoices.toArray(new String[this.fNLChoices.size()]));
        this.fOSCombo.setText(this.preferences.getString("org.eclipse.pde.ui.os"));
        this.fWSCombo.setText(this.preferences.getString("org.eclipse.pde.ui.ws"));
        this.fNLCombo.setText(this.expandLocaleName(this.preferences.getString("org.eclipse.pde.ui.nl")));
        this.fArchCombo.setText(this.preferences.getString("org.eclipse.pde.ui.arch"));
    }

    protected void loadTargetProfile(ITarget target) {
        this.loadTargetProfileEnvironment(target.getEnvironment());
        this.loadTargetProfileJRE(target.getTargetJREInfo());
    }

    private void loadTargetProfileEnvironment(IEnvironmentInfo info) {
        if (info == null) {
            return;
        }
        String os = info.getDisplayOS();
        String ws = info.getDisplayWS();
        String arch = info.getDisplayArch();
        String nl = info.getDisplayNL();
        nl = this.expandLocaleName(nl);
        if (!os.equals("")) {
            if (this.fOSCombo.indexOf(os) == -1) {
                this.fOSCombo.add(os);
            }
            this.fOSCombo.setText(os);
        }
        if (!ws.equals("")) {
            if (this.fWSCombo.indexOf(ws) == -1) {
                this.fWSCombo.add(ws);
            }
            this.fWSCombo.setText(ws);
        }
        if (!arch.equals("")) {
            if (this.fArchCombo.indexOf(arch) == -1) {
                this.fArchCombo.add(arch);
            }
            this.fArchCombo.setText(arch);
        }
        if (!nl.equals("")) {
            if (this.fNLCombo.indexOf(nl) == -1) {
                this.fNLCombo.add(nl);
            }
            this.fNLCombo.setText(nl);
        }
    }

    private void loadTargetProfileJRE(ITargetJRE info) {
        if (info != null) {
            this.fJRECombo.setText(info.getCompatibleJRE());
        }
    }

    protected void performDefaults() {
        this.fOSCombo.setText(this.preferences.getDefaultString("org.eclipse.pde.ui.os"));
        this.fWSCombo.setText(this.preferences.getDefaultString("org.eclipse.pde.ui.ws"));
        this.fNLCombo.setText(this.expandLocaleName(this.preferences.getDefaultString("org.eclipse.pde.ui.nl")));
        this.fArchCombo.setText(this.preferences.getDefaultString("org.eclipse.pde.ui.arch"));
        this.fJRECombo.setText(VMHelper.getDefaultVMInstallName());
    }

    public boolean performOk() {
        this.applyTargetEnvironmentGroup();
        this.applyJREGroup();
        return true;
    }

    private void applyJREGroup() {
        try {
            if (!this.fDefaultJRE.equals(VMHelper.getDefaultVMInstallName())) {
                return;
            }
            if (!VMHelper.getDefaultVMInstallName().equals(this.fJRECombo.getText())) {
                JavaRuntime.setDefaultVMInstall((IVMInstall)VMHelper.getVMInstall(this.fJRECombo.getText()), null);
            }
        }
        catch (CoreException coreException) {}
    }

    private void applyTargetEnvironmentGroup() {
        String locale;
        String arch;
        String ws;
        String oldOS = this.preferences.getString("org.eclipse.pde.ui.os");
        String oldWS = this.preferences.getString("org.eclipse.pde.ui.ws");
        String oldARCH = this.preferences.getString("org.eclipse.pde.ui.arch");
        String oldNL = this.preferences.getString("org.eclipse.pde.ui.nl");
        boolean changed = false;
        String os = this.fOSCombo.getText().trim();
        if (os.length() > 0) {
            if (!this.fOSChoices.contains(os)) {
                String value = this.preferences.getString("org.eclipse.pde.os.extra");
                value = value.length() > 0 ? String.valueOf(value) + "," + os : os;
                this.preferences.setValue("org.eclipse.pde.os.extra", value);
            }
            this.preferences.setValue("org.eclipse.pde.ui.os", os);
            changed |= !os.equals(oldOS);
        }
        if ((ws = this.fWSCombo.getText().trim()).length() > 0) {
            if (!this.fWSChoices.contains(ws)) {
                String value = this.preferences.getString("org.eclipse.pde.ws.extra");
                value = value.length() > 0 ? String.valueOf(value) + "," + ws : ws;
                this.preferences.setValue("org.eclipse.pde.ws.extra", value);
            }
            this.preferences.setValue("org.eclipse.pde.ui.ws", ws);
            changed |= !ws.equals(oldWS);
        }
        if ((arch = this.fArchCombo.getText().trim()).length() > 0) {
            if (!this.fArchChoices.contains(arch)) {
                String value = this.preferences.getString("org.eclipse.pde.arch.extra");
                value = value.length() > 0 ? String.valueOf(value) + "," + arch : arch;
                this.preferences.setValue("org.eclipse.pde.arch.extra", value);
            }
            this.preferences.setValue("org.eclipse.pde.ui.arch", arch);
            changed |= !arch.equals(oldARCH);
        }
        if ((locale = this.fNLCombo.getText().trim()).length() > 0) {
            int dash;
            if (!this.fNLChoices.contains(locale)) {
                String value = this.preferences.getString("org.eclipse.pde.nl.extra");
                value = value.length() > 0 ? String.valueOf(value) + "," + locale : locale;
                this.preferences.setValue("org.eclipse.pde.nl.extra", value);
            }
            if ((dash = locale.indexOf("-")) != -1) {
                locale = locale.substring(0, dash);
            }
            locale = locale.trim();
            this.preferences.setValue("org.eclipse.pde.ui.nl", locale);
            changed |= !locale.equals(oldNL);
        }
        PDECore.getDefault().savePluginPreferences();
        if (changed) {
            this.updateState();
        }
    }

    private void updateState() {
        PDEState state = this.fPage.getCurrentState();
        String[] knownExecutionEnvironments = TargetPlatformHelper.getKnownExecutionEnvironments();
        Dictionary[] properties = TargetPlatformHelper.getPlatformProperties((String[])knownExecutionEnvironments, (MinimalState)this.fPage.getCurrentState());
        state.getState().setPlatformProperties(properties);
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        if (manager.getState() == state) {
            manager.modelsChanged((IModelProviderEvent)new ModelProviderEvent((Object)properties, 16, null, null, null));
        }
    }

    private String expandLocaleName(String name) {
        String language = "";
        String country = "";
        String variant = "";
        StringTokenizer tokenizer = new StringTokenizer(name, "_");
        if (tokenizer.hasMoreTokens()) {
            language = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            country = tokenizer.nextToken();
        }
        if (tokenizer.hasMoreTokens()) {
            variant = tokenizer.nextToken();
        }
        Locale locale = new Locale(language, country, variant);
        return String.valueOf(locale.toString()) + " - " + locale.getDisplayName();
    }

    private static String[] getLocales() {
        Locale[] locales = Locale.getAvailableLocales();
        String[] result = new String[locales.length];
        int i = 0;
        while (i < locales.length) {
            Locale locale = locales[i];
            StringBuffer buffer = new StringBuffer();
            buffer.append(locale.toString());
            buffer.append(" - ");
            buffer.append(locale.getDisplayName());
            result[i] = buffer.toString();
            ++i;
        }
        return result;
    }
}

