/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.nls;

public class StringHelper {
    protected static String preparePropertiesString(String s, char[] newLine) {
        if (s == null) {
            return null;
        }
        int length = s.length();
        int nlLength = newLine.length;
        StringBuffer sb = new StringBuffer(length + nlLength);
        int i = 0;
        while (i < length) {
            char c = s.charAt(i);
            if (i + nlLength < length) {
                boolean notNewLine = false;
                int j = 0;
                while (j < nlLength) {
                    if (s.charAt(i + j) != newLine[j]) {
                        notNewLine = true;
                    }
                    ++j;
                }
                if (!notNewLine) {
                    sb.append("\\");
                }
            }
            sb.append(c);
            ++i;
        }
        return sb.toString();
    }

    protected static String unwindEscapeChars(String s) {
        if (s != null) {
            int length = s.length();
            StringBuffer sb = new StringBuffer(length);
            int i = 0;
            while (i < length) {
                char c = s.charAt(i);
                sb.append(StringHelper.getUnwoundString(c));
                ++i;
            }
            return sb.toString();
        }
        return null;
    }

    protected static String getUnwoundString(char c) {
        switch (c) {
            case '\b': {
                return "\\b";
            }
            case '\t': {
                return "\\t";
            }
            case '\n': {
                return "\\n";
            }
            case '\f': {
                return "\\f";
            }
            case '\r': {
                return "\\r";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return String.valueOf(c);
    }

    protected static String windEscapeChars(String s) {
        if (s == null) {
            return null;
        }
        int len = s.length();
        StringBuffer outBuffer = new StringBuffer(len);
        int x = 0;
        while (x < len) {
            char aChar;
            if ((aChar = s.charAt(x++)) == '\\') {
                if ((aChar = s.charAt(x++)) == 'u') {
                    int value = 0;
                    int i = 0;
                    while (i < 4) {
                        aChar = s.charAt(x++);
                        switch (aChar) {
                            case '0': 
                            case '1': 
                            case '2': 
                            case '3': 
                            case '4': 
                            case '5': 
                            case '6': 
                            case '7': 
                            case '8': 
                            case '9': {
                                value = (value << 4) + aChar - 48;
                                break;
                            }
                            case 'a': 
                            case 'b': 
                            case 'c': 
                            case 'd': 
                            case 'e': 
                            case 'f': {
                                value = (value << 4) + 10 + aChar - 97;
                                break;
                            }
                            case 'A': 
                            case 'B': 
                            case 'C': 
                            case 'D': 
                            case 'E': 
                            case 'F': {
                                value = (value << 4) + 10 + aChar - 65;
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException("Malformed \\uxxxx encoding.");
                            }
                        }
                        ++i;
                    }
                    outBuffer.append((char)value);
                    continue;
                }
                if (aChar == 't') {
                    outBuffer.append('\t');
                    continue;
                }
                if (aChar == 'r') {
                    outBuffer.append('\r');
                    continue;
                }
                if (aChar == 'n') {
                    outBuffer.append('\n');
                    continue;
                }
                if (aChar == 'f') {
                    outBuffer.append('\f');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            outBuffer.append(aChar);
        }
        return outBuffer.toString();
    }

    protected static boolean isValidLocalization(String name) {
        if (name.length() <= 0) {
            return false;
        }
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (!(c >= 'A' && 'Z' >= c || c >= 'a' && 'z' >= c || c >= '0' && '9' >= c || c == '_' || c == '-' || c == '/')) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

