/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.jdt.launching.environments.IExecutionEnvironmentsManager;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.LauncherUtils;

public class VMHelper {
    public static IVMInstall[] getAllVMInstances() {
        ArrayList<IVMInstall> res = new ArrayList<IVMInstall>();
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstall[] installs = types[i].getVMInstalls();
            int k = 0;
            while (k < installs.length) {
                res.add(installs[k]);
                ++k;
            }
            ++i;
        }
        return res.toArray(new IVMInstall[res.size()]);
    }

    public static String[] getVMInstallNames() {
        IVMInstall[] installs = VMHelper.getAllVMInstances();
        String[] names = new String[installs.length];
        int i = 0;
        while (i < installs.length) {
            names[i] = installs[i].getName();
            ++i;
        }
        return names;
    }

    public static String getDefaultVMInstallName() {
        IVMInstall install = JavaRuntime.getDefaultVMInstall();
        if (install != null) {
            return install.getName();
        }
        return null;
    }

    public static String getDefaultVMInstallLocation() {
        IVMInstall install = JavaRuntime.getDefaultVMInstall();
        if (install != null) {
            return install.getInstallLocation().getAbsolutePath();
        }
        return null;
    }

    public static IVMInstall getVMInstall(ILaunchConfiguration configuration) throws CoreException {
        String vm = configuration.getAttribute("vminstall", null);
        return VMHelper.getVMInstall(vm);
    }

    public static IVMInstall getVMInstall(String name) {
        if (name != null) {
            IVMInstall[] installs = VMHelper.getAllVMInstances();
            int i = 0;
            while (i < installs.length) {
                if (installs[i].getName().equals(name)) {
                    return installs[i];
                }
                ++i;
            }
        }
        return JavaRuntime.getDefaultVMInstall();
    }

    public static IVMInstall createLauncher(ILaunchConfiguration configuration) throws CoreException {
        String vm = configuration.getAttribute("vminstall", null);
        IVMInstall launcher = VMHelper.getVMInstall(vm);
        if (launcher == null) {
            throw new CoreException(LauncherUtils.createErrorStatus(NLS.bind((String)PDEUIMessages.WorkbenchLauncherConfigurationDelegate_noJRE, (Object)vm)));
        }
        if (!launcher.getInstallLocation().exists()) {
            throw new CoreException(LauncherUtils.createErrorStatus(PDEUIMessages.WorkbenchLauncherConfigurationDelegate_jrePathNotFound));
        }
        return launcher;
    }

    public static IExecutionEnvironment[] getExecutionEnvironments() {
        IExecutionEnvironmentsManager manager = JavaRuntime.getExecutionEnvironmentsManager();
        return manager.getExecutionEnvironments();
    }
}

