/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ArchiveSourceContainer;
import org.eclipse.debug.core.sourcelookup.containers.ExternalArchiveSourceContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaReferenceType;
import org.eclipse.jdt.debug.core.IJavaStackFrame;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.ModelEntry;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.PDEClasspathContainer;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;

public class PDESourceLookupQuery
implements ISafeRunnable {
    protected static String OSGI_CLASSLOADER = "org.eclipse.osgi.internal.baseadaptor.DefaultClassLoader";
    private static String LEGACY_ECLIPSE_CLASSLOADER = "org.eclipse.core.runtime.adaptor.EclipseClassLoader";
    private static String MAIN_CLASS = "org.eclipse.core.launcher.Main";
    private static String MAIN_PLUGIN = "org.eclipse.platform";
    private Object fElement;
    private Object fResult;

    public PDESourceLookupQuery(Object object) {
        this.fElement = object;
    }

    public void handleException(Throwable exception) {
    }

    public void run() throws Exception {
        IJavaReferenceType type;
        IJavaObject classLoaderObject = null;
        String declaringTypeName = null;
        String sourcePath = null;
        if (this.fElement instanceof IJavaStackFrame) {
            IJavaStackFrame stackFrame = (IJavaStackFrame)this.fElement;
            classLoaderObject = stackFrame.getReferenceType().getClassLoaderObject();
            declaringTypeName = stackFrame.getDeclaringTypeName();
            sourcePath = PDESourceLookupQuery.generateSourceName(declaringTypeName);
        } else if (this.fElement instanceof IJavaObject) {
            IJavaObject object = (IJavaObject)this.fElement;
            IJavaReferenceType type2 = (IJavaReferenceType)object.getJavaType();
            classLoaderObject = type2.getClassLoaderObject();
            if (object.getJavaType() != null) {
                declaringTypeName = object.getJavaType().getName();
            }
            if (declaringTypeName != null) {
                sourcePath = PDESourceLookupQuery.generateSourceName(declaringTypeName);
            }
        } else if (this.fElement instanceof IJavaReferenceType) {
            type = (IJavaReferenceType)this.fElement;
            classLoaderObject = type.getClassLoaderObject();
            declaringTypeName = type.getName();
            sourcePath = PDESourceLookupQuery.generateSourceName(declaringTypeName);
        }
        if (classLoaderObject != null) {
            IPluginModelBase model;
            type = (IJavaClassType)classLoaderObject.getJavaType();
            if (OSGI_CLASSLOADER.equals(type.getName())) {
                this.fResult = this.findSourceElement(classLoaderObject, sourcePath);
            } else if (LEGACY_ECLIPSE_CLASSLOADER.equals(type.getName())) {
                this.fResult = this.findSourceElement_legacy(classLoaderObject, sourcePath);
            } else if (MAIN_CLASS.equals(declaringTypeName) && (model = PDECore.getDefault().getModelManager().findModel(MAIN_PLUGIN)) != null) {
                this.fResult = this.getSourceElement(model.getInstallLocation(), MAIN_PLUGIN, sourcePath);
            }
        }
    }

    protected Object getResult() {
        return this.fResult;
    }

    private String getValue(IJavaObject object, String variable) throws DebugException {
        IJavaFieldVariable var = object.getField(variable, false);
        return var == null ? null : var.getValue().getValueString();
    }

    protected Object findSourceElement(IJavaObject object, String typeName) throws CoreException {
        IJavaObject data;
        IJavaObject manager = this.getObject(object, "manager", false);
        if (manager != null && (data = this.getObject(manager, "data", false)) != null) {
            String location = this.getValue(data, "fileName");
            String id = this.getValue(data, "symbolicName");
            return this.getSourceElement(location, id, typeName);
        }
        return null;
    }

    private IJavaObject getObject(IJavaObject object, String field, boolean superfield) throws DebugException {
        IValue value;
        IJavaFieldVariable variable = object.getField(field, superfield);
        if (variable != null && (value = variable.getValue()) instanceof IJavaObject) {
            return (IJavaObject)value;
        }
        return null;
    }

    private Object findSourceElement_legacy(IJavaObject object, String typeName) throws CoreException {
        IJavaObject hostdata = this.getObject(object, "hostdata", true);
        if (hostdata != null) {
            String location = this.getValue(hostdata, "fileName");
            String id = this.getValue(hostdata, "symbolicName");
            return this.getSourceElement(location, id, typeName);
        }
        return null;
    }

    private Object getSourceElement(String location, String id, String typeName) throws CoreException {
        if (location != null && id != null) {
            Object result = this.findSourceElement(this.getSourceContainers(location, id), typeName);
            if (result != null) {
                return result;
            }
            State state = TargetPlatformHelper.getState();
            BundleDescription desc = state.getBundle(id, null);
            if (desc != null) {
                BundleDescription[] fragments = desc.getFragments();
                int i = 0;
                while (i < fragments.length) {
                    location = fragments[i].getLocation();
                    result = this.findSourceElement(this.getSourceContainers(location, id = fragments[i].getSymbolicName()), typeName);
                    if (result != null) {
                        return result;
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    private Object findSourceElement(ISourceContainer[] containers, String typeName) throws CoreException {
        int i = 0;
        while (i < containers.length) {
            Object[] result = containers[i].findSourceElements(typeName);
            if (result.length > 0) {
                return result[0];
            }
            ++i;
        }
        return null;
    }

    protected ISourceContainer[] getSourceContainers(String location, String id) throws CoreException {
        ArrayList<IRuntimeClasspathEntry> result = new ArrayList<IRuntimeClasspathEntry>();
        ModelEntry entry = PluginRegistry.findEntry((String)id);
        boolean match = false;
        IPluginModelBase[] models = entry.getWorkspaceModels();
        int i = 0;
        while (i < models.length) {
            if (this.isPerfectMatch(models[i], (IPath)new Path(location))) {
                IResource resource = models[i].getUnderlyingResource();
                if (resource != null) {
                    this.addProjectSourceContainers(resource.getProject(), result);
                }
                match = true;
                break;
            }
            ++i;
        }
        if (!match) {
            ISourceContainer container;
            File file = new File(location);
            if (file.isFile() && (container = this.getArchiveSourceContainer(location)) != null) {
                return new ISourceContainer[]{container};
            }
            models = entry.getExternalModels();
            int i2 = 0;
            while (i2 < models.length) {
                if (this.isPerfectMatch(models[i2], (IPath)new Path(location))) {
                    IClasspathEntry[] entries = PDEClasspathContainer.getExternalEntries((IPluginModelBase)models[i2]);
                    int j = 0;
                    while (j < entries.length) {
                        IRuntimeClasspathEntry rte = this.convertClasspathEntry(entries[j]);
                        if (rte != null) {
                            result.add(rte);
                        }
                        ++j;
                    }
                    break;
                }
                ++i2;
            }
        }
        IRuntimeClasspathEntry[] entries = result.toArray(new IRuntimeClasspathEntry[result.size()]);
        return JavaRuntime.getSourceContainers((IRuntimeClasspathEntry[])entries);
    }

    private void addProjectSourceContainers(IProject project, ArrayList result) throws CoreException {
        if (project == null || !project.hasNature("org.eclipse.jdt.core.javanature")) {
            return;
        }
        IJavaProject jProject = JavaCore.create((IProject)project);
        result.add(JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)jProject));
        IClasspathEntry[] entries = jProject.getRawClasspath();
        int i = 0;
        while (i < entries.length) {
            IRuntimeClasspathEntry rte;
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 1 && (rte = this.convertClasspathEntry(entry)) != null) {
                result.add(rte);
            }
            ++i;
        }
    }

    private IRuntimeClasspathEntry convertClasspathEntry(IClasspathEntry entry) {
        if (entry == null) {
            return null;
        }
        IPath srcPath = entry.getSourceAttachmentPath();
        if (srcPath != null && srcPath.segmentCount() > 0) {
            IRuntimeClasspathEntry rte = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)entry.getPath());
            rte.setSourceAttachmentPath(srcPath);
            rte.setSourceAttachmentRootPath(entry.getSourceAttachmentRootPath());
            return rte;
        }
        return null;
    }

    private boolean isPerfectMatch(IPluginModelBase model, IPath path) {
        return model == null ? false : path.equals((Object)new Path(model.getInstallLocation()));
    }

    private ISourceContainer getArchiveSourceContainer(String location) throws JavaModelException {
        IWorkspaceRoot root = PDEPlugin.getWorkspace().getRoot();
        IFile[] containers = root.findFilesForLocation((IPath)new Path(location));
        int i = 0;
        while (i < containers.length) {
            IPackageFragmentRoot archive;
            IPath path;
            IJavaElement element = JavaCore.create((IFile)containers[i]);
            if (element instanceof IPackageFragmentRoot && (path = (archive = (IPackageFragmentRoot)element).getSourceAttachmentPath()) != null && path.segmentCount() != 0) {
                IPath rootPath = archive.getSourceAttachmentRootPath();
                boolean detectRootPath = rootPath != null && rootPath.segmentCount() > 0;
                IFile archiveFile = root.getFile(path);
                if (archiveFile.exists()) {
                    return new ArchiveSourceContainer(archiveFile, detectRootPath);
                }
                File file = path.toFile();
                if (file.exists()) {
                    return new ExternalArchiveSourceContainer(file.getAbsolutePath(), detectRootPath);
                }
            }
            ++i;
        }
        return null;
    }

    private static String generateSourceName(String qualifiedTypeName) {
        int index = qualifiedTypeName.indexOf(36);
        if (index >= 0) {
            qualifiedTypeName = qualifiedTypeName.substring(0, index);
        }
        return String.valueOf(qualifiedTypeName.replace('.', File.separatorChar)) + ".java";
    }
}

