/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.core.plugin.TargetPlatform;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.ui.PDEPlugin;

public class LaunchConfigurationHelper {
    public static void synchronizeManifests(ILaunchConfiguration config, File configDir) {
        try {
            String programArgs = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROGRAM_ARGUMENTS, "");
            if (programArgs.indexOf("-clean") != -1) {
                return;
            }
        }
        catch (CoreException coreException) {}
        File dir = new File(configDir, "org.eclipse.osgi/manifests");
        if (dir.exists() && dir.isDirectory()) {
            PDECore.getDefault().getJavaElementChangeListener().synchronizeManifests(dir);
        }
    }

    public static File getConfigurationArea(ILaunchConfiguration config) {
        File dir = LaunchConfigurationHelper.getConfigurationLocation(config);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        return dir;
    }

    public static File getConfigurationLocation(ILaunchConfiguration config) {
        File dir = new File(PDECore.getDefault().getStateLocation().toOSString(), config.getName());
        try {
            String userPath;
            if (!config.getAttribute("useDefaultConfigArea", true) && (userPath = config.getAttribute("configLocation", null)) != null) {
                userPath = LaunchConfigurationHelper.getSubstitutedString(userPath);
                dir = new File(userPath).getAbsoluteFile();
            }
        }
        catch (CoreException coreException) {}
        return dir;
    }

    private static String getSubstitutedString(String text) throws CoreException {
        if (text == null) {
            return "";
        }
        IStringVariableManager mgr = VariablesPlugin.getDefault().getStringVariableManager();
        return mgr.performStringSubstitution(text);
    }

    public static Properties createConfigIniFile(ILaunchConfiguration configuration, String productID, Map map, File directory) throws CoreException {
        Properties properties = null;
        if (configuration.getAttribute("useDefaultConfig", true)) {
            properties = TargetPlatformHelper.getConfigIniProperties();
            if (properties == null) {
                properties = new Properties();
            } else if (productID == null || !productID.equals(properties.get("eclipse.product"))) {
                properties.clear();
            }
            String bundleList = properties.getProperty("osgi.bundles");
            if (bundleList != null) {
                properties.setProperty("osgi.bundles", LaunchConfigurationHelper.computeOSGiBundles(TargetPlatformHelper.stripPathInformation((String)bundleList), map));
            }
        } else {
            String osgiBundles;
            String templateLoc = configuration.getAttribute("templateConfig", null);
            if (templateLoc != null && (osgiBundles = (properties = LaunchConfigurationHelper.loadFromTemplate(LaunchConfigurationHelper.getSubstitutedString(templateLoc))).getProperty("osgi.bundles")) != null) {
                properties.setProperty("osgi.bundles", TargetPlatformHelper.stripPathInformation((String)osgiBundles));
            }
        }
        if (properties != null) {
            LaunchConfigurationHelper.addRequiredProperties(properties, productID, map);
        } else {
            properties = new Properties();
        }
        LaunchConfigurationHelper.setBundleLocations(map, properties);
        if (!directory.exists()) {
            directory.mkdirs();
        }
        LaunchConfigurationHelper.save(new File(directory, "config.ini"), properties);
        return properties;
    }

    private static void addRequiredProperties(Properties properties, String productID, Map map) {
        if (!properties.containsKey("osgi.install.area")) {
            properties.setProperty("osgi.install.area", "file:" + TargetPlatform.getLocation());
        }
        if (!properties.containsKey("osgi.configuration.cascaded")) {
            properties.setProperty("osgi.configuration.cascaded", "false");
        }
        if (!properties.containsKey("osgi.framework")) {
            properties.setProperty("osgi.framework", "org.eclipse.osgi");
        }
        if (!properties.containsKey("osgi.splashPath") && productID != null) {
            LaunchConfigurationHelper.addSplashLocation(properties, productID, map);
        }
        if (properties.containsKey("osgi.splashPath")) {
            LaunchConfigurationHelper.resolveLocationPath(properties.getProperty("osgi.splashPath"), properties, map);
        }
        if (!properties.containsKey("osgi.bundles")) {
            properties.setProperty("osgi.bundles", LaunchConfigurationHelper.computeOSGiBundles(TargetPlatform.getBundleList(), map));
        }
        if (!properties.containsKey("osgi.bundles.defaultStartLevel")) {
            properties.setProperty("osgi.bundles.defaultStartLevel", "4");
        }
    }

    private static String computeOSGiBundles(String bundleList, Map map) {
        StringBuffer buffer = new StringBuffer();
        HashSet<String> initialBundleSet = new HashSet<String>();
        StringTokenizer tokenizer = new StringTokenizer(bundleList, ",");
        while (tokenizer.hasMoreTokens()) {
            String id;
            String token = tokenizer.nextToken();
            int index = token.indexOf(64);
            String string = id = index != -1 ? token.substring(0, index) : token;
            if (!map.containsKey(id)) continue;
            if (buffer.length() > 0) {
                buffer.append(',');
            }
            buffer.append(id);
            if (index != -1 && index < token.length() - 1) {
                buffer.append(token.substring(index));
            }
            initialBundleSet.add(id);
        }
        if (!initialBundleSet.contains("org.eclipse.update.configurator")) {
            initialBundleSet.add("org.eclipse.osgi");
            Iterator iter = map.keySet().iterator();
            while (iter.hasNext()) {
                String id = iter.next().toString();
                if (initialBundleSet.contains(id)) continue;
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                buffer.append(id);
            }
        }
        return buffer.toString();
    }

    private static Properties loadFromTemplate(String templateLoc) throws CoreException {
        Properties properties;
        block16: {
            properties = new Properties();
            File templateFile = new File(templateLoc);
            if (templateFile.exists() && templateFile.isFile()) {
                FileInputStream stream = null;
                try {
                    try {
                        stream = new FileInputStream(templateFile);
                        properties.load(stream);
                    }
                    catch (Exception e) {
                        String message = e.getMessage();
                        if (message != null) {
                            throw new CoreException((IStatus)new Status(4, PDEPlugin.getPluginId(), 4, message, (Throwable)e));
                        }
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException iOException) {}
                        }
                        break block16;
                    }
                }
                catch (Throwable throwable) {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return properties;
    }

    private static void addSplashLocation(Properties properties, String productID, Map map) {
        String targetSplash;
        Properties targetConfig = TargetPlatformHelper.getConfigIniProperties();
        String targetProduct = targetConfig == null ? null : targetConfig.getProperty("eclipse.product");
        String string = targetSplash = targetConfig == null ? null : targetConfig.getProperty("osgi.splashPath");
        if (!productID.equals(targetProduct) || targetSplash == null) {
            BundleDescription desc;
            ArrayList<String> locations = new ArrayList<String>();
            String plugin = LaunchConfigurationHelper.getContributingPlugin(productID);
            locations.add(plugin);
            IPluginModelBase model = (IPluginModelBase)map.get(plugin);
            if (model != null && (desc = model.getBundleDescription()) != null) {
                BundleDescription[] fragments = desc.getFragments();
                int i = 0;
                while (i < fragments.length) {
                    locations.add(fragments[i].getSymbolicName());
                    ++i;
                }
            }
            LaunchConfigurationHelper.resolveLocationPath(locations, properties, map);
        } else {
            LaunchConfigurationHelper.resolveLocationPath(targetSplash, properties, map);
        }
    }

    private static void resolveLocationPath(String splashPath, Properties properties, Map map) {
        ArrayList<String> locations = new ArrayList<String>();
        StringTokenizer tok = new StringTokenizer(splashPath, ",");
        while (tok.hasMoreTokens()) {
            locations.add(tok.nextToken());
        }
        LaunchConfigurationHelper.resolveLocationPath(locations, properties, map);
    }

    private static void resolveLocationPath(ArrayList locations, Properties properties, Map map) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < locations.size()) {
            String url;
            String location = (String)locations.get(i);
            if (location.startsWith("platform:/base/plugins/")) {
                location = location.replaceFirst("platform:/base/plugins/", "");
            }
            if ((url = LaunchConfigurationHelper.getBundleURL(location, map)) != null) {
                if (buffer.length() > 0) {
                    buffer.append(",");
                }
                buffer.append(url);
            }
            ++i;
        }
        if (buffer.length() > 0) {
            properties.setProperty("osgi.splashPath", buffer.toString());
        }
    }

    public static String getBundleURL(String id, Map pluginMap) {
        IPluginModelBase model = (IPluginModelBase)pluginMap.get(id.trim());
        return LaunchConfigurationHelper.getBundleURL(model);
    }

    public static String getBundleURL(IPluginModelBase model) {
        if (model == null) {
            return null;
        }
        return "file:" + new Path(model.getInstallLocation()).removeTrailingSeparator().toString();
    }

    private static void setBundleLocations(Map map, Properties properties) {
        String bundles;
        String framework = properties.getProperty("osgi.framework");
        if (framework != null) {
            String url;
            if (framework.startsWith("platform:/base/plugins/")) {
                framework.replaceFirst("platform:/base/plugins/", "");
            }
            if ((url = LaunchConfigurationHelper.getBundleURL(framework, map)) != null) {
                properties.setProperty("osgi.framework", url);
            }
        }
        if ((bundles = properties.getProperty("osgi.bundles")) != null) {
            StringBuffer buffer = new StringBuffer();
            StringTokenizer tokenizer = new StringTokenizer(bundles, ",");
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken().trim();
                String url = LaunchConfigurationHelper.getBundleURL(token, map);
                int index = -1;
                if (url == null) {
                    index = token.indexOf(64);
                    if (index != -1) {
                        url = LaunchConfigurationHelper.getBundleURL(token.substring(0, index), map);
                    }
                    if (url == null && (index = token.indexOf(58)) != -1) {
                        url = LaunchConfigurationHelper.getBundleURL(token.substring(0, index), map);
                    }
                }
                if (url == null) continue;
                if (buffer.length() > 0) {
                    buffer.append(",");
                }
                buffer.append("reference:" + url);
                if (index == -1) continue;
                buffer.append(token.substring(index));
            }
            properties.setProperty("osgi.bundles", buffer.toString());
        }
    }

    public static void save(File file, Properties properties) {
        try {
            FileOutputStream stream = new FileOutputStream(file);
            properties.store(stream, "Configuration File");
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            PDECore.logException((Throwable)e);
        }
    }

    public static String getContributingPlugin(String productID) {
        if (productID == null) {
            return null;
        }
        int index = productID.lastIndexOf(46);
        return index == -1 ? productID : productID.substring(0, index);
    }

    public static String getProductID(ILaunchConfiguration configuration) throws CoreException {
        if (configuration.getAttribute("useProduct", false)) {
            return configuration.getAttribute("product", null);
        }
        String appID = configuration.getAttribute("application", TargetPlatform.getDefaultApplication());
        IPluginModelBase[] plugins = PluginRegistry.getActiveModels();
        int i = 0;
        while (i < plugins.length) {
            String id = plugins[i].getPluginBase().getId();
            IPluginExtension[] extensions = plugins[i].getPluginBase().getExtensions();
            int j = 0;
            while (j < extensions.length) {
                IPluginObject[] children;
                String point = extensions[j].getPoint();
                String extId = extensions[j].getId();
                if ("org.eclipse.core.runtime.products".equals(point) && extId != null && (children = extensions[j].getChildren()).length == 1 && "product".equals(children[0].getName()) && appID.equals(((IPluginElement)children[0]).getAttribute("application").getValue())) {
                    return String.valueOf(id) + "." + extId;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }
}

