/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.launcher;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.launcher.VMHelper;
import org.eclipse.pde.internal.ui.preferences.PDEPreferencesUtil;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class JREBlock {
    private AbstractLauncherTab fTab;
    private Listener fListener = new Listener();
    private Button fJavawButton;
    private Button fJavaButton;
    private Combo fJreCombo;
    private Text fBootstrap;

    public JREBlock(AbstractLauncherTab tab) {
        this.fTab = tab;
    }

    public void createControl(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText(PDEUIMessages.MainTab_jreSection);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)new GridData(768));
        this.createJavaExecutableSection((Composite)group);
        this.createJRESection((Composite)group);
        this.createBootstrapEntriesSection((Composite)group);
    }

    protected void createJRESection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PDEUIMessages.BasicLauncherTab_jre);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.fJreCombo = new Combo(composite, 12);
        this.fJreCombo.setLayoutData((Object)new GridData(768));
        this.fJreCombo.addSelectionListener((SelectionListener)this.fListener);
        Button button = new Button(composite, 8);
        button.setText(PDEUIMessages.BasicLauncherTab_installedJREs);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String currentVM = JREBlock.this.fJreCombo.getText();
                boolean useDefault = VMHelper.getDefaultVMInstallName().equals(currentVM);
                String[] pageIDs = new String[]{"org.eclipse.jdt.debug.ui.preferences.VMPreferencePage"};
                if (PDEPreferencesUtil.showPreferencePage(pageIDs, JREBlock.this.fTab.getControl().getShell())) {
                    JREBlock.this.setJRECombo();
                    if (useDefault || JREBlock.this.fJreCombo.indexOf(currentVM) == -1) {
                        JREBlock.this.fJreCombo.setText(VMHelper.getDefaultVMInstallName());
                    } else {
                        JREBlock.this.fJreCombo.setText(currentVM);
                    }
                }
            }
        });
        button.setLayoutData((Object)new GridData(128));
        SWTUtil.setButtonDimensionHint(button);
    }

    protected void createJavaExecutableSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PDEUIMessages.BasicLauncherTab_javaExec);
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 20;
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)new GridData(768));
        this.fJavawButton = new Button(composite, 16);
        this.fJavawButton.setText(PDEUIMessages.BasicLauncherTab_javaExecDefault);
        this.fJavawButton.addSelectionListener((SelectionListener)this.fListener);
        this.fJavaButton = new Button(composite, 16);
        this.fJavaButton.setText("&java");
        this.fJavaButton.addSelectionListener((SelectionListener)this.fListener);
    }

    private void createBootstrapEntriesSection(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PDEUIMessages.BasicLauncherTab_bootstrap);
        this.fBootstrap = new Text(parent, 2048);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.fBootstrap.setLayoutData((Object)gd);
        this.fBootstrap.addModifyListener((ModifyListener)this.fListener);
    }

    public void initializeFrom(ILaunchConfiguration config) throws CoreException {
        this.initializeJRESection(config);
        this.initializeBootstrapEntriesSection(config);
    }

    private void initializeJRESection(ILaunchConfiguration config) throws CoreException {
        String javaCommand = config.getAttribute(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND, "javaw");
        this.fJavawButton.setSelection(javaCommand.equals("javaw"));
        this.fJavaButton.setSelection(!this.fJavawButton.getSelection());
        this.setJRECombo();
        String vmInstallName = config.getAttribute("vminstall", VMHelper.getDefaultVMInstallName());
        this.fJreCombo.setText(vmInstallName);
        if (this.fJreCombo.getSelectionIndex() == -1) {
            this.fJreCombo.setText(VMHelper.getDefaultVMInstallName());
        }
    }

    private void initializeBootstrapEntriesSection(ILaunchConfiguration config) throws CoreException {
        this.fBootstrap.setText(config.getAttribute("bootstrap", ""));
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        this.saveJRESection(config);
        this.saveBootstrapEntriesSection(config);
    }

    protected void saveJRESection(ILaunchConfigurationWorkingCopy config) {
        try {
            String javaCommand = this.fJavawButton.getSelection() ? null : "java";
            config.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JAVA_COMMAND, javaCommand);
            if (this.fJreCombo.getSelectionIndex() == -1) {
                return;
            }
            String jre = this.fJreCombo.getText();
            if (config.getAttribute("vminstall", null) != null) {
                config.setAttribute("vminstall", jre);
            } else {
                config.setAttribute("vminstall", jre.equals(VMHelper.getDefaultVMInstallName()) ? null : jre);
            }
        }
        catch (CoreException coreException) {}
    }

    protected void saveBootstrapEntriesSection(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("bootstrap", this.fBootstrap.getText().trim());
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute("bootstrap", "");
    }

    private void setJRECombo() {
        String[] jres = VMHelper.getVMInstallNames();
        Arrays.sort(jres, new Comparator(){

            public int compare(Object arg0, Object arg1) {
                return arg0.toString().compareTo(arg1.toString());
            }
        });
        this.fJreCombo.setItems(jres);
    }

    class Listener
    extends SelectionAdapter
    implements ModifyListener {
        Listener() {
        }

        public void widgetSelected(SelectionEvent e) {
            JREBlock.this.fTab.updateLaunchConfigurationDialog();
        }

        public void modifyText(ModifyEvent e) {
            JREBlock.this.fTab.updateLaunchConfigurationDialog();
        }
    }
}

